/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.common;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.AbstractCommonIdentifier;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import java.util.Collection;
import java.util.HashSet;

public class IdentifierPermissionSetProvider
extends AbstractCommonIdentifier
implements Identifier,
Comparable<IdentifierPermissionSetProvider> {
    private final PermissionSet permissionSet;

    public static Collection<IdentifierPermissionSetProvider> getIdentifiers(IdentifierBundle ids) {
        return IdentifierPermissionSetProvider.getIdentifiersForClass(ids, IdentifierPermissionSetProvider.class);
    }

    public static Collection<PermissionSet> getPermissionSets(IdentifierBundle ids) {
        HashSet<PermissionSet> set = new HashSet<PermissionSet>();
        for (IdentifierPermissionSetProvider id : IdentifierPermissionSetProvider.getIdentifiers(ids)) {
            set.add(id.getPermissionSet());
        }
        return set;
    }

    public static Collection<String> getPermissionSetUris(IdentifierBundle ids) {
        HashSet<String> set = new HashSet<String>();
        for (IdentifierPermissionSetProvider id : IdentifierPermissionSetProvider.getIdentifiers(ids)) {
            set.add(id.getPermissionSet().getUri());
        }
        return set;
    }

    public IdentifierPermissionSetProvider(PermissionSet permissionSet) {
        if (permissionSet == null) {
            throw new NullPointerException("permissionSet may not be null.");
        }
        this.permissionSet = permissionSet;
    }

    public PermissionSet getPermissionSet() {
        return this.permissionSet;
    }

    public String toString() {
        return "HasPermissionSet[" + this.permissionSet.getLabel() + "]";
    }

    public int hashCode() {
        return this.permissionSet.getUri().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentifierPermissionSetProvider)) {
            return false;
        }
        IdentifierPermissionSetProvider that = (IdentifierPermissionSetProvider)obj;
        return this.permissionSet.getUri().equals(that.permissionSet.getUri());
    }

    @Override
    public int compareTo(IdentifierPermissionSetProvider that) {
        return this.permissionSet.getUri().compareTo(that.permissionSet.getUri());
    }
}

