/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObjectStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.Optional;
import org.apache.jena.rdf.model.Model;

public abstract class AccessObject {
    public static String SOME_URI = "?SOME_URI";
    public static Property SOME_PREDICATE = new Property(SOME_URI);
    public static String SOME_LITERAL = "?SOME_LITERAL";
    private Model model = null;
    protected AccessObjectStatement statement;
    private DataProperty dataProperty;
    private ObjectProperty objectProperty;

    public Optional<ObjectProperty> getObjectProperty() {
        if (this.objectProperty != null) {
            return Optional.of(this.objectProperty);
        }
        return Optional.empty();
    }

    public void setObjectProperty(ObjectProperty objectProperty) {
        this.objectProperty = objectProperty;
    }

    public Optional<String> getUri() {
        return Optional.empty();
    }

    public abstract AccessObjectType getType();

    public Optional<AccessObjectStatement> getStatement() {
        if (this.statement == null) {
            return Optional.empty();
        }
        return Optional.of(this.statement);
    }

    protected void initializeStatement() {
        if (this.statement == null) {
            this.statement = new AccessObjectStatement();
        }
    }

    public void setModel(Model ontModel) {
        this.model = ontModel;
    }

    public Model getModel() {
        return this.model;
    }

    public void setStatementSubject(String subject) {
        this.initializeStatement();
        this.statement.setSubject(subject);
    }

    public String getStatementSubject() {
        this.initializeStatement();
        return this.statement.getSubject();
    }

    public void setStatementPredicate(Property predicate) {
        this.initializeStatement();
        this.statement.setPredicate(predicate);
    }

    protected Property getPredicate() {
        this.initializeStatement();
        return this.statement.getPredicate();
    }

    public String getStatementPredicateUri() {
        if (this.statement == null || this.statement.getPredicate() == null) {
            return null;
        }
        Property predicate = this.getPredicate();
        return predicate.getURI();
    }

    public void setStatementObject(String objectUri) {
        this.initializeStatement();
        this.statement.setObject(objectUri);
    }

    public String getStatementObject() {
        this.initializeStatement();
        return this.statement.getObject();
    }

    public Optional<DataProperty> getDataProperty() {
        if (this.dataProperty == null) {
            return Optional.empty();
        }
        return Optional.of(this.dataProperty);
    }

    public void setDataProperty(DataProperty dataProperty) {
        this.dataProperty = dataProperty;
    }

    public String[] getResourceUris() {
        this.initializeStatement();
        return this.statement.getResourceUris(this.getType());
    }
}

