/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxDataPropertyWrapper;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataPropertyAccessObject
extends AccessObject {
    private static final Log log = LogFactory.getLog(DataPropertyAccessObject.class);

    public DataPropertyAccessObject(DataProperty dataProperty) {
        this.setDataProperty(dataProperty);
        this.debug(dataProperty);
    }

    @Override
    public Optional<String> getUri() {
        Optional<DataProperty> dp = this.getDataProperty();
        if (dp.isPresent()) {
            String uri = dp.get().getURI();
            if (uri == null) {
                return Optional.empty();
            }
            return Optional.of(uri);
        }
        return Optional.empty();
    }

    @Override
    public AccessObjectType getType() {
        return AccessObjectType.DATA_PROPERTY;
    }

    public String toString() {
        Optional<DataProperty> dp = this.getDataProperty();
        return this.getClass().getSimpleName() + ": " + (!dp.isPresent() ? "not present" : dp.get().getURI());
    }

    private void debug(DataProperty dataProperty) {
        Throwable t;
        if (dataProperty instanceof FauxDataPropertyWrapper) {
            t = new Throwable();
            log.error((Object)"FauxDataPropertyWrapper provided in DataPropertyAccessObject constructor");
            log.error((Object)t, t);
        }
        if (dataProperty == null) {
            t = new Throwable();
            log.error((Object)"null provided in DataPropertyAccessObject constructor");
            log.error((Object)t, t);
        }
    }
}

