/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;

public class DataPropertyStatementAccessObject
extends AccessObject {
    public DataPropertyStatementAccessObject(OntModel ontModel, String subjectUri, String predicateUri, String dataValue) {
        this.setModel((Model)ontModel);
        this.setStatementSubject(subjectUri);
        this.setStatementPredicate(new Property(predicateUri));
        this.setStatementObject(dataValue);
    }

    public DataPropertyStatementAccessObject(OntModel ontModel, String subjectUri, Property predicate, String dataValue) {
        this.setModel((Model)ontModel);
        this.setStatementSubject(subjectUri);
        this.setStatementPredicate(predicate);
        this.setStatementObject(dataValue);
    }

    public DataPropertyStatementAccessObject(OntModel ontModel, DataPropertyStatement dps) {
        this.setModel((Model)ontModel);
        this.setStatementSubject(dps.getIndividual() == null ? dps.getIndividualURI() : dps.getIndividual().getURI());
        this.setStatementPredicate(new Property(dps.getDatapropURI()));
        this.setStatementObject(dps.getData());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": <" + this.getStatementSubject() + "> <" + this.getStatementPredicateUri() + "> <" + this.getStatementObject() + ">";
    }

    @Override
    public AccessObjectType getType() {
        return AccessObjectType.DATA_PROPERTY_STATEMENT;
    }
}

