/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxDataPropertyWrapper;
import java.util.Optional;

public class FauxDataPropertyAccessObject
extends AccessObject {
    public FauxDataPropertyAccessObject(DataProperty dataProperty) {
        this.setDataProperty(dataProperty);
    }

    @Override
    public AccessObjectType getType() {
        return AccessObjectType.FAUX_DATA_PROPERTY;
    }

    @Override
    public Optional<String> getUri() {
        Optional<DataProperty> dp = this.getDataProperty();
        if (!dp.isPresent()) {
            return Optional.empty();
        }
        DataProperty property = dp.get();
        if (property instanceof FauxDataPropertyWrapper) {
            String uri = ((FauxDataPropertyWrapper)property).getConfigUri();
            if (uri == null) {
                return Optional.empty();
            }
            return Optional.of(uri);
        }
        String uri = property.getURI();
        if (uri == null) {
            return Optional.empty();
        }
        return Optional.of(uri);
    }

    public String toString() {
        Optional<DataProperty> dp = this.getDataProperty();
        DataProperty property = dp.get();
        if (property instanceof FauxDataPropertyWrapper) {
            return this.getClass().getSimpleName() + ": " + ((FauxDataPropertyWrapper)property).getConfigUri();
        }
        return this.getClass().getSimpleName() + ": " + (!dp.isPresent() ? "not present" : dp.get().getURI());
    }
}

