/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxObjectPropertyWrapper;
import java.util.Optional;

public class FauxObjectPropertyAccessObject
extends AccessObject {
    public FauxObjectPropertyAccessObject(ObjectProperty objectProperty) {
        this.setObjectProperty(objectProperty);
    }

    @Override
    public AccessObjectType getType() {
        return AccessObjectType.FAUX_OBJECT_PROPERTY;
    }

    @Override
    public Optional<String> getUri() {
        Optional<ObjectProperty> op = this.getObjectProperty();
        if (!op.isPresent()) {
            return Optional.empty();
        }
        ObjectProperty property = op.get();
        if (property instanceof FauxObjectPropertyWrapper) {
            String uri = ((FauxObjectPropertyWrapper)property).getConfigUri();
            if (uri == null) {
                return Optional.empty();
            }
            return Optional.of(uri);
        }
        String uri = property.getURI();
        if (uri == null) {
            return Optional.empty();
        }
        return Optional.of(uri);
    }

    public String toString() {
        Optional<ObjectProperty> op = this.getObjectProperty();
        if (!op.isPresent()) {
            return this.getClass().getSimpleName() + ": Object property is not present.";
        }
        ObjectProperty property = op.get();
        if (property instanceof FauxObjectPropertyWrapper) {
            return this.getClass().getSimpleName() + ": " + ((FauxObjectPropertyWrapper)property).getConfigUri();
        }
        return this.getClass().getSimpleName() + ": " + (property == null ? "not present." : property.getURI());
    }
}

