/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import java.util.Optional;

public class NamedAccessObject
extends AccessObject {
    private final String uri;

    public NamedAccessObject() {
        this.uri = "";
    }

    public NamedAccessObject(String uri) {
        this.uri = uri;
    }

    @Override
    public Optional<String> getUri() {
        if (this.uri == null) {
            return Optional.empty();
        }
        return Optional.of(this.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof NamedAccessObject) {
            NamedAccessObject that = (NamedAccessObject)o;
            return this.equivalent(this.uri, that.uri);
        }
        return false;
    }

    private boolean equivalent(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public String toString() {
        return NamedAccessObject.getShortName(this.uri);
    }

    @Override
    public AccessObjectType getType() {
        return AccessObjectType.NAMED_OBJECT;
    }

    private static String getShortName(String entityUri) {
        return entityUri.substring(entityUri.lastIndexOf(35) + 1);
    }
}

