/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.objects;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxObjectPropertyWrapper;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectPropertyAccessObject
extends AccessObject {
    private static final Log log = LogFactory.getLog(ObjectPropertyAccessObject.class);

    public ObjectPropertyAccessObject(ObjectProperty objectProperty) {
        this.setObjectProperty(objectProperty);
        this.debug(objectProperty);
    }

    @Override
    public Optional<String> getUri() {
        Optional<ObjectProperty> op = this.getObjectProperty();
        if (op.isPresent()) {
            String uri = op.get().getURI();
            if (uri == null) {
                return Optional.empty();
            }
            return Optional.of(uri);
        }
        return Optional.empty();
    }

    @Override
    public AccessObjectType getType() {
        return AccessObjectType.OBJECT_PROPERTY;
    }

    public String toString() {
        Optional<ObjectProperty> op = this.getObjectProperty();
        return this.getClass().getSimpleName() + ": " + (!op.isPresent() ? "not present." : op.get().getURI());
    }

    private void debug(ObjectProperty property) {
        Throwable t;
        if (property instanceof FauxObjectPropertyWrapper) {
            t = new Throwable();
            log.error((Object)"FauxObjectPropertyWrapper provided in ObjectPropertyAccessObject constructor");
            log.error((Object)t, t);
        }
        if (property == null) {
            t = new Throwable();
            log.error((Object)"null provided in ObjectPropertyAccessObject constructor");
            log.error((Object)t, t);
        }
    }
}

