/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Policy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicPolicy
implements Policy {
    private static final Log log = LogFactory.getLog(DynamicPolicy.class);
    private String uri;
    private long priority;
    private Set<AccessRule> rules = Collections.synchronizedSet(new HashSet());

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getShortUri() {
        return DynamicPolicy.shortenUri(this.uri);
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public Set<AccessRule> getRules() {
        return this.rules;
    }

    public void addRules(Collection<AccessRule> collection) {
        this.rules.addAll(collection);
    }

    public DynamicPolicy(String uri, long priority) {
        this.uri = uri;
        this.priority = priority;
    }

    @Override
    public PolicyDecision decide(AuthorizationRequest ar) {
        AccessObject whatToAuth = ar.getAccessObject();
        if (whatToAuth == null) {
            return this.defaultDecision("whatToAuth was null");
        }
        for (AccessRule rule : this.getFilteredRules(ar)) {
            String policyUri = DynamicPolicy.shortenUri(this.uri);
            String ruleUri = DynamicPolicy.shortenUri(rule.getRuleUri());
            if (rule.match(ar)) {
                if (rule.isAllowMatched()) {
                    DynamicPolicy.debug("Policy '" + policyUri + "' rule '" + ruleUri + "' approved request " + ar);
                    String message = "Policy '" + policyUri + "' rule '" + ruleUri + "' approved " + ar;
                    return new BasicPolicyDecision(DecisionResult.AUTHORIZED, message);
                }
                DynamicPolicy.debug("Policy '" + policyUri + "' rule " + ruleUri + " rejected request " + ar);
                String message = "Policy '" + policyUri + "' rule '" + ruleUri + "' rejected request" + ar;
                return new BasicPolicyDecision(DecisionResult.UNAUTHORIZED, message);
            }
            DynamicPolicy.debug("Policy '" + policyUri + "' rule '" + ruleUri + "' didn't match request " + ar);
        }
        return this.defaultDecision("no permission will approve " + whatToAuth);
    }

    public Set<AccessRule> getFilteredRules(AuthorizationRequest ar) {
        return this.rules;
    }

    private PolicyDecision defaultDecision(String message) {
        return new BasicPolicyDecision(DecisionResult.INCONCLUSIVE, message);
    }

    private static String shortenUri(String uri) {
        if (uri.startsWith("https://vivoweb.org/ontology/vitro-application/auth/individual/")) {
            return "access-individual:" + uri.substring("https://vivoweb.org/ontology/vitro-application/auth/individual/".length());
        }
        return uri;
    }

    private static void debug(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }
}

