/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueKey;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSetRegistry;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityPolicyController {
    private static final Log log = LogFactory.getLog(EntityPolicyController.class);
    private static Map<String, String> policyKeyToDataValueMap = new HashMap<String, String>();

    public static void updateEntityDataSet(String entityUri, AccessObjectType aot, AccessOperation ao, List<String> selectedRoles, List<String> roles) {
        if (StringUtils.isBlank((CharSequence)entityUri)) {
            return;
        }
        HashSet<String> selectedSet = new HashSet<String>(selectedRoles);
        for (String role : roles) {
            if (selectedSet.contains(role)) {
                EntityPolicyController.grantAccess(entityUri, aot, ao, role, new String[0]);
                continue;
            }
            EntityPolicyController.revokeAccess(entityUri, aot, ao, role, new String[0]);
        }
    }

    private static AttributeValueSetRegistry getRegistry() {
        return AttributeValueSetRegistry.getInstance();
    }

    public static void revokeAccess(String entityUri, AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        AttributeValueKey key = new AttributeValueKey(ao, aot, role, aot.toString(), namedKeyComponents);
        AttributeValueSet set = EntityPolicyController.getRegistry().get(key);
        if (set != null) {
            if (set.contains(entityUri)) {
                set.remove(entityUri);
                String toRemove = EntityPolicyController.getValueStatementString(entityUri, set.getValueSetUri());
                EntityPolicyController.getLoader().updateAccessControlModel(toRemove, false);
            }
        } else {
            EntityPolicyController.reduceInactiveValueSet(entityUri, aot, ao, role, namedKeyComponents);
        }
    }

    private static PolicyLoader getLoader() {
        return PolicyLoader.getInstance();
    }

    private static void reduceInactiveValueSet(String entityUri, AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        StringBuilder removals = new StringBuilder();
        EntityPolicyController.getDataValueStatements(entityUri, aot, ao, Collections.singleton(role), removals, namedKeyComponents);
        EntityPolicyController.getLoader().updateAccessControlModel(removals.toString(), false);
    }

    public static void grantAccess(String entityUri, AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        AttributeValueKey key = new AttributeValueKey(ao, aot, role, aot.toString(), namedKeyComponents);
        AttributeValueSet set = EntityPolicyController.getRegistry().get(key);
        if (set != null) {
            if (!set.contains(entityUri)) {
                set.add(entityUri);
                String toAdd = EntityPolicyController.getValueStatementString(entityUri, set.getValueSetUri());
                EntityPolicyController.getLoader().updateAccessControlModel(toAdd, true);
            }
        } else {
            EntityPolicyController.extendInactiveValueSet(entityUri, aot, ao, role, namedKeyComponents);
            EntityPolicyController.loadPolicy(aot, ao, role, namedKeyComponents);
        }
    }

    private static void loadPolicy(AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        DynamicPolicy policy;
        String[] ids = Arrays.copyOf(namedKeyComponents, namedKeyComponents.length + 3);
        ids[ids.length - 1] = ao.toString();
        ids[ids.length - 2] = aot.toString();
        ids[ids.length - 3] = role;
        String dataSetUri = EntityPolicyController.getLoader().getDataSetUriByKey(ids);
        if (dataSetUri != null && (policy = EntityPolicyController.getLoader().loadPolicyFromTemplateDataSet(dataSetUri)) != null) {
            PolicyStore.getInstance().add(policy);
        }
    }

    private static void extendInactiveValueSet(String entityUri, AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        StringBuilder additions = new StringBuilder();
        EntityPolicyController.getDataValueStatements(entityUri, aot, ao, Collections.singleton(role), additions, namedKeyComponents);
        EntityPolicyController.getLoader().updateAccessControlModel(additions.toString(), true);
    }

    public static boolean isGranted(String entityUri, AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        AttributeValueKey key;
        if (StringUtils.isBlank((CharSequence)entityUri)) {
            return false;
        }
        AttributeValueSetRegistry registry = EntityPolicyController.getRegistry();
        AttributeValueSet set = registry.get(key = new AttributeValueKey(ao, aot, role, aot.toString(), namedKeyComponents));
        if (set == null) {
            return false;
        }
        return set.contains(entityUri);
    }

    public static List<String> getGrantedRoles(String entityUri, AccessOperation ao, AccessObjectType aot, List<String> allRoles) {
        if (StringUtils.isBlank((CharSequence)entityUri)) {
            return Collections.emptyList();
        }
        LinkedList<String> grantedRoles = new LinkedList<String>();
        for (String role : allRoles) {
            if (!EntityPolicyController.isUriInTestDataset(entityUri, ao, aot, role)) continue;
            grantedRoles.add(role);
        }
        return grantedRoles;
    }

    public static void getDataValueStatements(String entityUri, AccessObjectType aot, AccessOperation ao, Set<String> selectedRoles, StringBuilder sb, String ... namedKeyComponents) {
        if (StringUtils.isBlank((CharSequence)entityUri)) {
            return;
        }
        for (String role : selectedRoles) {
            String valueSetUri = EntityPolicyController.getValueSetUri(aot, ao, role, namedKeyComponents);
            if (valueSetUri == null) {
                log.debug((Object)String.format("Policy value set wasn't found by key:\n%s\n%s\n%s", new Object[]{ao, aot, role}));
                continue;
            }
            sb.append(EntityPolicyController.getValueStatementString(entityUri, valueSetUri));
        }
    }

    private static String getValueStatementString(String entityUri, String valueSetUri) {
        return "<" + valueSetUri + "> <" + "https://vivoweb.org/ontology/vitro-application/auth/vocabulary/" + "value> <" + entityUri + "> .\n";
    }

    public static void deletedEntityEvent(Property oldObj) {
        log.debug((Object)("Don't delete access rule if property has been deleted " + oldObj));
    }

    public static void updatedEntityEvent(Object oldObj, Object newObj) {
        if (oldObj instanceof Property || newObj instanceof Property) {
            log.debug((Object)("update entity event old " + oldObj + " new object " + newObj));
        }
    }

    public static void insertedEntityEvent(Property newObj) {
        log.debug((Object)("Nothing to do " + newObj));
    }

    private static boolean isUriInTestDataset(String entityUri, AccessOperation ao, AccessObjectType aot, String role) {
        Set<String> values = EntityPolicyController.getLoader().getDataSetValues(ao, aot, role);
        return values.contains(entityUri);
    }

    private static String getValueSetUri(AccessObjectType aot, AccessOperation ao, String role, String ... namedKeyComponents) {
        String key = EntityPolicyController.generateKey(aot, ao, role, namedKeyComponents);
        if (policyKeyToDataValueMap.containsKey(key)) {
            return policyKeyToDataValueMap.get(key);
        }
        String uri = EntityPolicyController.getLoader().getEntityValueSetUri(ao, aot, role, namedKeyComponents);
        policyKeyToDataValueMap.put(key, uri);
        return uri;
    }

    private static String generateKey(AccessObjectType aot, AccessOperation ao, String role, String[] namedKeyComponents) {
        String key = aot.toString() + "." + ao.toString() + "." + role;
        if (namedKeyComponents.length > 0) {
            ArrayList<String> namedKeys = new ArrayList<String>(Arrays.asList(namedKeyComponents));
            Collections.sort(namedKeys);
            key = key + String.join((CharSequence)".", namedKeys);
        }
        return key;
    }
}

