/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyDecisionLogger;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Policy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyDecisionPoint {
    private static final Log log = LogFactory.getLog((String)PolicyDecisionPoint.class.getName());

    public static PolicyDecision decide(AuthorizationRequest ar) {
        PolicyDecision pd = null;
        PolicyDecisionLogger logger = new PolicyDecisionLogger(ar);
        PolicyStore store = PolicyStore.getInstance();
        for (Policy policy : store.getList()) {
            try {
                pd = policy.decide(ar);
                logger.log(policy, pd);
                if (pd != null) {
                    if (pd.getDecisionResult() == DecisionResult.AUTHORIZED) {
                        return pd;
                    }
                    if (pd.getDecisionResult() == DecisionResult.UNAUTHORIZED) {
                        return pd;
                    }
                    if (pd.getDecisionResult() != DecisionResult.INCONCLUSIVE) continue;
                    continue;
                }
                log.debug((Object)("policy " + policy.toString() + " returned a null PolicyDecision"));
            }
            catch (Throwable th) {
                log.error((Object)("ignoring exception in policy " + policy.getUri()), th);
            }
        }
        pd = new BasicPolicyDecision(DecisionResult.INCONCLUSIVE, String.format("No policy returned a conclusive decision on %s of %s", new Object[]{ar.getAccessOperation(), ar.getAccessObject()}));
        logger.logNoDecision(pd);
        return pd;
    }
}

