/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyDecisionPoint;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.SimpleAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class PolicyHelper {
    private static final Log log = LogFactory.getLog(PolicyHelper.class);
    private static UserAccount nullUserAccount = new UserAccount();

    public static UserAccount getUserAccount(HttpServletRequest req) {
        UserAccount userAccount = LoginStatusBean.getCurrentUser(req);
        if (userAccount == null) {
            return nullUserAccount;
        }
        return userAccount;
    }

    public static boolean isAuthorizedForActions(UserAccount user, AccessObject ar, AccessOperation op) {
        return PolicyHelper.actionRequestIsAuthorized(user, ar, op);
    }

    public static boolean isAuthorizedForActions(HttpServletRequest req, AuthorizationRequest ar) {
        UserAccount userAccount = PolicyHelper.getUserAccount(req);
        return PolicyHelper.isAuthorizedForActions(userAccount, ar);
    }

    public static boolean isAuthorizedForActions(HttpServletRequest req, AccessObject ar, AccessOperation operation) {
        UserAccount userAccount = PolicyHelper.getUserAccount(req);
        return PolicyHelper.actionRequestIsAuthorized(userAccount, ar, operation);
    }

    public static boolean isAuthorizedForActions(UserAccount userAccount, AuthorizationRequest ar) {
        if (ar == null) {
            log.error((Object)"AuthorizationRequest is null");
            return false;
        }
        if (ar.getPredefinedDecision() != DecisionResult.INCONCLUSIVE) {
            return ar.getPredefinedDecision() == DecisionResult.AUTHORIZED;
        }
        if (ar.getWrapType() != null) {
            return PolicyHelper.processUnwrappedAuthorizationRequest(ar, userAccount);
        }
        return PolicyHelper.actionRequestIsAuthorized(userAccount, ar.getAccessObject(), ar.getAccessOperation());
    }

    private static boolean processUnwrappedAuthorizationRequest(AuthorizationRequest ar, UserAccount userAccount) {
        List<AuthorizationRequest> items = ar.getItems();
        boolean result = false;
        if (AuthorizationRequest.WRAP_TYPE.OR == ar.getWrapType()) {
            for (AuthorizationRequest item : items) {
                result = result || PolicyHelper.isAuthorizedForActions(userAccount, item);
            }
        } else {
            result = true;
            for (AuthorizationRequest item : items) {
                result = result && PolicyHelper.isAuthorizedForActions(userAccount, item);
            }
        }
        return result;
    }

    private static boolean actionRequestIsAuthorized(UserAccount userAccount, AccessObject ao, AccessOperation operation) {
        if (operation == null) {
            log.error((Object)("Opeartion is null, accessObject " + ao));
            return false;
        }
        if (ao == null) {
            log.error((Object)("Access object is null, operation " + (Object)((Object)operation)));
            return false;
        }
        SimpleAuthorizationRequest ar = new SimpleAuthorizationRequest(ao, operation);
        ar.setUserAccount(userAccount);
        PolicyDecision decision = PolicyDecisionPoint.decide(ar);
        PolicyHelper.debug(ar, decision);
        return decision.getDecisionResult() == DecisionResult.AUTHORIZED;
    }

    private static void debug(AuthorizationRequest ar, PolicyDecision decision) {
        if (log.isDebugEnabled()) {
            AccessObject ao = ar.getAccessObject();
            log.debug((Object)String.format("Request for %s on object %s resulted in decision %s", new Object[]{ar.getAccessOperation(), ao, decision.getDecisionResult()}));
        }
    }

    public static boolean isAuthorizedForActions(HttpServletRequest req, String email, String password, AuthorizationRequest ar) {
        if (password == null || email == null || password.isEmpty() || email.isEmpty()) {
            return false;
        }
        try {
            Authenticator auth = Authenticator.getInstance(req);
            UserAccount user = auth.getAccountForInternalAuth(email);
            if (user == null) {
                log.debug((Object)("No account for '" + email + "'"));
                return false;
            }
            String uri = user.getUri();
            log.debug((Object)("userAccount is '" + uri + "'"));
            if (!auth.isCurrentPasswordArgon2(user, password)) {
                log.debug((Object)String.format("UNAUTHORIZED, password not accepted for %s, account URI: %s", email, uri));
                return false;
            }
            log.debug((Object)String.format("password accepted for %s, account URI: %s", email, uri));
            return PolicyHelper.isAuthorizedForActions(user, ar);
        }
        catch (Exception ex) {
            log.error((Object)("Error while attempting to authorize actions " + ar), (Throwable)ex);
            return false;
        }
    }

    public static boolean isAuthorizedToAdd(HttpServletRequest req, Statement stmt, OntModel modelToBeModified) {
        AccessObject action;
        if (req == null || stmt == null || modelToBeModified == null) {
            return false;
        }
        Resource subject = stmt.getSubject();
        Property predicate = stmt.getPredicate();
        RDFNode objectNode = stmt.getObject();
        if (subject == null || predicate == null || objectNode == null) {
            return false;
        }
        if (objectNode.isResource()) {
            edu.cornell.mannlib.vitro.webapp.beans.Property property = new edu.cornell.mannlib.vitro.webapp.beans.Property(predicate.getURI());
            property.setDomainVClassURI(AccessObject.SOME_URI);
            property.setRangeVClassURI(AccessObject.SOME_URI);
            action = new ObjectPropertyStatementAccessObject((Model)modelToBeModified, subject.getURI(), property, objectNode.asResource().getURI());
        } else {
            action = new DataPropertyStatementAccessObject(modelToBeModified, subject.getURI(), predicate.getURI(), objectNode.asLiteral().getString());
        }
        return PolicyHelper.isAuthorizedForActions(req, action, AccessOperation.ADD);
    }

    public static boolean isAuthorizedToDrop(HttpServletRequest req, Statement stmt, OntModel modelToBeModified) {
        AccessObject action;
        if (req == null || stmt == null || modelToBeModified == null) {
            return false;
        }
        Resource subject = stmt.getSubject();
        Property predicate = stmt.getPredicate();
        RDFNode objectNode = stmt.getObject();
        if (subject == null || predicate == null || objectNode == null) {
            return false;
        }
        if (objectNode.isResource()) {
            edu.cornell.mannlib.vitro.webapp.beans.Property property = new edu.cornell.mannlib.vitro.webapp.beans.Property(predicate.getURI());
            property.setDomainVClassURI(AccessObject.SOME_URI);
            property.setRangeVClassURI(AccessObject.SOME_URI);
            action = new ObjectPropertyStatementAccessObject((Model)modelToBeModified, subject.getURI(), property, objectNode.asResource().getURI());
        } else {
            action = new DataPropertyStatementAccessObject(modelToBeModified, subject.getURI(), predicate.getURI(), objectNode.asLiteral().getString());
        }
        return PolicyHelper.isAuthorizedForActions(req, action, AccessOperation.DROP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAuthorizedAsExpected(HttpServletRequest req, Model additions, Model retractions, OntModel modelBeingModified) {
        if (req == null) {
            log.warn((Object)"Can't evaluate authorization if req is null");
            return false;
        }
        if (additions == null) {
            log.warn((Object)"Can't evaluate authorization if additions model is null");
            return false;
        }
        if (retractions == null) {
            log.warn((Object)"Can't evaluate authorization if retractions model is null");
            return false;
        }
        if (modelBeingModified == null) {
            log.warn((Object)"Can't evaluate authorization if model being modified is null");
            return false;
        }
        boolean result = true;
        OntModel modelToTestAgainst = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        modelToTestAgainst.addSubModel(additions);
        modelToTestAgainst.addSubModel((Model)modelBeingModified);
        try (StmtIterator addStmts = additions.listStatements();){
            while (addStmts.hasNext()) {
                Statement stmt = (Statement)addStmts.next();
                if (PolicyHelper.isAuthorizedToAdd(req, stmt, modelToTestAgainst)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Last-chance authorization check: authorized to add statement: " + PolicyHelper.formatStatement(stmt)));
                    continue;
                }
                log.warn((Object)("Last-chance authorization check reveals not authorized to add statement: " + PolicyHelper.formatStatement(stmt)));
                result = false;
            }
        }
        try (StmtIterator dropStmts = retractions.listStatements();){
            while (dropStmts.hasNext()) {
                Statement stmt = (Statement)dropStmts.next();
                if (PolicyHelper.isAuthorizedToDrop(req, stmt, modelToTestAgainst)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Last-chance authorization check: authorized to drop statement: " + PolicyHelper.formatStatement(stmt)));
                    continue;
                }
                log.warn((Object)("Last-chance authorization check reveals not authorized to drop statement: " + PolicyHelper.formatStatement(stmt)));
                result = false;
            }
        }
        return result;
    }

    private static String formatStatement(Statement stmt) {
        if (stmt == null) {
            return "null statement";
        }
        return "<" + stmt.getSubject() + "> <" + stmt.getPredicate() + "> <" + stmt.getObject() + ">";
    }

    private PolicyHelper() {
    }
}

