/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.Policies;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Policy;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyStore
implements Policies {
    private static final Comparator<Policy> comparator = PolicyStore.getPolicyComparator();
    private static PolicyStore INSTANCE = new PolicyStore();
    private static final Log log = LogFactory.getLog(PolicyStore.class);
    protected List<Policy> policyList = new CopyOnWriteArrayList<Policy>();
    protected Map<String, Policy> policyMap = new ConcurrentHashMap<String, Policy>();

    private PolicyStore() {
        INSTANCE = this;
    }

    public static PolicyStore getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean contains(Policy policy) {
        return this.policyList.contains(policy);
    }

    @Override
    public synchronized void remove(String policyUri) {
        Policy oldPolicy = this.policyMap.get(policyUri);
        if (oldPolicy != null) {
            this.policyList.remove(oldPolicy);
        }
        this.policyMap.remove(policyUri);
    }

    @Override
    public synchronized void add(Policy policy) {
        if (policy == null) {
            log.error((Object)"Policy to add is null");
            return;
        }
        Policy oldPolicy = this.policyMap.put(policy.getUri(), policy);
        if (oldPolicy != null) {
            this.policyList.remove(oldPolicy);
        }
        this.policyList.add(policy);
        Collections.sort(this.policyList, comparator);
    }

    @Override
    public synchronized void clear() {
        this.policyList.clear();
        this.policyMap.clear();
    }

    public List<String> getShortUris() {
        LinkedList<String> uris = new LinkedList<String>();
        for (Policy policy : this.policyList) {
            uris.add(policy.getShortUri());
        }
        return uris;
    }

    private static Comparator<Policy> getPolicyComparator() {
        return new Comparator<Policy>(){

            @Override
            public int compare(Policy lps, Policy rps) {
                if (lps.getPriority() > rps.getPriority()) {
                    return -1;
                }
                if (lps.getPriority() < rps.getPriority()) {
                    return 1;
                }
                return lps.getUri().compareTo(lps.getUri());
            }
        };
    }

    @Override
    public List<Policy> getList() {
        return this.policyList;
    }

    @Override
    public long size() {
        return this.policyList.size();
    }
}

