/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.StatementImpl;

public class PolicyTemplateController {
    private static final Log log = LogFactory.getLog(PolicyTemplateController.class);

    public static void createRoleDataSets(String roleUri) {
        Map<String, String> templates = PolicyLoader.getInstance().getRoleDataSetTemplates();
        for (String templateUri : templates.keySet()) {
            PolicyTemplateController.createRoleDataSet(templateUri, roleUri, templates.get(templateUri));
        }
    }

    private static void createRoleDataSet(String dataSetTemplateUri, String roleUri, String dataSetsUri) {
        String role = PolicyTemplateController.getRoleShortName(roleUri);
        String dataSetUri = PolicyTemplateController.getUriFromTemplate(dataSetTemplateUri, role);
        String dataSetKeyUri = dataSetUri + "Key";
        PolicyLoader policyLoader = PolicyLoader.getInstance();
        List<String> keys = policyLoader.getDataSetKeysFromTemplate(dataSetTemplateUri);
        List<String> keyTemplates = policyLoader.getDataSetKeyTemplatesFromTemplate(dataSetTemplateUri);
        Model dataSetModel = VitroModelFactory.createModel();
        for (String string : keyTemplates) {
            if (string.equals("https://vivoweb.org/ontology/vitro-application/auth/individual/SubjectRole")) {
                String roleKeyUri = null;
                List<String> roleValuePatterns = PolicyLoader.getInstance().getSubjectRoleValuePattern(roleUri);
                roleKeyUri = roleValuePatterns.isEmpty() ? PolicyTemplateController.createSubjectRoleUri(roleUri, dataSetModel) : roleValuePatterns.get(0);
                keys.add(roleKeyUri);
                continue;
            }
            log.error((Object)String.format("Not recognized key template found '%s'", string));
            return;
        }
        dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(dataSetsUri), dataSetModel.createProperty("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/hasDataSet"), (RDFNode)dataSetModel.createResource(dataSetUri)));
        dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(dataSetUri), dataSetModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)dataSetModel.createResource("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/PolicyDataSet")));
        dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(dataSetUri), dataSetModel.createProperty("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/hasDataSetKey"), (RDFNode)dataSetModel.createResource(dataSetKeyUri)));
        for (String string : keys) {
            dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(dataSetKeyUri), dataSetModel.createProperty("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/hasKeyComponent"), (RDFNode)dataSetModel.createResource(string)));
        }
        List<String> valueSetUris = policyLoader.getDataSetValuesFromTemplate(dataSetTemplateUri);
        for (String valueSetUri : valueSetUris) {
            dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(dataSetUri), dataSetModel.createProperty("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/hasRelatedValueSet"), (RDFNode)dataSetModel.createResource(valueSetUri)));
        }
        List<String> list = policyLoader.getDataSetValueTemplatesFromTemplate(dataSetTemplateUri);
        for (String valueSetTemplateUri : list) {
            String valueSetUri = PolicyTemplateController.getUriFromTemplate(valueSetTemplateUri, role);
            dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(dataSetUri), dataSetModel.createProperty("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/hasRelatedValueSet"), (RDFNode)dataSetModel.createResource(valueSetUri)));
            policyLoader.constructValueSet(valueSetTemplateUri, valueSetUri, roleUri, dataSetModel);
        }
        policyLoader.updateAccessControlModel(dataSetModel, true);
    }

    public static String createSubjectRoleUri(String roleUri, Model dataSetModel) {
        String roleShortName = PolicyTemplateController.getRoleShortName(roleUri);
        String roleValueSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/" + roleShortName + "RoleUri";
        dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(roleValueSetUri), dataSetModel.createProperty("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/id"), (RDFNode)dataSetModel.createLiteral(roleUri)));
        dataSetModel.add((Statement)new StatementImpl(dataSetModel.createResource(roleValueSetUri), dataSetModel.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)dataSetModel.createResource("https://vivoweb.org/ontology/vitro-application/auth/vocabulary/SubjectRoleUri")));
        return roleValueSetUri;
    }

    private static String getRoleShortName(String roleUri) {
        String slashSplit = roleUri.substring(roleUri.lastIndexOf(47) + 1);
        String hashSplit = slashSplit.substring(slashSplit.lastIndexOf(35) + 1);
        return Character.toUpperCase(hashSplit.charAt(0)) + hashSplit.substring(1).toLowerCase();
    }

    private static String getUriFromTemplate(String templateUri, String name) {
        String templatePrefix = templateUri.substring(0, templateUri.lastIndexOf(47) + 1);
        String templateName = templateUri.substring(templateUri.lastIndexOf(47) + 1);
        int index = templateName.lastIndexOf("Template");
        if (templateName.endsWith("Template") && index > 0) {
            templateName = templateName.substring(0, index);
        }
        return templatePrefix + name + templateName;
    }
}

