/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.setup;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ActiveIdentifierBundleFactories;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasPermissionSetFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasProfileFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.HasProxyEditingRightsFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.IsRootUserFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.factory.IsUserFactory;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class CommonPolicyFamilySetup
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            PolicyLoader.initialize(ModelAccess.getInstance().getRDFService(ModelAccess.WhichService.CONFIGURATION));
            PolicyLoader.getInstance().loadPolicies();
            this.factory(new IsUserFactory());
            this.factory(new IsRootUserFactory());
            this.factory(new HasProfileFactory());
            this.factory(new HasPermissionSetFactory());
            this.factory(new HasProxyEditingRightsFactory());
        }
        catch (Exception e) {
            ss.fatal(this, "could not run CommonPolicyFamilySetup", e);
        }
    }

    private void factory(IdentifierBundleFactory factory) {
        ActiveIdentifierBundleFactories.addFactory(factory);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

