/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.requestedAction;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AllowedAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AndAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.ForbiddenAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.OrAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AuthorizationRequest {
    public static final AuthorizationRequest UNAUTHORIZED = new ForbiddenAuthorizationRequest();
    public static final AuthorizationRequest AUTHORIZED = new AllowedAuthorizationRequest();
    private UserAccount userAccount;

    public WRAP_TYPE getWrapType() {
        return null;
    }

    public DecisionResult getPredefinedDecision() {
        return DecisionResult.INCONCLUSIVE;
    }

    public List<AuthorizationRequest> getItems() {
        return Collections.emptyList();
    }

    public abstract AccessObject getAccessObject();

    public abstract AccessOperation getAccessOperation();

    public Set<String> getRoleUris() {
        return this.userAccount.getPermissionSetUris();
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public Set<String> getEditorUris() {
        return this.userAccount.getProxiedIndividualUris();
    }

    public String getExternalAuthId() {
        return this.userAccount.getExternalAuthId();
    }

    public static AuthorizationRequest or(AuthorizationRequest fist, AuthorizationRequest second) {
        if (fist == null) {
            return second;
        }
        if (second == null) {
            return fist;
        }
        return new OrAuthorizationRequest(fist, second);
    }

    public AuthorizationRequest and(AuthorizationRequest second) {
        return new AndAuthorizationRequest(this, second);
    }

    public String toString() {
        String result = "";
        result = result + String.format(" requested '%s' ", new Object[]{this.getAccessOperation()});
        result = result + String.format(" on '%s' ", this.getAccessObject());
        return result;
    }

    public boolean isRootUser() {
        return this.userAccount.isRootUser();
    }

    public static enum WRAP_TYPE {
        AND,
        OR;

    }
}

