/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.rules;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.Attribute;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastFailAccessRule
implements AccessRule {
    private static final Log log = LogFactory.getLog(FastFailAccessRule.class);
    protected Map<String, Check> checksMap = new HashMap<String, Check>();
    protected List<Check> checks = new ArrayList<Check>();
    private static final Comparator<Check> comparator = FastFailAccessRule.getAttributeComparator();
    private boolean allowMatched = true;
    private String ruleUri;

    @Override
    public boolean isAllowMatched() {
        return this.allowMatched;
    }

    @Override
    public void setAllowMatched(boolean allowMatched) {
        this.allowMatched = allowMatched;
    }

    @Override
    public String getRuleUri() {
        return this.ruleUri;
    }

    @Override
    public void setRuleUri(String ruleUri) {
        this.ruleUri = ruleUri;
    }

    @Override
    public List<Check> getChecks() {
        return this.checks;
    }

    @Override
    public boolean match(AuthorizationRequest ar) {
        for (Check check : this.checks) {
            if (check.check(ar)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Check %s didn't match request %s", check.getUri(), ar));
            }
            return false;
        }
        return true;
    }

    @Override
    public void addCheck(Check attr) {
        if (this.checksMap.containsKey(attr.getUri())) {
            log.error((Object)String.format("Check %s already exists in the rule", attr.getUri()));
        }
        this.checks.add(attr);
        Collections.sort(this.checks, comparator);
        this.checksMap.put(attr.getUri(), attr);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccessRule)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        AccessRule compared = (AccessRule)object;
        return new EqualsBuilder().append((Object)this.getRuleUri(), (Object)compared.getRuleUri()).append(this.getChecks(), compared.getChecks()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 101).append(this.getChecks()).append((Object)this.getRuleUri()).toHashCode();
    }

    @Override
    public Set<String> getCheckUris() {
        return this.checksMap.keySet();
    }

    @Override
    public boolean containsCheckUri(String uri) {
        return this.checksMap.containsKey(uri);
    }

    @Override
    public Set<Check> getChecksByType(Attribute type) {
        return this.getChecks().stream().filter(a -> a.getAttributeType().equals((Object)type)).collect(Collectors.toSet());
    }

    @Override
    public long getChecksCount() {
        return this.checks.size();
    }

    @Override
    public Check getCheck(String uri) {
        return this.checksMap.get(uri);
    }

    private static Comparator<Check> getAttributeComparator() {
        return new Comparator<Check>(){

            @Override
            public int compare(Check latt, Check ratt) {
                if (latt.getComputationalCost() > ratt.getComputationalCost()) {
                    return 1;
                }
                if (latt.getComputationalCost() < ratt.getComputationalCost()) {
                    return -1;
                }
                return latt.getUri().compareTo(latt.getUri());
            }
        };
    }
}

