/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class BaseResourceBean
implements ResourceBean {
    private static final Log log = LogFactory.getLog((String)BaseResourceBean.class.getName());
    protected String URI = null;
    protected String namespace = null;
    protected String localName = null;
    protected String localNameWithPrefix = null;
    protected String pickListName = null;

    public BaseResourceBean() {
    }

    public BaseResourceBean(String uri) {
        this.buildLocalAndNS(uri);
    }

    @Override
    public boolean isAnonymous() {
        return this.URI == null || "http://vitro.mannlib.cornell.edu/ns/bnode#".equals(this.getNamespace());
    }

    @Override
    public String getURI() {
        return this.URI;
    }

    @Override
    public void setURI(String URI2) {
        if (this.localName != null || this.namespace != null) {
            this.buildLocalAndNS(URI2);
        } else {
            this.URI = URI2;
        }
    }

    private void buildLocalAndNS(String URI2) {
        if (URI2 == null) {
            this.URI = null;
            this.namespace = null;
            this.localName = null;
        } else {
            this.URI = URI2;
            Resource uri = ResourceFactory.createResource((String)URI2);
            this.namespace = uri.getNameSpace();
            this.localName = uri.getLocalName();
        }
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null && this.URI != null) {
            this.buildLocalAndNS(this.URI);
        }
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null && this.localName != null) {
            this.URI = namespace + this.localName;
        }
    }

    @Override
    public String getLabel() {
        return this.getLocalName();
    }

    @Override
    public String getLocalName() {
        if (this.localName == null && this.URI != null) {
            this.buildLocalAndNS(this.URI);
        }
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
        if (this.namespace != null && localName != null) {
            this.URI = this.namespace + localName;
        }
    }

    public String getLocalNameWithPrefix() {
        return this.localNameWithPrefix != null ? this.localNameWithPrefix : (this.getLocalName() != null ? this.getLocalName() : (this.URI != null ? this.URI : "(no name)"));
    }

    public void setLocalNameWithPrefix(String prefixedLocalName) {
        this.localNameWithPrefix = prefixedLocalName;
    }

    @Override
    public String getPickListName() {
        return this.pickListName == null ? (this.getLocalName() == null ? (this.URI == null ? "(no name)" : this.URI) : this.getLocalName()) : this.pickListName;
    }

    public void setPickListName(String pickListName) {
        this.pickListName = pickListName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BaseResourceBean) {
            String thisURI = this.getURI();
            String thatURI = ((BaseResourceBean)obj).getURI();
            if (thisURI != null && thatURI != null) {
                return thisURI.equals(thatURI);
            }
        }
        return obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.getURI() != null) {
            return this.getURI().hashCode();
        }
        return super.hashCode();
    }
}

