/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.cornell.mannlib.vitro.webapp.beans.AbstractCaptchaProvider;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaBundle;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaImplementation;
import edu.cornell.mannlib.vitro.webapp.beans.DummyCaptchaProvider;
import edu.cornell.mannlib.vitro.webapp.beans.NanocaptchaProvider;
import edu.cornell.mannlib.vitro.webapp.beans.Recaptchav2Provider;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CaptchaServiceBean {
    private static final Cache<String, CaptchaBundle> captchaChallenges = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static AbstractCaptchaProvider captchaProvider;

    public static CaptchaBundle generateRefreshedChallenge() throws IOException {
        return captchaProvider.generateRefreshChallenge();
    }

    public static Optional<CaptchaBundle> getChallenge(String captchaId) {
        CaptchaBundle challengeForHost = (CaptchaBundle)captchaChallenges.getIfPresent((Object)captchaId);
        if (challengeForHost == null) {
            return Optional.empty();
        }
        captchaChallenges.invalidate((Object)captchaId);
        return Optional.of(challengeForHost);
    }

    public static Cache<String, CaptchaBundle> getCaptchaChallenges() {
        return captchaChallenges;
    }

    public static CaptchaImplementation getCaptchaImpl() {
        String captchaEnabledSetting = ConfigurationProperties.getInstance().getProperty("captcha.enabled");
        if (Objects.nonNull(captchaEnabledSetting) && !Boolean.parseBoolean(captchaEnabledSetting)) {
            return CaptchaImplementation.NONE;
        }
        String captchaImplSetting = ConfigurationProperties.getInstance().getProperty("captcha.implementation");
        if (Strings.isNullOrEmpty((String)captchaImplSetting) || !captchaImplSetting.equalsIgnoreCase(CaptchaImplementation.RECAPTCHAV2.name()) && !captchaImplSetting.equalsIgnoreCase(CaptchaImplementation.NANOCAPTCHA.name())) {
            captchaImplSetting = CaptchaImplementation.NANOCAPTCHA.name();
        }
        return CaptchaImplementation.valueOf(captchaImplSetting.toUpperCase());
    }

    public static void addCaptchaRelatedFieldsToPageContext(Map<String, Object> context) throws IOException {
        CaptchaImplementation captchaImpl = CaptchaServiceBean.getCaptchaImpl();
        context.put("captchaToUse", captchaImpl.name());
        captchaProvider.addCaptchaRelatedFieldsToPageContext(context);
    }

    public static boolean validateCaptcha(String captchaInput, String challengeId) {
        return captchaProvider.validateCaptcha(captchaInput, challengeId);
    }

    static {
        CaptchaImplementation captchaImplementation = CaptchaServiceBean.getCaptchaImpl();
        switch (captchaImplementation) {
            case RECAPTCHAV2: {
                captchaProvider = new Recaptchav2Provider();
                break;
            }
            case NANOCAPTCHA: {
                captchaProvider = new NanocaptchaProvider();
                break;
            }
            case NONE: {
                captchaProvider = new DummyCaptchaProvider();
            }
        }
    }
}

