/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.AbstractCaptchaProvider;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaBundle;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaDifficulty;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaServiceBean;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.logicsquad.nanocaptcha.image.ImageCaptcha;
import net.logicsquad.nanocaptcha.image.backgrounds.BackgroundProducer;
import net.logicsquad.nanocaptcha.image.backgrounds.GradiatedBackgroundProducer;
import net.logicsquad.nanocaptcha.image.filter.FishEyeImageFilter;
import net.logicsquad.nanocaptcha.image.filter.ImageFilter;
import net.logicsquad.nanocaptcha.image.filter.StretchImageFilter;
import net.logicsquad.nanocaptcha.image.noise.CurvedLineNoiseProducer;
import net.logicsquad.nanocaptcha.image.noise.NoiseProducer;
import net.logicsquad.nanocaptcha.image.noise.StraightLineNoiseProducer;

public class NanocaptchaProvider
extends AbstractCaptchaProvider {
    private final SecureRandom random = new SecureRandom();

    @Override
    public CaptchaBundle generateRefreshChallenge() throws IOException {
        return this.generateChallenge();
    }

    @Override
    public void addCaptchaRelatedFieldsToPageContext(Map<String, Object> context) throws IOException {
        CaptchaBundle captchaChallenge = this.generateChallenge();
        CaptchaServiceBean.getCaptchaChallenges().put((Object)captchaChallenge.getCaptchaId(), (Object)captchaChallenge);
        context.put("challenge", captchaChallenge.getB64Image());
        context.put("challengeId", captchaChallenge.getCaptchaId());
    }

    @Override
    public boolean validateCaptcha(String captchaInput, String challengeId) {
        Optional<CaptchaBundle> optionalChallenge = CaptchaServiceBean.getChallenge(challengeId);
        return optionalChallenge.isPresent() && optionalChallenge.get().getCode().equals(captchaInput);
    }

    private CaptchaBundle generateChallenge() throws IOException {
        CaptchaDifficulty difficulty = this.getCaptchaDifficulty();
        ImageCaptcha.Builder imageCaptchaBuilder = new ImageCaptcha.Builder(220, 85).addContent(this.random.nextInt(2) + 5).addBackground((BackgroundProducer)new GradiatedBackgroundProducer()).addNoise((NoiseProducer)new StraightLineNoiseProducer(this.getRandomColor(), 2)).addFilter((ImageFilter)new StretchImageFilter()).addBorder();
        if (difficulty.equals((Object)CaptchaDifficulty.HARD)) {
            imageCaptchaBuilder.addNoise((NoiseProducer)new CurvedLineNoiseProducer(this.getRandomColor(), 2.0f)).addFilter((ImageFilter)new StretchImageFilter()).addFilter((ImageFilter)new FishEyeImageFilter()).build();
        }
        ImageCaptcha imageCaptcha = imageCaptchaBuilder.build();
        return new CaptchaBundle(this.convertToBase64(imageCaptcha.getImage()), imageCaptcha.getContent(), UUID.randomUUID().toString());
    }

    private String convertToBase64(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        byte[] imageBytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    private CaptchaDifficulty getCaptchaDifficulty() {
        String difficulty = ConfigurationProperties.getInstance().getProperty("nanocaptcha.difficulty");
        try {
            return CaptchaDifficulty.valueOf(difficulty.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return CaptchaDifficulty.EASY;
        }
    }

    private Color getRandomColor() {
        int r = this.random.nextInt(256);
        int g = this.random.nextInt(256);
        int b = this.random.nextInt(256);
        return new Color(r, g, b);
    }
}

