/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.cornell.mannlib.vitro.webapp.beans.AbstractCaptchaProvider;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaBundle;
import edu.cornell.mannlib.vitro.webapp.beans.ReCaptchaResponse;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Recaptchav2Provider
extends AbstractCaptchaProvider {
    @Override
    public CaptchaBundle generateRefreshChallenge() {
        return new CaptchaBundle("", "", "");
    }

    @Override
    public void addCaptchaRelatedFieldsToPageContext(Map<String, Object> context) {
        context.put("siteKey", Objects.requireNonNull(ConfigurationProperties.getInstance().getProperty("recaptcha.siteKey"), "You have to provide a site key through configuration file."));
    }

    @Override
    public boolean validateCaptcha(String captchaInput, String challengeId) {
        return this.validateReCaptcha(captchaInput);
    }

    public boolean validateReCaptcha(String recaptchaResponse) {
        boolean bl;
        block8: {
            String secretKey = Objects.requireNonNull(ConfigurationProperties.getInstance().getProperty("recaptcha.secretKey"), "You have to provide a secret key through configuration file.");
            String verificationUrl = "https://www.google.com/recaptcha/api/siteverify?secret=" + secretKey + "&response=" + recaptchaResponse;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpGet verificationRequest = new HttpGet(verificationUrl);
                CloseableHttpResponse verificationResponse = httpClient.execute((HttpUriRequest)verificationRequest);
                String responseBody = EntityUtils.toString((HttpEntity)verificationResponse.getEntity());
                ObjectMapper objectMapper = new ObjectMapper();
                ReCaptchaResponse response = (ReCaptchaResponse)objectMapper.readValue(responseBody, ReCaptchaResponse.class);
                bl = response.isSuccess();
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn((Object)"ReCaptcha validation failed.");
                    return false;
                }
            }
            httpClient.close();
        }
        return bl;
    }
}

