/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfEditingConfiguration {
    private static final Log log = LogFactory.getLog(SelfEditingConfiguration.class);
    private static SelfEditingConfiguration INSTANCE;
    private static final String PROPERTY_SELF_EDITING_ID_MATCHING_PROPERTY = "selfEditing.idMatchingProperty";
    private final String selfEditingIdMatchingProperty;

    public static SelfEditingConfiguration getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        SelfEditingConfiguration bean = SelfEditingConfiguration.buildBean();
        log.debug((Object)("Created a bean: " + bean));
        INSTANCE = bean;
        return bean;
    }

    public static SelfEditingConfiguration getBean(ServletRequest request) {
        if (request == null) {
            log.error((Object)"Request is null");
            return new SelfEditingConfiguration(null);
        }
        if (!(request instanceof HttpServletRequest)) {
            log.error((Object)("Not an HttpServletRequest: " + request.getClass()));
            return new SelfEditingConfiguration(null);
        }
        HttpServletRequest hreq = (HttpServletRequest)request;
        return SelfEditingConfiguration.getBean(hreq.getSession().getServletContext());
    }

    public static SelfEditingConfiguration getBean(ServletContext ctx) {
        return SelfEditingConfiguration.getInstance();
    }

    private static SelfEditingConfiguration buildBean() {
        ConfigurationProperties config = ConfigurationProperties.getInstance();
        String selfEditingIdMatchingProperty = config.getProperty(PROPERTY_SELF_EDITING_ID_MATCHING_PROPERTY);
        return new SelfEditingConfiguration(selfEditingIdMatchingProperty);
    }

    public SelfEditingConfiguration(String selfEditingIdMatchingProperty) {
        this.selfEditingIdMatchingProperty = this.trimThis(selfEditingIdMatchingProperty);
    }

    private String trimThis(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public boolean isConfigured() {
        return this.selfEditingIdMatchingProperty != null;
    }

    public String getMatchingPropertyUri() {
        return this.selfEditingIdMatchingProperty;
    }

    public List<Individual> getAssociatedIndividuals(IndividualDao indDao, UserAccount user) {
        if (user == null) {
            log.debug((Object)"user is null");
            return Collections.emptyList();
        }
        return this.getAssociatedIndividuals(indDao, user.getExternalAuthId());
    }

    public List<Individual> getAssociatedIndividuals(IndividualDao indDao, String externalAuthId) {
        if (indDao == null) {
            log.warn((Object)"No IndividualDao");
            return Collections.emptyList();
        }
        if (externalAuthId == null) {
            log.debug((Object)"externalAuthId is null");
            return Collections.emptyList();
        }
        if (externalAuthId.isEmpty()) {
            log.debug((Object)"externalAuthId is empty");
            return Collections.emptyList();
        }
        if (this.selfEditingIdMatchingProperty == null) {
            log.debug((Object)"selfEditingMatchingProperty is null");
            return Collections.emptyList();
        }
        return indDao.getIndividualsByDataProperty(this.selfEditingIdMatchingProperty, externalAuthId);
    }

    public void associateIndividualWithUserAccount(IndividualDao indDao, DataPropertyStatementDao dpsDao, UserAccount user, String associatedIndividualUri) {
        if (indDao == null) {
            log.warn((Object)"No IndividualDao");
            return;
        }
        if (dpsDao == null) {
            log.warn((Object)"No DataPropertyStatementDao");
            return;
        }
        if (user == null) {
            log.debug((Object)"user is null");
            return;
        }
        if (this.selfEditingIdMatchingProperty == null) {
            log.error((Object)"Can't associate Individual with UserAccount: selfEditingMatchingProperty is null");
            return;
        }
        String externalAuthId = user.getExternalAuthId();
        if (externalAuthId.isEmpty()) {
            log.debug((Object)"user has no externalAuthId");
            return;
        }
        Individual associatedInd = indDao.getIndividualByURI(associatedIndividualUri);
        if (associatedInd != null) {
            log.debug((Object)("setting the matching property on '" + associatedIndividualUri + "' to '" + externalAuthId + "'"));
            dpsDao.deleteDataPropertyStatementsForIndividualByDataProperty(associatedIndividualUri, this.selfEditingIdMatchingProperty);
            dpsDao.insertNewDataPropertyStatement(new DataPropertyStatementImpl(associatedIndividualUri, this.selfEditingIdMatchingProperty, externalAuthId));
        }
        for (Individual ind : indDao.getIndividualsByDataProperty(this.selfEditingIdMatchingProperty, externalAuthId)) {
            String indUri = ind.getURI();
            if (indUri.equals(associatedIndividualUri)) continue;
            log.debug((Object)("clearing the matching property on '" + indUri + "'"));
            dpsDao.deleteDataPropertyStatementsForIndividualByDataProperty(indUri, this.selfEditingIdMatchingProperty);
        }
    }

    public String toString() {
        return "SelfEditingConfiguration[selfEditingIdMatchingProperty=" + this.selfEditingIdMatchingProperty + "]";
    }
}

