/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import edu.cornell.mannlib.vitro.webapp.controller.MultipartRequestWrapper;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LogoutRedirector;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroHttpServlet
extends HttpServlet
implements MultipartRequestWrapper.ParsingStrategy {
    private static final long serialVersionUID = 1L;
    protected static DateFormat publicDateFormat = new SimpleDateFormat("M/dd/yyyy");
    private static final Log log = LogFactory.getLog((String)VitroHttpServlet.class.getName());
    public static final String XHTML_MIMETYPE = "application/xhtml+xml";
    public static final String HTML_MIMETYPE = "text/html";
    public static final String RDFXML_MIMETYPE = "application/rdf+xml";
    public static final String JSON_MIMETYPE = "application/json";
    public static final String JSON_LD_MIMETYPE = "application/ld+json";
    public static final String N3_MIMETYPE = "text/n3";
    public static final String TTL_MIMETYPE = "text/turtle";
    private static final List<String> BORING_HEADERS = new ArrayList<String>(Arrays.asList("host", "user-agent", "accept", "accept-language", "accept-encoding", "accept-charset", "keep-alive", "connection"));

    public final void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            HttpServletRequest hreq = (HttpServletRequest)req;
            hreq = MultipartRequestWrapper.parse(hreq, this);
            if (log.isTraceEnabled()) {
                this.dumpRequestHeaders(hreq);
            }
            super.service((ServletRequest)hreq, resp);
        } else {
            super.service(req, resp);
        }
    }

    @Override
    public long maximumMultipartFileSize() {
        return 0x3200000L;
    }

    @Override
    public boolean stashFileSizeException() {
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected boolean isAuthorizedToDisplayPage(HttpServletRequest request, HttpServletResponse response, AuthorizationRequest actions) {
        if (actions != AuthorizationRequest.AUTHORIZED) {
            LogoutRedirector.recordRestrictedPageUri(request);
        }
        if (PolicyHelper.isAuthorizedForActions(request, actions)) {
            log.debug((Object)("Servlet '" + this.getClass().getSimpleName() + "' is authorized for actions: " + actions));
            return true;
        }
        log.debug((Object)("Servlet '" + this.getClass().getSimpleName() + "' is not authorized for actions: " + actions));
        VitroHttpServlet.redirectUnauthorizedRequest(request, response);
        return false;
    }

    public static void redirectUnauthorizedRequest(HttpServletRequest request, HttpServletResponse response) {
        if (LoginStatusBean.getBean(request).isLoggedIn()) {
            VitroHttpServlet.redirectToInsufficientAuthorizationPage(request, response);
        } else {
            VitroHttpServlet.redirectToLoginPage(request, response);
        }
    }

    public static void redirectToInsufficientAuthorizationPage(HttpServletRequest request, HttpServletResponse response) {
        try {
            DisplayMessage.setMessage(request, I18n.bundle(request).text("insufficient_authorization", new Object[0]));
            response.sendRedirect(request.getContextPath());
        }
        catch (IOException e) {
            log.error((Object)"Could not redirect to show insufficient authorization.");
        }
    }

    public static void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = VitroHttpServlet.assembleUrlToReturnHere(request);
        String loginUrlWithReturn = VitroHttpServlet.assembleLoginUrlWithReturn(request, returnUrl);
        try {
            response.sendRedirect(loginUrlWithReturn);
        }
        catch (IOException ioe) {
            log.error((Object)"Could not redirect to login page");
        }
    }

    private static String assembleUrlToReturnHere(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return request.getRequestURI();
        }
        return request.getRequestURI() + "?" + UrlBuilder.urlEncode(queryString);
    }

    private static String assembleLoginUrlWithReturn(HttpServletRequest request, String afterLoginUrl) {
        String encodedAfterLoginUrl = afterLoginUrl;
        try {
            encodedAfterLoginUrl = URLEncoder.encode(afterLoginUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Really? No UTF-8 encoding?", (Throwable)e);
        }
        return request.getContextPath() + "/authenticate" + "?afterLogin=" + encodedAfterLoginUrl;
    }

    protected void sortForPickList(List<? extends ResourceBean> beans, VitroRequest vreq) {
        beans.sort(new PickListSorter(vreq));
    }

    private void dumpRequestHeaders(HttpServletRequest req) {
        Enumeration names = req.getHeaderNames();
        Log subclassLog = LogFactory.getLog(this.getClass());
        subclassLog.trace((Object)("----------------------request:" + req.getRequestURL()));
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (BORING_HEADERS.contains(name)) continue;
            subclassLog.trace((Object)(name + "=" + req.getHeader(name)));
        }
    }

    protected void dumpRequestParameters(HttpServletRequest req) {
        Log subclassLog = LogFactory.getLog(this.getClass());
        Map map = req.getParameterMap();
        for (String key : map.keySet()) {
            Object[] values = (String[])map.get(key);
            subclassLog.debug((Object)("Parameter '" + key + "' = " + Arrays.deepToString(values)));
        }
    }

    protected class PickListSorter
    implements Comparator<ResourceBean> {
        Collator collator;

        public PickListSorter(VitroRequest vreq) {
            this.collator = vreq.getCollator();
        }

        @Override
        public int compare(ResourceBean b1, ResourceBean b2) {
            return this.collator.compare(b1.getPickListName(), b2.getPickListName());
        }
    }
}

