/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.RootAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsUserController;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsDeleter
extends UserAccountsPage {
    private static final Log log = LogFactory.getLog(UserAccountsDeleter.class);
    private static final String PARAMETER_DELETE_ACCOUNT = "deleteAccount";
    private final String[] uris;
    private String bogusMessage = "";

    public UserAccountsDeleter(VitroRequest vreq) {
        super(vreq);
        String[] values = vreq.getParameterValues(PARAMETER_DELETE_ACCOUNT);
        this.uris = values == null ? new String[0] : values;
        WebappDaoFactory wadf = vreq.getWebappDaoFactory();
        this.validateInputUris();
    }

    private void validateInputUris() {
        UserAccount loggedInAccount = LoginStatusBean.getCurrentUser((HttpServletRequest)this.vreq);
        if (loggedInAccount == null) {
            log.warn((Object)"Trying to delete accounts while not logged in!");
            this.bogusMessage = UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)this.vreq);
            return;
        }
        for (String uri : this.uris) {
            UserAccount u = this.userAccountsDao.getUserAccountByUri(uri);
            if (u == null) {
                log.warn((Object)("Delete account for '" + uri + "' is bogus: no such user"));
                this.bogusMessage = UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)this.vreq);
                return;
            }
            if (u.getUri().equals(loggedInAccount.getUri())) {
                log.warn((Object)("'" + u.getUri() + "' is trying to delete his own account."));
                this.bogusMessage = UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)this.vreq);
                return;
            }
            if (!u.isRootUser() || PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, (AccessObject)new RootAccessObject(), AccessOperation.DROP)) continue;
            log.warn((Object)("Attempting to delete the root account, but not authorized. Logged in as " + LoginStatusBean.getCurrentUser((HttpServletRequest)this.vreq)));
            this.bogusMessage = UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)this.vreq);
            return;
        }
    }

    public Collection<String> delete() {
        ArrayList<String> deletedUris = new ArrayList<String>();
        for (String uri : this.uris) {
            UserAccount u = this.userAccountsDao.getUserAccountByUri(uri);
            if (u == null) continue;
            this.userAccountsDao.deleteUserAccount(uri);
            deletedUris.add(uri);
        }
        return deletedUris;
    }

    public boolean isBogus() {
        return !this.bogusMessage.isEmpty();
    }

    public String getBogusMessage() {
        return this.bogusMessage;
    }
}

