/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.admin;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ActiveIdentifierBundleFactories;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasAssociatedIndividual;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.rdf.model.Model;

@WebServlet(name="ShowAuth", urlPatterns={"/admin/showAuth"})
public class ShowAuthController
extends FreemarkerHttpServlet {
    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return AuthorizationRequest.AUTHORIZED;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("identifiers", this.getSortedIdentifiers(vreq));
        body.put("currentUser", LoginStatusBean.getCurrentUser((HttpServletRequest)vreq));
        body.put("associatedIndividuals", this.getAssociatedIndividuals(vreq));
        body.put("factories", ActiveIdentifierBundleFactories.getFactoryNames());
        body.put("policies", PolicyStore.getInstance().getShortUris());
        body.put("matchingProperty", this.getMatchingProperty(vreq));
        body.put("authenticator", Authenticator.getInstance((HttpServletRequest)vreq));
        return new TemplateResponseValues("admin-showAuth.ftl", body);
    }

    private List<Identifier> getSortedIdentifiers(VitroRequest vreq) {
        TreeMap<String, Identifier> idMap = new TreeMap<String, Identifier>();
        for (Identifier id : RequestIdentifiers.getIdBundleForRequest((ServletRequest)vreq)) {
            idMap.put(id.toString(), id);
        }
        return new ArrayList<Identifier>(idMap.values());
    }

    private String getMatchingProperty(VitroRequest vreq) {
        return ConfigurationProperties.getBean((ServletRequest)vreq).getProperty("selfEditing.idMatchingProperty", "");
    }

    private List<AssociatedIndividual> getAssociatedIndividuals(VitroRequest vreq) {
        ArrayList<AssociatedIndividual> list = new ArrayList<AssociatedIndividual>();
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)vreq);
        for (String uri : HasAssociatedIndividual.getIndividualUris(ids)) {
            list.add(new AssociatedIndividual(uri, this.mayEditIndividual(vreq, uri)));
        }
        return list;
    }

    private boolean mayEditIndividual(VitroRequest vreq, String individualUri) {
        ObjectPropertyStatementAccessObject action = new ObjectPropertyStatementAccessObject((Model)vreq.getJenaOntModel(), individualUri, AccessObject.SOME_PREDICATE, AccessObject.SOME_URI);
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AccessObject)action, AccessOperation.EDIT);
    }

    public class AssociatedIndividual {
        private final String uri;
        private final boolean editable;

        public AssociatedIndividual(String uri, boolean editable) {
            this.uri = uri;
            this.editable = editable;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

