/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaImplementation;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaServiceBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.mail.Message;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="forgotPassword", urlPatterns={"/forgotPassword"})
public class ForgotPasswordController
extends FreemarkerHttpServlet {
    private static final String RESET_PASSWORD_URL = "/accounts/resetPassword";
    private static final int DAYS_TO_USE_PASSWORD_LINK = 5;
    private static final String TEMPLATE_NAME = "userAccounts-resetPasswordRequest.ftl";
    private static final Log log = LogFactory.getLog((String)ForgotPasswordController.class.getName());
    private CaptchaImplementation captchaImpl;

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) throws Exception {
        this.sleepForRandomTime();
        this.captchaImpl = CaptchaServiceBean.getCaptchaImpl();
        HashMap<String, Object> dataContext = new HashMap<String, Object>();
        this.setCommonValues(dataContext, vreq);
        CaptchaServiceBean.addCaptchaRelatedFieldsToPageContext(dataContext);
        boolean isEnabled = this.isFunctionalityEnabled();
        dataContext.put("isEnabled", isEnabled);
        if (!isEnabled || vreq.getMethod().equalsIgnoreCase("GET")) {
            return this.showForm(dataContext);
        }
        return this.handlePostRequest(vreq, dataContext);
    }

    private ResponseValues handlePostRequest(VitroRequest vreq, Map<String, Object> dataContext) {
        UserAccountsDao userAccountsDao = this.constructUserAccountsDao();
        I18nBundle i18n = I18n.bundle((HttpServletRequest)vreq);
        String rawEmailInput = vreq.getParameter("email");
        if (rawEmailInput != null && rawEmailInput.length() > 320) {
            dataContext.put("errorMessage", i18n.text("error_invalid_email", new Object[0]));
            return this.showForm(dataContext);
        }
        String email = this.getNonNullTrimmedParameterValue((HttpServletRequest)vreq, "email");
        if (!email.matches("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}")) {
            dataContext.put("errorMessage", i18n.text("error_invalid_email", email));
            return this.showForm(dataContext);
        }
        if (!this.captchaIsValid(vreq)) {
            dataContext.put("wrongCaptcha", true);
            dataContext.put("emailValue", email);
            return this.showForm(dataContext);
        }
        dataContext.put("showPasswordChangeForm", false);
        Optional<UserAccount> userAccountOptional = this.getAccountForInternalAuth(email);
        if (userAccountOptional.isPresent()) {
            this.requestPasswordChange(userAccountOptional.get(), userAccountsDao);
            this.notifyUser(userAccountOptional.get(), i18n, vreq);
        } else {
            log.info((Object)("User tried to reset password with an unassociated email: " + email));
        }
        return this.emailSentNotification(dataContext, i18n, email);
    }

    private boolean captchaIsValid(VitroRequest vreq) {
        String challengeId;
        String captchaInput;
        switch (this.captchaImpl) {
            case RECAPTCHAV2: {
                captchaInput = this.getNonNullTrimmedParameterValue((HttpServletRequest)vreq, "g-recaptcha-response");
                challengeId = "";
                break;
            }
            default: {
                captchaInput = this.getNonNullTrimmedParameterValue((HttpServletRequest)vreq, "userSolution");
                challengeId = this.getNonNullTrimmedParameterValue((HttpServletRequest)vreq, "challengeId");
            }
        }
        return CaptchaServiceBean.validateCaptcha(captchaInput, challengeId);
    }

    private void notifyUser(UserAccount userAccount, I18nBundle i18n, VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userAccount", userAccount);
        body.put("passwordLink", this.buildResetPasswordLink(userAccount.getEmailAddress(), userAccount.getEmailKey(), vreq));
        body.put("siteName", vreq.getAppBean().getApplicationName());
        body.put("subject", i18n.text("password_reset_pending_email_subject", new Object[0]));
        body.put("textMessage", i18n.text("password_reset_pending_email_plain_text", new Object[0]));
        body.put("htmlMessage", i18n.text("password_reset_pending_email_html_text", new Object[0]));
        this.sendEmailMessage(body, vreq, userAccount.getEmailAddress());
        if (this.adminShouldBeNotified()) {
            this.notifyAdmin(userAccount, i18n, vreq);
        }
    }

    private void notifyAdmin(UserAccount userAccount, I18nBundle i18n, VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userAccount", userAccount);
        body.put("siteName", vreq.getAppBean().getApplicationName());
        body.put("subject", i18n.text("password_reset_admin_notification_email_subject", new Object[0]));
        body.put("textMessage", i18n.text("password_reset_admin_notification_email_plain_text", new Object[0]));
        body.put("htmlMessage", i18n.text("password_reset_admin_notification_email_html", new Object[0]));
        String adminEmailAddress = Objects.requireNonNull(ConfigurationProperties.getInstance().getProperty("email.replyTo"));
        this.sendEmailMessage(body, vreq, adminEmailAddress);
    }

    private void sendEmailMessage(Map<String, Object> body, VitroRequest vreq, String recipientEmail) {
        FreemarkerEmailMessage emailMessage = FreemarkerEmailFactory.createNewMessage(vreq);
        emailMessage.addRecipient(Message.RecipientType.TO, recipientEmail);
        emailMessage.setBodyMap(body);
        emailMessage.processTemplate();
        emailMessage.send();
    }

    private boolean adminShouldBeNotified() {
        String adminShouldBeNotified = ConfigurationProperties.getInstance().getProperty("authentication.forgotPassword.notify-admin");
        return Boolean.parseBoolean(adminShouldBeNotified);
    }

    private void setCommonValues(Map<String, Object> dataContext, VitroRequest vreq) {
        ApplicationBean appBean = vreq.getAppBean();
        dataContext.put("forgotPasswordUrl", this.getForgotPasswordUrl(vreq));
        dataContext.put("contactUrl", this.getContactUrl(vreq));
        dataContext.put("contextPath", vreq.getContextPath());
        dataContext.put("emailConfigured", FreemarkerEmailFactory.isConfigured((HttpServletRequest)vreq));
        dataContext.put("emailValue", "");
        dataContext.put("contactEmailConfigured", StringUtils.isNotBlank((CharSequence)appBean.getContactMail()));
        dataContext.put("wrongCaptcha", false);
    }

    private ResponseValues emailSentNotification(Map<String, Object> dataContext, I18nBundle i18n, String email) {
        dataContext.put("message", i18n.text("password_reset_email_sent", email));
        return new TemplateResponseValues(TEMPLATE_NAME, dataContext);
    }

    private ResponseValues showForm(Map<String, Object> dataContext) {
        dataContext.put("showPasswordChangeForm", true);
        return new TemplateResponseValues(TEMPLATE_NAME, dataContext);
    }

    private UserAccountsDao constructUserAccountsDao() {
        WebappDaoFactory wdf = ModelAccess.getInstance().getWebappDaoFactory();
        return wdf.getUserAccountsDao();
    }

    private void requestPasswordChange(UserAccount userAccount, UserAccountsDao userAccountsDao) {
        userAccount.setPasswordLinkExpires(this.calculateExpirationDate().getTime());
        userAccount.generateEmailKey();
        userAccountsDao.updateUserAccount(userAccount);
    }

    private Optional<UserAccount> getAccountForInternalAuth(String emailAddress) {
        UserAccountsDao userAccountsDao = this.getUserAccountsDao();
        if (userAccountsDao == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(userAccountsDao.getUserAccountByEmail(emailAddress));
    }

    private UserAccountsDao getUserAccountsDao() {
        UserAccountsDao userAccountsDao = this.getWebappDaoFactory().getUserAccountsDao();
        if (userAccountsDao == null) {
            log.error((Object)"getUserAccountsDao: no UserAccountsDao");
        }
        return userAccountsDao;
    }

    private WebappDaoFactory getWebappDaoFactory() {
        return ModelAccess.getInstance().getWebappDaoFactory();
    }

    private String buildResetPasswordLink(String email, String key, VitroRequest vreq) {
        try {
            String relativeUrl = UrlBuilder.getUrl(RESET_PASSWORD_URL, "user", email, "key", key);
            URL context = new URL(vreq.getRequestURL().toString());
            URL url = new URL(context, relativeUrl);
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            return "error_creating_password_link";
        }
    }

    private Date calculateExpirationDate() {
        Calendar c = Calendar.getInstance();
        c.add(5, 5);
        return c.getTime();
    }

    private String getForgotPasswordUrl(VitroRequest request) {
        String contextPath = request.getContextPath();
        return contextPath + "/forgotPassword";
    }

    private String getContactUrl(VitroRequest request) {
        String contextPath = request.getContextPath();
        return contextPath + "/contact";
    }

    private boolean isFunctionalityEnabled() {
        String enabled = ConfigurationProperties.getInstance().getProperty("authentication.forgotPassword");
        return enabled != null && enabled.equalsIgnoreCase("enabled");
    }

    private void sleepForRandomTime() {
        Random random = new Random();
        int minSleepTime = 100;
        int maxSleepTime = 500;
        int randomSleepTime = random.nextInt(maxSleepTime - minSleepTime + 1) + minSleepTime;
        try {
            Thread.sleep(randomSleepTime);
        }
        catch (InterruptedException e) {
            log.error((Object)(randomSleepTime + "ms sleep time for mitigating time-based attacks was interrupted."));
        }
    }

    private String getNonNullTrimmedParameterValue(HttpServletRequest request, String parameterKey) {
        String parameterValue = request.getParameter(parameterKey);
        return parameterValue == null ? "" : parameterValue.trim();
    }
}

