/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginRedirector {
    private static final Log log = LogFactory.getLog(LoginRedirector.class);
    private final HttpServletRequest request;
    private final HttpSession session;
    private final I18nBundle i18n;
    private final String uriOfAssociatedIndividual;
    private final String afterLoginPage;

    public LoginRedirector(HttpServletRequest request, String afterLoginPage) {
        this.request = request;
        this.session = request.getSession();
        this.i18n = I18n.bundle(request);
        this.afterLoginPage = afterLoginPage;
        this.uriOfAssociatedIndividual = this.getAssociatedIndividualUri();
    }

    private String getAssociatedIndividualUri() {
        UserAccount userAccount = LoginStatusBean.getCurrentUser(this.request);
        if (userAccount == null) {
            log.debug((Object)"Not logged in? Must be cancelling the password change");
            return null;
        }
        List<String> uris = Authenticator.getInstance(this.request).getAssociatedIndividualUris(userAccount);
        if (uris.isEmpty()) {
            log.debug((Object)("'" + userAccount.getEmailAddress() + "' is not associated with an individual."));
            return null;
        }
        String uri = uris.get(0);
        log.debug((Object)("'" + userAccount.getEmailAddress() + "' is associated with an individual: " + uri));
        return uri;
    }

    public String getRedirectionUriForLoggedInUser() {
        if (this.isSelfEditorWithIndividual()) {
            log.debug((Object)"Going to Individual home page.");
            return this.getAssociatedIndividualHomePage();
        }
        if (null != this.afterLoginPage) {
            if (this.isLoginPage(this.afterLoginPage)) {
                if (this.canSeeSiteAdminPage()) {
                    log.debug((Object)"Coming from /login. Going to site admin page.");
                    return this.getSiteAdminPageUrl();
                }
                log.debug((Object)"User not recognized. Going to application home.");
                return this.getApplicationHomePageUrl();
            }
            log.debug((Object)("Returning to requested page: " + this.afterLoginPage));
            return this.afterLoginPage;
        }
        log.debug((Object)"Don't know what to do. Go home.");
        return this.getApplicationHomePageUrl();
    }

    public String getRedirectionUriForCancellingUser() {
        if (this.isLoginPage(this.afterLoginPage)) {
            log.debug((Object)"Coming from /login. Going to home.");
            return this.getApplicationHomePageUrl();
        }
        if (null != this.afterLoginPage) {
            log.debug((Object)("Returning to requested page: " + this.afterLoginPage));
            return this.afterLoginPage;
        }
        log.debug((Object)"Don't know what to do. Go home.");
        return this.getApplicationHomePageUrl();
    }

    public void redirectLoggedInUser(HttpServletResponse response) throws IOException {
        try {
            DisplayMessage.setMessage(this.request, this.assembleWelcomeMessage());
            String redirectUrl = this.getRedirectionUriForLoggedInUser();
            log.debug((Object)("Sending redirect to path: " + redirectUrl));
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            log.debug((Object)"Problem with re-direction", (Throwable)e);
            response.sendRedirect(this.getApplicationHomePageUrl());
        }
    }

    public String assembleWelcomeMessage() {
        if (!this.canSeeSiteAdminPage() && !this.isSelfEditorWithIndividual()) {
            return this.i18n.text("logged_in_but_no_profile", new Object[0]);
        }
        String greeting = this.i18n.text("unknown_user_name", new Object[0]);
        int loginCount = 0;
        UserAccount userAccount = LoginStatusBean.getCurrentUser(this.request);
        if (userAccount != null) {
            loginCount = userAccount.getLoginCount();
            if (StringUtils.isNotEmpty((CharSequence)userAccount.getFirstName())) {
                greeting = userAccount.getFirstName();
            } else if (StringUtils.isNotEmpty((CharSequence)userAccount.getEmailAddress())) {
                greeting = userAccount.getEmailAddress();
            }
        }
        return this.i18n.text("login_welcome_message", greeting, loginCount);
    }

    public void redirectCancellingUser(HttpServletResponse response) throws IOException {
        try {
            response.sendRedirect(this.getRedirectionUriForCancellingUser());
        }
        catch (IOException e) {
            log.debug((Object)"Problem with re-direction", (Throwable)e);
            response.sendRedirect(this.getApplicationHomePageUrl());
        }
    }

    private boolean canSeeSiteAdminPage() {
        return PolicyHelper.isAuthorizedForActions(this.request, (AuthorizationRequest)SimplePermission.SEE_SITE_ADMIN_PAGE.ACTION);
    }

    private boolean isLoginPage(String page) {
        return page != null && page.endsWith(this.request.getContextPath() + "/login");
    }

    private String getSiteAdminPageUrl() {
        String contextPath = this.request.getContextPath();
        return contextPath + "/siteAdmin";
    }

    private boolean isSelfEditorWithIndividual() {
        return this.uriOfAssociatedIndividual != null;
    }

    private String getAssociatedIndividualHomePage() {
        try {
            return this.request.getContextPath() + "/individual?uri=" + URLEncoder.encode(this.uriOfAssociatedIndividual, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("No UTF-8 encoding? Really?", e);
        }
    }

    private String getApplicationHomePageUrl() {
        String contextPath = this.request.getContextPath();
        if (contextPath.equals("")) {
            return "/";
        }
        return contextPath;
    }
}

