/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LoginInProcessFlag;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LoginRedirector;
import edu.cornell.mannlib.vitro.webapp.controller.login.LoginProcessBean;
import edu.cornell.mannlib.vitro.webapp.dao.jena.LoginLogoutEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;

@WebServlet(name="authenticate", urlPatterns={"/authenticate"})
public class Authenticate
extends VitroHttpServlet {
    private static final Log log = LogFactory.getLog((String)Authenticate.class.getName());
    private static final String PARAMETER_AFTER_LOGIN = "afterLogin";
    private static final String PARAMETER_RETURN = "return";
    private static final String PARAMETER_USERNAME = "loginName";
    private static final String PARAMETER_PASSWORD = "loginPassword";
    private static final String PARAMETER_NEW_PASSWORD = "newPassword";
    private static final String PARAMETER_CONFIRM_PASSWORD = "confirmPassword";
    private static final String PARAMETER_CANCEL = "cancel";
    private static final String PARAMETER_LOGIN_FORM = "loginForm";
    public static final String USER_SESSION_MAP_ATTR = "userURISessionMap";

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        VitroRequest vreq = new VitroRequest(request);
        try {
            if (this.loginProcessIsRestarting((HttpServletRequest)vreq)) {
                LoginProcessBean.removeBean((HttpServletRequest)vreq);
            }
            if (this.loginProcessPagesAreEmpty((HttpServletRequest)vreq)) {
                this.recordLoginProcessPages((HttpServletRequest)vreq);
            }
            LoginProcessBean.State entryState = this.getCurrentLoginState((HttpServletRequest)vreq);
            this.dumpStateToLog("entry", entryState, vreq);
            switch (entryState) {
                case NOWHERE: {
                    this.processInputNowhere((HttpServletRequest)vreq);
                    break;
                }
                case LOGGING_IN: {
                    this.processInputLoggingIn((HttpServletRequest)vreq);
                    break;
                }
                case FORCED_PASSWORD_CHANGE: {
                    this.processInputChangePassword((HttpServletRequest)vreq);
                    break;
                }
                default: {
                    this.processInputLoggedIn((HttpServletRequest)vreq);
                }
            }
            LoginProcessBean.State exitState = this.getCurrentLoginState((HttpServletRequest)vreq);
            this.dumpStateToLog("exit", exitState, vreq);
            switch (exitState) {
                case NOWHERE: {
                    this.showLoginCanceled(response, vreq);
                    break;
                }
                case LOGGING_IN: {
                    this.showLoginScreen(vreq, response);
                    break;
                }
                case FORCED_PASSWORD_CHANGE: {
                    this.showLoginScreen(vreq, response);
                    break;
                }
                default: {
                    this.showLoginComplete(response, vreq);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.showSystemError(e, response);
        }
    }

    private boolean loginProcessIsRestarting(HttpServletRequest request) {
        if (this.isAfterLoginParameterSet(request)) {
            log.debug((Object)"after-login parameter is set: restarting the login.");
            return true;
        }
        if (this.isReturnParameterSet(request)) {
            log.debug((Object)"return parameter is set: restarting the login.");
            return true;
        }
        return false;
    }

    private boolean loginProcessPagesAreEmpty(HttpServletRequest request) {
        LoginProcessBean bean = LoginProcessBean.getBean(request);
        return bean.getAfterLoginUrl() == null && bean.getLoginPageUrl() == null;
    }

    private void recordLoginProcessPages(HttpServletRequest request) {
        LoginProcessBean bean = LoginProcessBean.getBean(request);
        String afterLoginUrl = this.decodeAfterLoginParameter(request);
        boolean doReturn = this.isReturnParameterSet(request);
        String referrer = this.whereDidWeComeFrom(request);
        if (afterLoginUrl != null) {
            bean.setAfterLoginUrl(afterLoginUrl);
            bean.setLoginPageUrl(request.getContextPath() + "/login");
        } else if (doReturn) {
            bean.setAfterLoginUrl(referrer);
            bean.setLoginPageUrl(request.getContextPath() + "/login");
        } else {
            bean.setAfterLoginUrl(referrer);
            bean.setLoginPageUrl(referrer);
        }
    }

    private String decodeAfterLoginParameter(HttpServletRequest request) {
        String parm = request.getParameter(PARAMETER_AFTER_LOGIN);
        if (parm == null) {
            return null;
        }
        try {
            return URLDecoder.decode(parm, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"No UTF-8 encoding? Really?", (Throwable)e);
            return parm;
        }
    }

    private boolean isAfterLoginParameterSet(HttpServletRequest request) {
        return null != request.getParameter(PARAMETER_AFTER_LOGIN);
    }

    private boolean isReturnParameterSet(HttpServletRequest request) {
        return null != request.getParameter(PARAMETER_RETURN);
    }

    private String whereDidWeComeFrom(HttpServletRequest request) {
        String referrer = request.getHeader("referer");
        if (referrer != null) {
            return referrer;
        }
        return request.getContextPath() + "/login";
    }

    private LoginProcessBean.State getCurrentLoginState(HttpServletRequest request) {
        LoginProcessBean.State currentState;
        HttpSession session = request.getSession(false);
        if (session == null) {
            currentState = LoginProcessBean.State.NOWHERE;
            log.debug((Object)"no session: current state is NOWHERE");
        } else if (LoginStatusBean.getBean(request).isLoggedIn()) {
            currentState = LoginProcessBean.State.LOGGED_IN;
            log.debug((Object)"found a LoginStatusBean: current state is LOGGED IN");
        } else if (LoginProcessBean.isBean(request)) {
            currentState = LoginProcessBean.getBean(request).getState();
            log.debug((Object)("state from LoginProcessBean is " + (Object)((Object)currentState)));
        } else {
            currentState = LoginProcessBean.State.NOWHERE;
            log.debug((Object)"no LoginSessionBean, no LoginProcessBean: current state is NOWHERE");
        }
        if (this.weCameFromAColdWidget(request, currentState)) {
            currentState = this.actLikeWeWereLoggingIn(request);
        }
        return currentState;
    }

    private boolean weCameFromAColdWidget(HttpServletRequest request, LoginProcessBean.State currentState) {
        return currentState == LoginProcessBean.State.NOWHERE && null != request.getParameter(PARAMETER_LOGIN_FORM);
    }

    private LoginProcessBean.State actLikeWeWereLoggingIn(HttpServletRequest request) {
        LoginProcessBean bean = new LoginProcessBean();
        bean.setState(LoginProcessBean.State.LOGGING_IN);
        bean.setLoginPageUrl(this.whereDidWeComeFrom(request));
        bean.setAfterLoginUrl(this.whereDidWeComeFrom(request));
        LoginProcessBean.setBean(request, bean);
        return LoginProcessBean.State.LOGGING_IN;
    }

    private void processInputNowhere(HttpServletRequest request) {
        this.transitionToLoggingIn(request);
    }

    private void processInputLoggingIn(HttpServletRequest request) {
        String username = request.getParameter(PARAMETER_USERNAME);
        String password = request.getParameter(PARAMETER_PASSWORD);
        LoginProcessBean bean = LoginProcessBean.getBean(request);
        bean.clearMessage();
        log.trace((Object)("username=" + username + ", password=" + password + ", bean=" + bean));
        if (username == null || username.isEmpty()) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_no_email_address", new Object[0]);
            return;
        }
        bean.setUsername(username);
        UserAccount user = this.getAuthenticator(request).getAccountForInternalAuth(username);
        log.trace((Object)("User is " + (user == null ? "null" : user.getUri())));
        if (user == null) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_incorrect_credentials", new Object[0]);
            return;
        }
        if (password == null || password.isEmpty()) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_no_password", new Object[0]);
            return;
        }
        if (!this.getAuthenticator(request).isUserPermittedToLogin(user)) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "logins_disabled_for_maintenance", new Object[0]);
            return;
        }
        if (this.getAuthenticator(request).md5HashIsNull(user)) {
            if (!this.getAuthenticator(request).isCurrentPasswordArgon2(user, password)) {
                bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_incorrect_credentials", new Object[0]);
                return;
            }
        } else {
            if (!this.getAuthenticator(request).isCurrentPassword(user, password)) {
                bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_incorrect_credentials", new Object[0]);
                return;
            }
            user.setPasswordChangeRequired(true);
            user.setMd5Password("");
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "password_system_has_changed", new Object[0]);
        }
        if (user.isPasswordChangeRequired()) {
            this.transitionToForcedPasswordChange(request);
        } else {
            try {
                this.transitionToLoggedIn(request, user);
            }
            catch (Authenticator.LoginNotPermitted e) {
                bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "logins_disabled_for_maintenance", new Object[0]);
            }
        }
    }

    private void processInputChangePassword(HttpServletRequest request) {
        String newPassword = request.getParameter(PARAMETER_NEW_PASSWORD);
        String confirm = request.getParameter(PARAMETER_CONFIRM_PASSWORD);
        String cancel = request.getParameter(PARAMETER_CANCEL);
        if (Boolean.valueOf(cancel).booleanValue()) {
            this.transitionToNowhere(request);
            return;
        }
        LoginProcessBean bean = LoginProcessBean.getBean(request);
        bean.clearMessage();
        log.trace((Object)("newPassword=" + newPassword + ", confirm=" + confirm + ", bean=" + bean));
        if (newPassword == null || newPassword.isEmpty()) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_no_new_password", new Object[0]);
            return;
        }
        if (!newPassword.equals(confirm)) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_passwords_dont_match", new Object[0]);
            return;
        }
        if (newPassword.length() < 6 || newPassword.length() > 64) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_password_length", 6, 64);
            return;
        }
        String username = bean.getUsername();
        UserAccount user = this.getAuthenticator(request).getAccountForInternalAuth(username);
        if (this.getAuthenticator(request).isCurrentPasswordArgon2(user, newPassword)) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "error_previous_password", new Object[0]);
            return;
        }
        try {
            this.transitionToLoggedIn(request, user, newPassword);
        }
        catch (Authenticator.LoginNotPermitted e) {
            bean.setMessage(request, LoginProcessBean.MLevel.ERROR, "logins_disabled_for_maintenance", new Object[0]);
        }
    }

    private void processInputLoggedIn(HttpServletRequest request) {
    }

    private void transitionToLoggingIn(HttpServletRequest request) {
        log.debug((Object)"Starting the login process.");
        LoginProcessBean.getBean(request).setState(LoginProcessBean.State.LOGGING_IN);
    }

    private void transitionToForcedPasswordChange(HttpServletRequest request) {
        log.debug((Object)"Forcing first-time password change");
        LoginProcessBean.getBean(request).setState(LoginProcessBean.State.FORCED_PASSWORD_CHANGE);
    }

    private void transitionToLoggedIn(HttpServletRequest request, UserAccount user) throws Authenticator.LoginNotPermitted {
        log.debug((Object)("Completed login: " + user.getEmailAddress()));
        this.getAuthenticator(request).recordLoginAgainstUserAccount(user, LoginStatusBean.AuthenticationSource.INTERNAL);
    }

    private void transitionToLoggedIn(HttpServletRequest request, UserAccount user, String newPassword) throws Authenticator.LoginNotPermitted {
        log.debug((Object)("Completed login: " + user.getEmailAddress() + ", password changed."));
        this.getAuthenticator(request).recordNewPassword(user, newPassword);
        this.getAuthenticator(request).recordLoginAgainstUserAccount(user, LoginStatusBean.AuthenticationSource.INTERNAL);
    }

    private void transitionToNowhere(HttpServletRequest request) {
        LoginProcessBean.getBean(request).setState(LoginProcessBean.State.NOWHERE);
        log.debug((Object)"Cancelling login.");
    }

    private void showSystemError(Exception e, HttpServletResponse response) {
        log.error((Object)"Unexpected error in login process", (Throwable)e);
        try {
            response.sendError(500);
        }
        catch (IOException e1) {
            log.error((Object)e1, (Throwable)e1);
        }
    }

    private void showLoginScreen(VitroRequest vreq, HttpServletResponse response) throws IOException {
        log.debug((Object)"logging in.");
        LoginInProcessFlag.set((HttpServletRequest)vreq);
        String loginProcessPage = LoginProcessBean.getBean((HttpServletRequest)vreq).getLoginPageUrl();
        response.sendRedirect(loginProcessPage);
    }

    private void showLoginComplete(HttpServletResponse response, VitroRequest vreq) throws IOException {
        this.getLoginRedirector(vreq).redirectLoggedInUser(response);
        LoginProcessBean.removeBean((HttpServletRequest)vreq);
    }

    private void showLoginCanceled(HttpServletResponse response, VitroRequest vreq) throws IOException {
        this.getLoginRedirector(vreq).redirectCancellingUser(response);
        LoginProcessBean.removeBean((HttpServletRequest)vreq);
    }

    private LoginRedirector getLoginRedirector(VitroRequest vreq) {
        String afterLoginUrl = LoginProcessBean.getBean((HttpServletRequest)vreq).getAfterLoginUrl();
        return new LoginRedirector((HttpServletRequest)vreq, afterLoginUrl);
    }

    private Authenticator getAuthenticator(HttpServletRequest request) {
        return Authenticator.getInstance(request);
    }

    public static Map<String, HttpSession> getUserURISessionMapFromContext(ServletContext ctx) {
        HashMap m = (HashMap)ctx.getAttribute(USER_SESSION_MAP_ATTR);
        if (m == null) {
            m = new HashMap();
            ctx.setAttribute(USER_SESSION_MAP_ATTR, m);
        }
        return m;
    }

    public static void sendLoginNotifyEvent(LoginLogoutEvent event, ServletContext context, HttpSession session) {
        if (event == null) {
            log.warn((Object)"Unable to notify audit model of login because a null event was passed");
            return;
        }
        OntModel jenaOntModel = ModelAccess.on(context).getOntModel();
        jenaOntModel.getBaseModel().notifyEvent((Object)event);
    }

    private void dumpStateToLog(String label, LoginProcessBean.State state, VitroRequest vreq) {
        log.debug((Object)("State on " + label + ": " + (Object)((Object)state)));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Status bean on " + label + ": " + LoginStatusBean.getBean((HttpServletRequest)vreq)));
            LoginProcessBean processBean = null;
            if (LoginProcessBean.isBean((HttpServletRequest)vreq)) {
                processBean = LoginProcessBean.getBean((HttpServletRequest)vreq);
            }
            log.trace((Object)("Process bean on " + label + ": " + processBean));
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }
}

