/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.DynamicField;
import edu.cornell.mannlib.vedit.beans.DynamicFieldRow;
import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.forwarder.impl.UrlForwarder;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.impl.RequiredFieldValidator;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.listener.impl.IndividualDataPropertyStatementProcessor;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="EntityRetryController", urlPatterns={"/entity_retry"})
public class EntityRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)EntityRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.DO_BACK_END_EDITING.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        String siteAdminUrl = vreq.getContextPath() + "/siteAdmin";
        EditProcessObject epo = super.createEpo(request);
        epo.setBeanClass(Individual.class);
        epo.setImplementationClass(IndividualImpl.class);
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        LoginStatusBean loginBean = LoginStatusBean.getBean(request);
        WebappDaoFactory myWebappDaoFactory = this.getWebappDaoFactory(loginBean.getUserURI());
        IndividualDao ewDao = myWebappDaoFactory.getIndividualDao();
        epo.setDataAccessObject(ewDao);
        VClassDao vcDao = myWebappDaoFactory.getVClassDao();
        VClassGroupDao cgDao = myWebappDaoFactory.getVClassGroupDao();
        DataPropertyDao dpDao = myWebappDaoFactory.getDataPropertyDao();
        Individual individualForEditing = null;
        if (epo.getUseRecycledBean()) {
            individualForEditing = (Individual)epo.getNewBean();
        } else {
            String uri = vreq.getParameter("uri");
            if (uri != null) {
                try {
                    individualForEditing = ewDao.getIndividualByURI(uri);
                    action = "update";
                    epo.setAction("update");
                }
                catch (NullPointerException e) {
                    log.error((Object)"Need to implement 'record not found' error message.");
                }
            } else {
                individualForEditing = new IndividualImpl();
                if (vreq.getParameter("VClassURI") != null) {
                    individualForEditing.setVClassURI(vreq.getParameter("VClassURI"));
                }
            }
            epo.setOriginalBean(individualForEditing);
            Object[] simpleMaskPair = new Object[]{"URI", individualForEditing.getURI()};
            epo.getSimpleMask().add(simpleMaskPair);
        }
        LinkedList<RequiredFieldValidator> lnList = new LinkedList<RequiredFieldValidator>();
        lnList.add(new RequiredFieldValidator());
        epo.getValidatorMap().put("Name", lnList);
        epo.setPostInsertPageForwarder(new EntityInsertPageForwarder());
        epo.setPostDeletePageForwarder(new UrlForwarder(siteAdminUrl));
        try {
            Class[] args = new Class[]{String.class};
            epo.setGetMethod(ewDao.getClass().getDeclaredMethod("getIndividualByURI", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"EntityRetryController could not find the entityByURI method in the dao");
        }
        epo.setIdFieldName("URI");
        epo.setIdFieldClass(String.class);
        HashMap<String, List<Option>> hash = new HashMap<String, List<Option>>();
        if (individualForEditing.getVClassURI() == null) {
            List<VClassGroup> classGroups = cgDao.getPublicGroupsWithVClasses(true, true, false);
            Iterator<VClassGroup> classGroupIt = classGroups.iterator();
            ListOrderedMap optGroupMap = new ListOrderedMap();
            while (classGroupIt.hasNext()) {
                VClassGroup group = classGroupIt.next();
                Iterator<Object> classes = group.getVitroClassList();
                optGroupMap.put((Object)group.getPublicName(), FormUtils.makeOptionListFromBeans(classes, "URI", "Name", individualForEditing.getVClassURI(), null, false));
            }
            hash.put("VClassURI", (List<Option>)optGroupMap);
        } else {
            VClass vClass = null;
            Option opt = null;
            try {
                vClass = vcDao.getVClassByURI(individualForEditing.getVClassURI());
            }
            catch (Exception optGroupMap) {
                // empty catch block
            }
            opt = vClass != null ? new Option(vClass.getURI(), vClass.getName(), true) : new Option(individualForEditing.getVClassURI(), individualForEditing.getVClassURI(), true);
            LinkedList<Option> optList = new LinkedList<Option>();
            optList.add(opt);
            hash.put("VClassURI", optList);
        }
        FormObject foo = new FormObject();
        foo.setOptionLists(hash);
        ListOrderedMap dpMap = new ListOrderedMap();
        List<VClass> vclasses = individualForEditing.getVClasses(true);
        if (vclasses == null) {
            vclasses = new ArrayList<VClass>();
            if (individualForEditing.getVClassURI() != null) {
                try {
                    VClass cls = vreq.getUnfilteredWebappDaoFactory().getVClassDao().getVClassByURI(individualForEditing.getVClassURI());
                    if (cls != null) {
                        vclasses.add(cls);
                    }
                }
                catch (Exception cls) {
                    // empty catch block
                }
            }
        }
        ArrayList<DataProperty> allApplicableDataprops = new ArrayList<DataProperty>();
        for (VClass cls : vclasses) {
            List<DataProperty> dataprops = dpDao.getDataPropertiesForVClass(cls.getURI());
            for (DataProperty dp : dataprops) {
                boolean notDuplicate = true;
                for (DataProperty existingDp : allApplicableDataprops) {
                    if (!existingDp.getURI().equals(dp.getURI())) continue;
                    notDuplicate = false;
                    break;
                }
                if (!notDuplicate) continue;
                allApplicableDataprops.add(dp);
            }
        }
        Collections.sort(allApplicableDataprops);
        if (allApplicableDataprops != null) {
            for (DataProperty d : allApplicableDataprops) {
                if (dpMap.containsKey((Object)d.getURI())) continue;
                dpMap.put((Object)d.getURI(), (Object)d);
            }
            if (individualForEditing.getDataPropertyList() != null) {
                for (DataProperty existingDp : individualForEditing.getDataPropertyList()) {
                    if (existingDp.getPublicName().equals("label")) continue;
                    dpMap.put((Object)existingDp.getURI(), (Object)existingDp);
                }
            }
            ArrayList<DynamicField> dynamicFields = new ArrayList<DynamicField>();
            OrderedMapIterator dpHashIt = dpMap.mapIterator();
            while (dpHashIt.hasNext()) {
                String uri = (String)dpHashIt.next();
                DataProperty dp = (DataProperty)dpMap.get((Object)uri);
                DynamicField dynamo = new DynamicField();
                dynamo.setName(dp.getPublicName());
                dynamo.setTable("DataPropertyStatement");
                dynamo.setVisible(dp.getDisplayLimit());
                dynamo.setDeleteable(true);
                DynamicFieldRow rowTemplate = new DynamicFieldRow();
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                parameterMap.put("DatatypePropertyURI", dp.getURI());
                rowTemplate.setParameterMap(parameterMap);
                dynamo.setRowTemplate(rowTemplate);
                try {
                    for (DataPropertyStatement existingValue : dp.getDataPropertyStatements()) {
                        DynamicFieldRow row = new DynamicFieldRow();
                        row.setParameterMap(parameterMap);
                        String value = existingValue.getData();
                        row.setValue(value);
                        String language = existingValue.getLanguage();
                        if (!StringUtils.isBlank((CharSequence)language)) {
                            row.setLanguage(language);
                        }
                        if (dynamo.getRowList() == null) {
                            dynamo.setRowList(new ArrayList<DynamicFieldRow>());
                        }
                        dynamo.getRowList().add(row);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (dynamo.getRowList() == null) {
                    dynamo.setRowList(new ArrayList<DynamicFieldRow>());
                }
                dynamo.getRowList().add(rowTemplate);
                dynamicFields.add(dynamo);
            }
            foo.setDynamicFields(dynamicFields);
        }
        foo.setErrorMap(epo.getErrMsgMap());
        epo.setFormObject(foo);
        SimpleDateFormat minutesOnlyDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat dateOnlyFormat = new SimpleDateFormat("yyyy-MM-dd");
        FormUtils.populateFormFromBean(individualForEditing, action, epo, foo, epo.getBadValueMap());
        ArrayList<IndividualDataPropertyStatementProcessor> cList = new ArrayList<IndividualDataPropertyStatementProcessor>();
        cList.add(new IndividualDataPropertyStatementProcessor());
        epo.setChangeListenerList(cList);
        epo.getAdditionalDaoMap().put("DataPropertyStatement", myWebappDaoFactory.getDataPropertyStatementDao());
        epo.getAdditionalDaoMap().put("DataProperty", myWebappDaoFactory.getDataPropertyDao());
        ApplicationBean appBean = vreq.getAppBean();
        request.setAttribute("formJsp", (Object)"/templates/edit/specific/entity_retry.jsp");
        request.setAttribute("epoKey", (Object)epo.getKey());
        request.setAttribute("title", (Object)"Individual Editing Form");
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + appBean.getThemeDir() + "css/edit.css\"/>"));
        request.setAttribute("scripts", (Object)"/js/edit/entityRetry.js");
        request.setAttribute("_action", (Object)action);
        request.setAttribute("unqualifiedClassName", (Object)"Individual");
        EntityRetryController.addUriSuppressions(request, individualForEditing.getURI(), AccessObjectType.INDIVIDUAL);
        request.setAttribute("i18n", (Object)I18n.bundle((HttpServletRequest)vreq));
        this.setRequestAttributes(request, epo);
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"EntityRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class EntityInsertPageForwarder
    implements PageForwarder {
        EntityInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newEntityUrl = "entityEdit?uri=";
            Individual ent = (Individual)epo.getNewBean();
            if (ent != null && ent.getURI() != null) {
                try {
                    newEntityUrl = newEntityUrl + URLEncoder.encode(ent.getURI(), "UTF-8");
                    response.sendRedirect(newEntityUrl);
                }
                catch (Exception e) {
                    log.error((Object)"EntityInsertPageForwarder could not send redirect.");
                }
            } else {
                try {
                    String siteAdminUrl = request.getContextPath() + "/siteAdmin";
                    response.sendRedirect(siteAdminUrl);
                }
                catch (IOException e) {
                    log.error((Object)"EntityInsertPageForwarder could not redirect to about page.");
                }
            }
        }
    }
}

