/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.impl.RequiredFieldValidator;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionListener;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FauxPropertyRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog(FauxPropertyRetryController.class);

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        EditProcessObject epo = super.createEpo(req);
        EpoPopulator populator = new EpoPopulator(req, epo);
        populator.populate();
        req.setAttribute("colspan", (Object)"5");
        req.setAttribute("formJsp", (Object)"/templates/edit/specific/fauxProperty_retry.jsp");
        req.setAttribute("scripts", (Object)"/templates/edit/formBasic.js");
        req.setAttribute("title", (Object)"Faux Property Editing Form");
        req.setAttribute("_action", (Object)epo.getAction());
        AccessObjectType aot = populator.isFauxDataProperty() ? AccessObjectType.FAUX_DATA_PROPERTY : AccessObjectType.FAUX_OBJECT_PROPERTY;
        req.setAttribute("_faux_property_type", (Object)aot);
        FauxPropertyRetryController.addAccessAttributes(req, populator.beanForEditing.getConfigUri(), aot);
        FauxPropertyRetryController.addNotRelatedPropertySuppressions(req, populator.beanForEditing.getConfigUri(), aot);
        req.setAttribute("i18n", (Object)I18n.bundle(req));
        this.setRequestAttributes(req, epo);
        try {
            JSPPageHandler.renderBasicPage(req, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"Could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    private static class EpoPopulator {
        private static final String LITERAL = "http://www.w3.org/2000/01/rdf-schema#Literal";
        private static final String XML_LITERAL = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
        private final VitroRequest req;
        private final ServletContext ctx;
        private final WebappDaoFactory wadf;
        private final EditProcessObject epo;
        private final FauxPropertyDao fpDao;
        private FauxProperty beanForEditing;
        private Property baseProperty;
        private boolean isFauxDataProperty = false;
        private static final String VCARD_KIND_URI = "http://www.w3.org/2006/vcard/ns#Kind";
        private static final String VCARD_NAMESPACE = "http://www.w3.org/2006/vcard/ns#";

        public boolean isFauxDataProperty() {
            return this.isFauxDataProperty;
        }

        EpoPopulator(HttpServletRequest req, EditProcessObject epo) {
            this.req = new VitroRequest(req);
            this.ctx = req.getSession().getServletContext();
            this.wadf = ModelAccess.on(req).getWebappDaoFactory(ModelAccess.POLICY_NEUTRAL);
            this.epo = epo;
            this.fpDao = ModelAccess.on(req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]).getFauxPropertyDao();
        }

        void populate() {
            this.epo.setDataAccessObject(this.fpDao);
            this.epo.setAction(this.determineAction());
            this.epo.setImplementationClass(FauxProperty.class);
            this.epo.setBeanClass(FauxProperty.class);
            if (this.epo.getUseRecycledBean()) {
                this.beanForEditing = (FauxProperty)this.epo.getNewBean();
            } else {
                this.beanForEditing = this.locateBeanForEditing();
                this.epo.setOriginalBean(this.beanForEditing);
            }
            this.baseProperty = this.req.getUnfilteredWebappDaoFactory().getObjectPropertyDao().getObjectPropertyByURI(this.beanForEditing.getURI());
            if (this.baseProperty == null) {
                this.baseProperty = this.req.getUnfilteredWebappDaoFactory().getDataPropertyDao().getDataPropertyByURI(this.beanForEditing.getURI());
                this.isFauxDataProperty = true;
            }
            this.addCheckboxValuesToTheRequest();
            if (!this.isFauxDataProperty) {
                this.setFieldValidators();
            }
            this.setListeners();
            this.setForwarders();
            this.assembleFormObjectAndConnectToEpo();
        }

        private String determineAction() {
            return this.req.getParameter("create") == null ? "update" : "insert";
        }

        private FauxProperty locateBeanForEditing() {
            String baseUri = this.req.getParameter("baseUri");
            String rangeUri = this.req.getParameter("rangeUri");
            String domainUri = this.req.getParameter("domainUri");
            if (this.epo.getAction().equals("insert")) {
                return this.newFauxProperty(baseUri);
            }
            FauxProperty bean = this.fpDao.getFauxPropertyByUris(domainUri, baseUri, rangeUri);
            if (bean == null) {
                throw new IllegalArgumentException("FauxProperty does not exist for <" + domainUri + "> ==> <" + baseUri + "> ==> <" + rangeUri + ">");
            }
            return bean;
        }

        private FauxProperty newFauxProperty(String baseUri) {
            Property base;
            FauxProperty fp = new FauxProperty(null, baseUri, null);
            ObjectPropertyDao opDao = this.wadf.getObjectPropertyDao();
            DataPropertyDao dpDao = this.wadf.getDataPropertyDao();
            ObjectProperty objBase = opDao.getObjectPropertyByURI(baseUri);
            if (objBase != null) {
                fp.setSelectFromExisting(objBase.getSelectFromExisting());
                fp.setOfferCreateNewOption(objBase.getOfferCreateNewOption());
                base = objBase;
            } else {
                base = dpDao.getDataPropertyByURI(baseUri);
            }
            fp.setGroupURI(base.getGroupURI());
            fp.setRangeURI(base.getRangeVClassURI());
            fp.setDomainURI(base.getDomainVClassURI());
            fp.setCustomEntryForm(base.getCustomEntryForm());
            log.debug((Object)("Created new FauxProperty: " + fp));
            return fp;
        }

        private void addCheckboxValuesToTheRequest() {
            this.req.setAttribute("selectFromExisting", this.beanForEditing.isSelectFromExisting());
            this.req.setAttribute("offerCreateNewOption", this.beanForEditing.isOfferCreateNewOption());
            this.req.setAttribute("collateBySubclass", this.beanForEditing.isCollateBySubclass());
            if (this.beanForEditing.getURI() != null) {
                this.beanForEditing.setSelectFromExisting(false);
                this.beanForEditing.setOfferCreateNewOption(false);
                this.beanForEditing.setCollateBySubclass(false);
            }
        }

        private void setFieldValidators() {
            this.epo.getValidatorMap().put("RangeURI", Arrays.asList(new RequiredFieldValidator()));
        }

        private void setListeners() {
            this.epo.setChangeListenerList(Collections.singletonList(new PropertyRestrictionListener()));
        }

        private void setForwarders() {
        }

        private void assembleFormObjectAndConnectToEpo() {
            FormObject foo = new FormObject();
            foo.setErrorMap(this.epo.getErrMsgMap());
            foo.setOptionLists(new HashMap<String, List<Option>>(this.createOptionsMap()));
            this.epo.setFormObject(foo);
            FormUtils.populateFormFromBean(this.beanForEditing, this.epo.getAction(), foo, this.epo.getBadValueMap());
        }

        private Map<String, List<Option>> createOptionsMap() {
            HashMap<String, List<Option>> map = new HashMap<String, List<Option>>();
            map.put("GroupURI", this.createClassGroupOptionList());
            map.put("DomainURI", this.buildDomainOptionList());
            map.put("RangeURI", this.buildRangeOptionList());
            return map;
        }

        private List<Option> createClassGroupOptionList() {
            List<Option> groupOptList = this.getGroupOptList(this.beanForEditing.getGroupURI());
            groupOptList.sort(new OptionsBodyComparator(this.req.getCollator()));
            groupOptList.add(0, new Option("", "none"));
            return groupOptList;
        }

        private List<Option> getGroupOptList(String currentGroupURI) {
            List<PropertyGroup> groups = this.wadf.getPropertyGroupDao().getPublicGroups(true);
            if (currentGroupURI == null) {
                return FormUtils.makeOptionListFromBeans(groups, "URI", "Name", "", null, false);
            }
            return FormUtils.makeOptionListFromBeans(groups, "URI", "Name", currentGroupURI, null, true);
        }

        private List<Option> buildDomainOptionList() {
            ArrayList<Option> list = new ArrayList<Option>();
            if (this.baseProperty.getDomainVClassURI() == null) {
                list.addAll(FormUtils.makeVClassOptionList(this.wadf, this.beanForEditing.getDomainURI()));
            } else {
                list.addAll(FormUtils.makeOptionListOfNotDisjointClasses(this.wadf, this.baseProperty.getDomainVClassURI(), this.beanForEditing.getDomainURI()));
            }
            list.add(0, new Option("", "(none specified)"));
            return list;
        }

        private List<Option> buildRangeOptionList() {
            if (this.isFauxDataProperty) {
                return this.buildDataPropOptionList();
            }
            return this.buildObjectPropOptionList();
        }

        private List<Option> buildObjectPropOptionList() {
            ArrayList<Option> list = new ArrayList<Option>();
            if (this.baseProperty.getRangeVClassURI() == null) {
                list.addAll(FormUtils.makeVClassOptionList(this.wadf, this.beanForEditing.getRangeURI()));
            } else {
                list.addAll(FormUtils.makeOptionListOfNotDisjointClasses(this.wadf, this.baseProperty.getRangeVClassURI(), this.beanForEditing.getRangeURI()));
                if (this.containsVCardKind(list)) {
                    this.mergeInAllVCardClasses(list);
                }
            }
            list.add(0, new Option("", "(none specified)"));
            return list;
        }

        private List<Option> buildDataPropOptionList() {
            ArrayList<Option> list = new ArrayList<Option>();
            String rangeUri = this.baseProperty.getRangeVClassURI();
            if (rangeUri == null) {
                Option option = new Option();
                option.setValue("");
                option.setBody("Untyped");
                option.setSelected(true);
                list.add(option);
            } else if (rangeUri.equals(LITERAL)) {
                Option option = new Option();
                option.setValue(rangeUri);
                option.setBody("Literal");
                option.setSelected(true);
                list.add(option);
            } else if (rangeUri.equals(XML_LITERAL)) {
                Option option = new Option();
                option.setValue(rangeUri);
                option.setBody("XML Literal");
                option.setSelected(true);
                list.add(option);
            } else {
                Datatype dataType = this.wadf.getDatatypeDao().getDatatypeByURI(rangeUri);
                Option option = new Option();
                if (dataType != null) {
                    option.setValue(dataType.getUri());
                    option.setBody(dataType.getName());
                } else {
                    option.setValue(rangeUri);
                    option.setBody(rangeUri);
                }
                option.setSelected(true);
                list.add(option);
            }
            return list;
        }

        private boolean containsVCardKind(List<Option> list) {
            for (Option option : list) {
                if (!VCARD_KIND_URI.equals(option.getValue())) continue;
                return true;
            }
            return false;
        }

        private void mergeInAllVCardClasses(List<Option> list) {
            HashSet<String> existingUrls = new HashSet<String>();
            for (Option option : list) {
                existingUrls.add(option.getValue());
            }
            for (Option option : FormUtils.makeVClassOptionList(this.wadf, this.beanForEditing.getRangeURI())) {
                if (!option.getValue().startsWith(VCARD_NAMESPACE) || existingUrls.contains(option.getValue())) continue;
                list.add(option);
            }
            list.sort(new Comparator<Option>(){

                @Override
                public int compare(Option o1, Option o2) {
                    return o1.getBody().compareTo(o2.getBody());
                }
            });
        }

        private static class OptionsBodyComparator
        implements Comparator<Option> {
            private final Collator collator;

            public OptionsBodyComparator(Collator collator) {
                this.collator = collator;
            }

            @Override
            public int compare(Option o1, Option o2) {
                return this.collator.compare(o1.getBody(), o2.getBody());
            }
        }
    }
}

