/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualTypeRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)IndividualTypeRetryController.class.getName());

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.DO_BACK_END_EDITING.ACTION)) {
            return;
        }
        EditProcessObject epo = super.createEpo(request);
        VitroRequest vreq = new VitroRequest(request);
        WebappDaoFactory wadf = vreq.getUnfilteredAssertionsWebappDaoFactory();
        IndividualDao iDao = wadf.getIndividualDao();
        VClassDao vcDao = wadf.getVClassDao();
        String individualURI = request.getParameter("IndividualURI");
        Individual ind = iDao.getIndividualByURI(individualURI);
        if (ind == null) {
            ind = new IndividualImpl(individualURI);
        }
        request.setAttribute("individual", (Object)ind);
        List<VClass> allVClasses = vcDao.getAllVclasses();
        this.sortForPickList(allVClasses, vreq);
        HashSet<String> prohibitedURIset = new HashSet<String>();
        for (VClass vClass : ind.getVClasses(false)) {
            if (vClass.isAnonymous()) continue;
            prohibitedURIset.add(vClass.getURI());
            prohibitedURIset.addAll(vcDao.getDisjointWithClassURIs(vClass.getURI()));
        }
        ArrayList<VClass> eligibleVClasses = new ArrayList<VClass>();
        for (VClass vc : allVClasses) {
            if (vc.getURI() == null || prohibitedURIset.contains(vc.getURI())) continue;
            eligibleVClasses.add(vc);
        }
        FormObject formObject = new FormObject();
        epo.setFormObject(formObject);
        HashMap<String, List<Option>> optionMap = new HashMap<String, List<Option>>();
        formObject.setOptionLists(optionMap);
        ArrayList<Option> typeOptionList = new ArrayList<Option>();
        for (VClass vc : eligibleVClasses) {
            Option opt = new Option(vc.getURI(), vc.getPickListName());
            typeOptionList.add(opt);
        }
        optionMap.put("types", typeOptionList);
        request.setAttribute("editAction", (Object)"individualTypeOp");
        request.setAttribute("scripts", (Object)"/templates/edit/formBasic.js");
        request.setAttribute("formJsp", (Object)"/templates/edit/specific/individualType_retry.jsp");
        request.setAttribute("title", (Object)"Individual Type Editing Form");
        request.setAttribute("_action", (Object)"insert");
        this.setRequestAttributes(request, epo);
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not forward to view."));
            log.error((Object)e.getMessage());
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
    }
}

