/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="PropertyEditController", urlPatterns={"/propertyEdit"})
public class PropertyEditController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)PropertyEditController.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        Ontology ont;
        ObjectProperty parent;
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        int NUM_COLS = 23;
        VitroRequest vreq = new VitroRequest(request);
        ObjectPropertyDao propDao = vreq.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        ObjectPropertyDao propDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getObjectPropertyDao();
        VClassDao vcDao = vreq.getLanguageNeutralWebappDaoFactory().getVClassDao();
        VClassDao vcDaoWLang = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        PropertyGroupDao pgDao = vreq.getUnfilteredWebappDaoFactory().getPropertyGroupDao();
        ObjectProperty p = propDao.getObjectPropertyByURI(request.getParameter("uri"));
        ObjectProperty pLangNeut = propDaoLangNeut.getObjectPropertyByURI(request.getParameter("uri"));
        request.setAttribute("property", (Object)p);
        ArrayList<String> results = new ArrayList<String>();
        results.add("property");
        results.add("parent property");
        results.add("property group");
        results.add("ontology");
        results.add("RDF local name");
        results.add("public display label");
        results.add("domain class");
        results.add("range class");
        results.add("transitive");
        results.add("symmetric");
        results.add("functional");
        results.add("inverse functional");
        results.add("public description");
        results.add("example");
        results.add("editor description");
        results.add("display tier");
        results.add("display limit");
        results.add("collate by subclass");
        results.add("custom entry form");
        results.add("select from existing");
        results.add("offer create new");
        results.add("sort direction");
        results.add("URI");
        results.add(p.getPickListName());
        String parentPropertyStr = "";
        if (p.getParentURI() != null && (parent = propDao.getObjectPropertyByURI(p.getParentURI())) != null && parent.getURI() != null) {
            try {
                parentPropertyStr = "<a href=\"propertyEdit?uri=" + URLEncoder.encode(parent.getURI(), "UTF-8") + "\">" + parent.getPickListName() + "</a>";
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        results.add(parentPropertyStr);
        if (p.getGroupURI() != null) {
            PropertyGroup pGroup = pgDao.getGroupByURI(p.getGroupURI());
            if (pGroup != null) {
                results.add(pGroup.getName());
            } else {
                results.add("(unnamed group)");
            }
        } else {
            results.add("(unspecified)");
        }
        String ontologyName = null;
        if (p.getNamespace() != null && (ont = vreq.getUnfilteredWebappDaoFactory().getOntologyDao().getOntologyByURI(p.getNamespace())) != null && ont.getName() != null) {
            ontologyName = ont.getName();
        }
        results.add(ontologyName == null ? "(not identified)" : ontologyName);
        results.add(p.getLocalName());
        results.add(p.getDomainPublic() == null ? "(no public label)" : p.getDomainPublic());
        String domainStr = "";
        if (pLangNeut.getDomainVClassURI() != null) {
            VClass domainClass = vcDao.getVClassByURI(pLangNeut.getDomainVClassURI());
            VClass domainWLang = vcDaoWLang.getVClassByURI(pLangNeut.getDomainVClassURI());
            if (domainClass != null && domainClass.getURI() != null && domainClass.getPickListName() != null) {
                try {
                    domainStr = domainClass.isAnonymous() ? domainClass.getPickListName() : "<a href=\"vclassEdit?uri=" + URLEncoder.encode(domainClass.getURI(), "UTF-8") + "\">" + domainWLang.getPickListName() + "</a>";
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        results.add(domainStr);
        String rangeStr = "";
        if (pLangNeut.getRangeVClassURI() != null) {
            VClass rangeClass = vcDao.getVClassByURI(pLangNeut.getRangeVClassURI());
            VClass rangeWLang = vcDaoWLang.getVClassByURI(pLangNeut.getRangeVClassURI());
            if (rangeClass != null && rangeClass.getURI() != null && rangeClass.getPickListName() != null) {
                try {
                    rangeStr = rangeClass.isAnonymous() ? rangeClass.getPickListName() : "<a href=\"vclassEdit?uri=" + URLEncoder.encode(rangeClass.getURI(), "UTF-8") + "\">" + rangeWLang.getPickListName() + "</a>";
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        results.add(rangeStr);
        results.add(p.getTransitive() ? "true" : "false");
        results.add(p.getSymmetric() ? "true" : "false");
        results.add(p.getFunctional() ? "true" : "false");
        results.add(p.getInverseFunctional() ? "true" : "false");
        String publicDescriptionStr = p.getPublicDescription() == null ? "" : p.getPublicDescription();
        results.add(publicDescriptionStr);
        String exampleStr = p.getExample() == null ? "" : p.getExample();
        results.add(exampleStr);
        String descriptionStr = p.getDescription() == null ? "" : p.getDescription();
        results.add(descriptionStr);
        results.add("property: " + p.getDomainDisplayTier() + ", inverse: " + p.getRangeDisplayTier());
        results.add("property: " + p.getDomainDisplayLimitInteger() + ", inverse: " + p.getRangeDisplayLimit());
        results.add(p.getCollateBySubclass() ? "true" : "false");
        results.add(p.getCustomEntryForm() == null ? "(unspecified)" : p.getCustomEntryForm());
        results.add(p.getSelectFromExisting() ? "true" : "false");
        results.add(p.getOfferCreateNewOption() ? "true" : "false");
        results.add(p.getDomainEntitySortDirection() == null ? "ascending" : p.getDomainEntitySortDirection());
        results.add(p.getURI());
        request.setAttribute("results", results);
        request.setAttribute("columncount", (Object)23);
        request.setAttribute("suppressquery", (Object)"true");
        EditProcessObject epo = super.createEpo(request, true);
        FormObject foo = new FormObject();
        HashMap<String, List<Option>> OptionMap = new HashMap<String, List<Option>>();
        foo.setOptionLists(OptionMap);
        epo.setFormObject(foo);
        ObjectPropertyDao opDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getObjectPropertyDao();
        List<ObjectProperty> superProps = this.getObjectPropertiesForURIList(opDao.getSuperPropertyURIs(p.getURI(), false), opDao);
        this.sortForPickList(superProps, vreq);
        request.setAttribute("superproperties", superProps);
        List<ObjectProperty> subProps = this.getObjectPropertiesForURIList(opDao.getSubPropertyURIs(p.getURI()), opDao);
        this.sortForPickList(subProps, vreq);
        request.setAttribute("subproperties", subProps);
        List<ObjectProperty> eqProps = this.getObjectPropertiesForURIList(opDao.getEquivalentPropertyURIs(p.getURI()), opDao);
        this.sortForPickList(eqProps, vreq);
        request.setAttribute("equivalentProperties", eqProps);
        List<FauxProperty> fauxProps = vreq.getUnfilteredAssertionsWebappDaoFactory().getFauxPropertyDao().getFauxPropertiesForBaseUri(p.getURI());
        this.sortForPickList(fauxProps, vreq);
        request.setAttribute("fauxproperties", fauxProps);
        request.setAttribute("epoKey", (Object)epo.getKey());
        request.setAttribute("propertyWebapp", (Object)p);
        request.setAttribute("title", (Object)"Object Property Control Panel");
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + vreq.getAppBean().getThemeDir() + "css/edit.css\"/>"));
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/specific/props_edit.jsp");
        }
        catch (Exception e) {
            log.error((Object)"PropertyEditController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    private List<ObjectProperty> getObjectPropertiesForURIList(List<String> propertyURIs, ObjectPropertyDao opDao) {
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        for (String propertyURI : propertyURIs) {
            ObjectProperty property = opDao.getObjectPropertyByURI(propertyURI);
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }
}

