/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.BulkUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;

@WebServlet(name="DeleteIndividualController", urlPatterns={"/deleteIndividualController"})
public class DeleteIndividualController
extends FreemarkerHttpServlet {
    private static final String INDIVIDUAL_URI = "individualUri";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DeleteIndividualController.class);
    private static final boolean BEGIN = true;
    private static final boolean END = false;
    private static String queryForDeleteQuery = "SELECT ?deleteQueryText WHERE { ?associatedUri <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasDeleteQuery> ?deleteQueryText .}";
    private static final String DEFAULT_DELETE_QUERY_TEXT = "CONSTRUCT { ?individualUri ?p1 ?o1 . ?s2 ?p2 ?individualUri . } WHERE {  { ?individualUri ?p1 ?o1 . } UNION { ?s2 ?p2 ?individualUri. } }";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        OntModel displayModel;
        List<String> types;
        String deleteQueryText;
        String errorMessage = this.handleErrors(vreq);
        if (!errorMessage.isEmpty()) {
            return this.prepareErrorMessage(errorMessage);
        }
        String individualUri = vreq.getParameter(INDIVIDUAL_URI);
        Model toRemove = this.getIndividualsToDelete(individualUri, deleteQueryText = DeleteIndividualController.getDeleteQueryForTypes(types = this.getObjectMostSpecificTypes(individualUri, vreq), (Model)(displayModel = vreq.getDisplayModel())), vreq);
        if (toRemove.size() > 0L) {
            this.deleteIndividuals(toRemove, vreq);
        }
        String redirectUrl = this.getRedirectUrl(vreq);
        return new RedirectResponseValues(redirectUrl, 303);
    }

    private String getRedirectUrl(VitroRequest vreq) {
        String redirectUrl = vreq.getParameter("redirectUrl");
        if (redirectUrl != null) {
            return redirectUrl;
        }
        return "/";
    }

    private TemplateResponseValues prepareErrorMessage(String errorMessage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMessage", errorMessage);
        return new TemplateResponseValues("error-message.ftl", map);
    }

    private String handleErrors(VitroRequest vreq) {
        String uri = vreq.getParameter(INDIVIDUAL_URI);
        if (uri == null) {
            return "Individual uri is null. No object to delete.";
        }
        if (uri.contains("<") || uri.contains(">")) {
            return "Individual IRI shouldn't contain '<' or '>";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDeleteQueryForTypes(List<String> types, Model displayModel) {
        String deleteQueryText = DEFAULT_DELETE_QUERY_TEXT;
        String foundType = "";
        for (String type : types) {
            Query queryForTypeSpecificDeleteQuery = QueryFactory.create((String)queryForDeleteQuery);
            QuerySolutionMap initialBindings = new QuerySolutionMap();
            initialBindings.add("associatedURI", (RDFNode)ResourceFactory.createResource((String)type));
            displayModel.enterCriticalSection(true);
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)queryForTypeSpecificDeleteQuery, (Model)displayModel, (QuerySolution)initialBindings);){
                ResultSet results = qexec.execSelect();
                if (results.hasNext()) {
                    QuerySolution solution = results.nextSolution();
                    deleteQueryText = solution.get("deleteQueryText").toString();
                    foundType = type;
                }
            }
            finally {
                displayModel.leaveCriticalSection();
            }
            if (foundType.isEmpty()) continue;
            break;
        }
        if (!foundType.isEmpty()) {
            log.debug((Object)("For " + foundType + " found delete query \n" + deleteQueryText));
            if (!deleteQueryText.contains(INDIVIDUAL_URI)) {
                log.error((Object)"Safety check failed. Delete query text should contain individualUri, but it didn't. To prevent bad consequences query was rejected.");
                log.error((Object)("Delete query which caused the error: \n" + deleteQueryText));
                deleteQueryText = DEFAULT_DELETE_QUERY_TEXT;
            }
        } else {
            log.debug((Object)("For most specific types: " + types.stream().collect(Collectors.joining(",")) + " no delete query was found. Using default query \n" + deleteQueryText));
        }
        return deleteQueryText;
    }

    private List<String> getObjectMostSpecificTypes(String individualUri, VitroRequest vreq) {
        LinkedList<String> types = new LinkedList();
        Individual individual = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(individualUri);
        if (individual != null) {
            types = individual.getMostSpecificTypeURIs();
        }
        if (types.isEmpty()) {
            log.error((Object)("Failed to get most specific type for individual Uri " + individualUri));
        }
        return types;
    }

    private Model getIndividualsToDelete(String targetIndividual, String deleteQuery, VitroRequest vreq) {
        try {
            Query queryForTypeSpecificDeleteQuery = QueryFactory.create((String)deleteQuery);
            QuerySolutionMap bindings = new QuerySolutionMap();
            bindings.add(INDIVIDUAL_URI, (RDFNode)ResourceFactory.createResource((String)targetIndividual));
            OntModel ontModel = ModelAccess.on((HttpServletRequest)vreq).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]).getABoxModel();
            QueryExecution qexec = QueryExecutionFactory.create((Query)queryForTypeSpecificDeleteQuery, (Model)ontModel, (QuerySolution)bindings);
            Model results = qexec.execConstruct();
            return results;
        }
        catch (Exception e) {
            log.error((Object)("Query raised an error \n" + deleteQuery));
            log.error((Object)e, (Throwable)e);
            return ModelFactory.createDefaultModel();
        }
    }

    private void deleteIndividuals(Model model, VitroRequest vreq) {
        RDFService rdfService = vreq.getRDFService();
        ChangeSet cs = this.makeChangeSet(rdfService);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            model.write((OutputStream)out, "N3");
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            cs.addRemoval(in, RDFServiceUtils.getSerializationFormatFromJenaString("N3"), "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", N3EditUtils.getEditorUri((HttpServletRequest)vreq));
            rdfService.changeSetUpdate(cs);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            model.write((Writer)sw, "N3");
            log.error((Object)("Got " + e.getClass().getSimpleName() + " while removing\n" + sw.toString()));
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private ChangeSet makeChangeSet(RDFService rdfService) {
        ChangeSet cs = rdfService.manufactureChangeSet();
        cs.addPreChangeEvent(new BulkUpdateEvent(null, true));
        cs.addPostChangeEvent(new BulkUpdateEvent(null, false));
        return cs;
    }
}

