/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.jena;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.BlankNodeFilteringModelMaker;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaIngestUtils;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaIngestWorkflowProcessor;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaOutputUtils;
import edu.cornell.mannlib.vitro.webapp.utils.jena.WorkflowOntology;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SparqlQueryUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.CannotEncodeCharacterException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;

@WebServlet(name="JenaIngestController", urlPatterns={"/ingest"})
public class JenaIngestController
extends BaseEditController {
    private static final Log log = LogFactory.getLog(JenaIngestController.class);
    private static final String INGEST_MENU_JSP = "/jenaIngest/ingestMenu.jsp";
    private static final String LIST_MODELS_JSP = "/jenaIngest/listModels.jsp";
    private static final String CREATE_MODEL_JSP = "/jenaIngest/createModel.jsp";
    private static final String LOAD_RDF_DATA_JSP = "/jenaIngest/loadRDFData.jsp";
    private static final String EXECUTE_SPARQL_JSP = "/jenaIngest/sparqlConstruct.jsp";
    private static final String RENAME_BNODES_JSP = "/jenaIngest/renameBNodes.jsp";
    private static final String RENAME_BNODES_URI_SELECT_JSP = "/jenaIngest/renameBNodesURISelect.jsp";
    private static final String SMUSH_JSP = "/jenaIngest/smushSingleModel.jsp";
    private static final String CSV2RDF_JSP = "/jenaIngest/csv2rdf.jsp";
    private static final String PROCESS_STRINGS_JSP = "/jenaIngest/processStrings.jsp";
    private static final String SUBTRACT_MODELS_JSP = "/jenaIngest/subtractModels.jsp";
    private static final String SPLIT_PROPERTY_VALUES_JSP = "/jenaIngest/splitPropertyValues.jsp";
    private static final String EXECUTE_WORKFLOW_JSP = "/jenaIngest/executeWorkflow.jsp";
    private static final String WORKFLOW_STEP_JSP = "/jenaIngest/workflowStep.jsp";
    private static final String GENERATE_TBOX_JSP = "/jenaIngest/generateTBox.jsp";
    private static final String PERMANENT_URI = "/jenaIngest/permanentURI.jsp";
    private static final String MERGE_RESOURCES = "/jenaIngest/mergeResources.jsp";
    private static final String MERGE_RESULT = "/jenaIngest/merge_result.jsp";
    private static final String SPARQL_CONSTRUCT_CLASS = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7/sparql#SPARQLCONSTRUCTQuery";
    private static final String SPARQL_QUERYSTR_PROP = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7/sparql#queryStr";
    private static final String RENAME_RESOURCE = "/jenaIngest/renameResource.jsp";
    private static final String RENAME_RESULT = "/jenaIngest/renameResult.jsp";
    private static final String CREATED_GRAPH_BASE_URI = "http://vitro.mannlib.cornell.edu/a/graph/";
    private static final String WHICH_MODEL_MAKER = "jenaIngestModelMakerID";
    private static final Map<String, Model> attachedModels = new HashMap<String, Model>();

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String bodyJsp;
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        ModelMaker maker = JenaIngestController.getModelMaker((HttpServletRequest)vreq);
        ModelAccess.WhichService modelType = this.getModelType(vreq);
        String actionStr = vreq.getParameter("action");
        String string = actionStr = actionStr != null ? actionStr : "";
        if ("listModels".equals(actionStr)) {
            bodyJsp = this.processListModelsRequest(vreq, maker, modelType);
        } else if ("configModels".equals(actionStr)) {
            bodyJsp = this.processConfigModelsRequest(vreq);
        } else if ("contentModels".equals(actionStr)) {
            bodyJsp = this.processContentModelsRequest(vreq);
        } else if ("createModel".equals(actionStr)) {
            bodyJsp = this.processCreateModelRequest(vreq, maker, modelType);
        } else if ("removeModel".equals(actionStr)) {
            bodyJsp = this.processRemoveModelRequest(vreq, maker, modelType);
        } else if ("loadRDFData".equals(actionStr)) {
            bodyJsp = this.processLoadRDFDataRequest(vreq, maker);
        } else if ("cleanLiterals".equals(actionStr)) {
            bodyJsp = this.processCleanLiteralsRequest(vreq);
        } else {
            if ("outputModel".equals(actionStr)) {
                this.processOutputModelRequest(vreq, response);
                return;
            }
            if ("clearModel".equals(actionStr)) {
                bodyJsp = this.processClearModelRequest(vreq, maker, modelType);
            } else if ("attachModel".equals(actionStr)) {
                bodyJsp = this.processAttachModelRequest(vreq, maker, modelType);
            } else if ("detachModel".equals(actionStr)) {
                bodyJsp = this.processDetachModelRequest(vreq, maker, modelType);
            } else if ("renameBNodes".equals(actionStr)) {
                bodyJsp = this.processRenameBNodesRequest(vreq, maker);
            } else if ("renameBNodesURISelect".equals(actionStr)) {
                bodyJsp = this.processRenameBNodesURISelectRequest(vreq, maker);
            } else if ("smushSingleModel".equals(actionStr)) {
                bodyJsp = this.processSmushSingleModelRequest(vreq);
            } else if ("csv2rdf".equals(actionStr)) {
                bodyJsp = this.processCsv2rdfRequest(vreq);
            } else if ("processStrings".equals(actionStr)) {
                bodyJsp = this.processProcessStringsRequest(vreq);
            } else if ("splitPropertyValues".equals(actionStr)) {
                bodyJsp = this.processSplitPropertyValuesRequest(vreq);
            } else if ("subtractModels".equals(actionStr)) {
                bodyJsp = this.processSubtractModelRequest(vreq);
            } else if ("executeWorkflow".equals(actionStr)) {
                bodyJsp = this.processExecuteWorkflowRequest(vreq);
            } else if ("executeSparql".equals(actionStr)) {
                bodyJsp = this.processExecuteSparqlRequest(vreq);
            } else if ("generateTBox".equals(actionStr)) {
                bodyJsp = this.processGenerateTBoxRequest(vreq);
            } else if ("permanentURI".equals(actionStr)) {
                bodyJsp = this.processPermanentURIRequest(vreq, maker);
            } else if ("mergeResources".equals(actionStr)) {
                bodyJsp = this.processMergeResourceRequest(vreq);
            } else if ("renameResource".equals(actionStr)) {
                bodyJsp = this.processRenameResourceRequest(vreq);
            } else {
                if ("mergeResult".equals(actionStr)) {
                    this.processMergeResultRequest(vreq, response);
                    return;
                }
                if ("dumpRestore".equals(actionStr)) {
                    this.processDumpRestore(vreq, response);
                    return;
                }
                request.setAttribute("title", (Object)"Ingest Menu");
                bodyJsp = INGEST_MENU_JSP;
            }
        }
        maker = JenaIngestController.getModelMaker((HttpServletRequest)vreq);
        List modelNames = maker.listModels().toList();
        for (int mnIdx = modelNames.size() - 1; mnIdx > -1; --mnIdx) {
            if (((String)modelNames.get(mnIdx)).startsWith("http")) continue;
            modelNames.remove(mnIdx);
        }
        request.setAttribute("modelNames", (Object)modelNames);
        try {
            JSPPageHandler.renderBasicPage(request, response, bodyJsp);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private String processListModelsRequest(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        return this.showModelList(vreq, maker, modelType);
    }

    protected static boolean isUsingMainStoreForIngest(HttpServletRequest req) {
        return ModelAccess.WhichService.CONFIGURATION != req.getSession().getAttribute(WHICH_MODEL_MAKER);
    }

    private String processConfigModelsRequest(VitroRequest vreq) {
        ModelMaker vjmm = ModelAccess.on(this.getServletContext()).getModelMaker(ModelAccess.WhichService.CONFIGURATION);
        vreq.getSession().setAttribute(WHICH_MODEL_MAKER, (Object)ModelAccess.WhichService.CONFIGURATION);
        return this.showModelList(vreq, vjmm, ModelAccess.WhichService.CONFIGURATION);
    }

    private String processContentModelsRequest(VitroRequest vreq) {
        ModelMaker vsmm = ModelAccess.on(this.getServletContext()).getModelMaker(ModelAccess.WhichService.CONTENT);
        vreq.getSession().setAttribute(WHICH_MODEL_MAKER, (Object)ModelAccess.WhichService.CONTENT);
        return this.showModelList(vreq, vsmm, ModelAccess.WhichService.CONTENT);
    }

    private String processCreateModelRequest(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        String modelName = vreq.getParameter("modelName");
        if (modelName != null) {
            try {
                URI graphURI = new URI(modelName);
                if (graphURI.getScheme() == null) {
                    String origName = modelName;
                    modelName = CREATED_GRAPH_BASE_URI + modelName;
                    log.info((Object)("The model name has been changed from " + origName + " to " + modelName));
                }
                this.doCreateModel(modelName, maker);
                return this.showModelList(vreq, maker, modelType);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("the model name must be a valid URI");
            }
        }
        vreq.setAttribute("modelType", modelType.toString());
        vreq.setAttribute("title", "Create New Model");
        return CREATE_MODEL_JSP;
    }

    private String processRemoveModelRequest(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        String modelName = vreq.getParameter("modelName");
        if (modelName != null) {
            this.doRemoveModel(modelName, maker);
        }
        return this.showModelList(vreq, maker, modelType);
    }

    private String processClearModelRequest(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        String modelName = vreq.getParameter("modelName");
        if (modelName != null) {
            this.doClearModel(modelName, maker);
        }
        return this.showModelList(vreq, maker, modelType);
    }

    private String processLoadRDFDataRequest(VitroRequest vreq, ModelMaker maker) {
        String language;
        String docLoc = vreq.getParameter("docLoc");
        String filePath = vreq.getParameter("filePath");
        String modelName = vreq.getParameter("modelName");
        String languageParam = null;
        languageParam = vreq.getParameter("language");
        String string = language = languageParam != null ? languageParam : "RDF/XML";
        if (docLoc != null && modelName != null) {
            this.doLoadRDFData(modelName, docLoc, filePath, language, maker);
            vreq.setAttribute("title", "Ingest Menu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Load RDF Data");
        return LOAD_RDF_DATA_JSP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutputModelRequest(VitroRequest vreq, HttpServletResponse response) {
        String modelNameStr = vreq.getParameter("modelName");
        DateTimeFormatter timeStampPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss");
        String fileName = FilenameUtils.getName((String)modelNameStr) + "-" + timeStampPattern.format(LocalDateTime.now());
        Model model = JenaIngestController.getModel(modelNameStr, (HttpServletRequest)vreq);
        JenaOutputUtils.setNameSpacePrefixes(model, vreq.getWebappDaoFactory());
        model.enterCriticalSection(true);
        try {
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/x-turtle");
            response.setHeader("Content-Transfer-Encoding", "binary");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".ttl");
            model.write((OutputStream)out, "TTL");
            out.flush();
            out.close();
        }
        catch (CannotEncodeCharacterException cece) {
            byte[] badCharBytes = String.valueOf(cece.getBadChar()).getBytes();
            StringBuilder errorMsg = new StringBuilder("Cannot encode character with byte values: (decimal) ");
            for (byte badCharByte : badCharBytes) {
                errorMsg.append(badCharByte);
            }
            throw new RuntimeException(errorMsg.toString(), cece);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private String processCleanLiteralsRequest(VitroRequest vreq) {
        String modelNameStr = vreq.getParameter("modelName");
        Model model = JenaIngestController.getModel(modelNameStr, (HttpServletRequest)vreq);
        this.doCleanLiterals(model);
        vreq.setAttribute("title", "Ingest Menu");
        return INGEST_MENU_JSP;
    }

    private String processAttachModelRequest(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        String modelName = vreq.getParameter("modelName");
        if (modelName != null) {
            this.doAttachModel(modelName, maker);
        }
        return this.showModelList(vreq, maker, modelType);
    }

    private String processDetachModelRequest(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        String modelName = vreq.getParameter("modelName");
        if (modelName != null) {
            this.doDetachModel(modelName);
        }
        return this.showModelList(vreq, maker, modelType);
    }

    private String processRenameBNodesRequest(VitroRequest vreq, ModelMaker maker) {
        String[] sourceModel = vreq.getParameterValues("sourceModelName");
        JenaIngestUtils utils = new JenaIngestUtils();
        if (sourceModel != null && sourceModel.length != 0) {
            ArrayList<Model> sourceModelList = new ArrayList<Model>();
            for (String aSourceModel : sourceModel) {
                Model m = maker.getModel(aSourceModel);
                if (m == null) continue;
                sourceModelList.add(m);
            }
            Map<String, LinkedList<String>> propertyMap = utils.generatePropertyMap(sourceModelList, maker);
            List<String> sourceModelNameList = Arrays.asList(sourceModel);
            vreq.setAttribute("sourceModel", sourceModelNameList);
            vreq.setAttribute("propertyMap", propertyMap);
            vreq.setAttribute("enablePropertyPatternURIs", !propertyMap.isEmpty());
            vreq.setAttribute("title", "URI Select");
            return RENAME_BNODES_URI_SELECT_JSP;
        }
        vreq.setAttribute("title", "Rename Blank Nodes");
        return RENAME_BNODES_JSP;
    }

    private String processRenameBNodesURISelectRequest(VitroRequest vreq, ModelMaker maker) {
        String namespaceEtcStr = vreq.getParameter("namespaceEtcStr");
        String pattern = vreq.getParameter("pattern");
        String concatenate = vreq.getParameter("concatenate");
        String[] sourceModel = vreq.getParameterValues("sourceModelName");
        if (namespaceEtcStr != null) {
            if (namespaceEtcStr.isEmpty()) {
                if ("true".equals(vreq.getParameter("csv2rdf"))) {
                    return this.processCsv2rdfRequest(vreq);
                }
                vreq.setAttribute("errorMsg", "Please enter a value.");
                return this.processRenameBNodesRequest(vreq, maker);
            }
            if (concatenate.equals("integer")) {
                this.doRenameBNodes(vreq, namespaceEtcStr, false, null, sourceModel);
            } else {
                pattern = pattern.trim();
                this.doRenameBNodes(vreq, namespaceEtcStr, true, pattern, sourceModel);
            }
            vreq.setAttribute("title", "Ingest Menu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "URI Select");
        return RENAME_BNODES_URI_SELECT_JSP;
    }

    private String processSmushSingleModelRequest(VitroRequest vreq) {
        String propertyURIStr = vreq.getParameter("propertyURI");
        if (propertyURIStr != null) {
            this.doSmushSingleModel(vreq);
            vreq.setAttribute("title", "Ingest Menu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Smush Resources");
        return SMUSH_JSP;
    }

    private String processCsv2rdfRequest(VitroRequest vreq) {
        String csvUrl = vreq.getParameter("csvUrl");
        if (csvUrl != null) {
            vreq.setAttribute("title", "IngestMenu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Convert CSV to RDF");
        return CSV2RDF_JSP;
    }

    private String processProcessStringsRequest(VitroRequest vreq) {
        String className = vreq.getParameter("className");
        if (className != null) {
            this.doProcessStrings(vreq);
            vreq.setAttribute("title", "IngestMenu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Process Strings");
        return PROCESS_STRINGS_JSP;
    }

    private String processSplitPropertyValuesRequest(VitroRequest vreq) {
        String splitRegex = vreq.getParameter("splitRegex");
        if (splitRegex != null) {
            this.doSplitPropertyValues(vreq);
            vreq.setAttribute("title", "IngestMenu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Split PropertyValues");
        return SPLIT_PROPERTY_VALUES_JSP;
    }

    private String processSubtractModelRequest(VitroRequest vreq) {
        String modela = vreq.getParameter("modela");
        if (modela != null) {
            this.doSubtractModels(vreq);
            vreq.setAttribute("title", "IngestMenu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Subtract Models");
        return SUBTRACT_MODELS_JSP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processExecuteWorkflowRequest(VitroRequest vreq) {
        String workflowURIStr = vreq.getParameter("workflowURI");
        String workflowStepURIStr = vreq.getParameter("workflowStepURI");
        if (workflowURIStr != null && workflowStepURIStr != null) {
            this.doExecuteWorkflow(vreq);
            vreq.setAttribute("title", "IngestMenu");
            return INGEST_MENU_JSP;
        }
        if (workflowURIStr != null) {
            OntModel jenaOntModel = (OntModel)JenaIngestController.getModel("vitro:jenaOntModel", (HttpServletRequest)vreq);
            vreq.setAttribute("workflowSteps", new JenaIngestWorkflowProcessor(jenaOntModel.getIndividual(workflowURIStr), JenaIngestController.getModelMaker((HttpServletRequest)vreq)).getWorkflowSteps(null));
            vreq.setAttribute("title", "Choose Workflow Step");
            return WORKFLOW_STEP_JSP;
        }
        OntModel jenaOntModel = ModelAccess.on(this.getServletContext()).getOntModel();
        jenaOntModel.enterCriticalSection(true);
        LinkedList savedQueryList = new LinkedList();
        try {
            OntClass workflowClassRes = WorkflowOntology.Workflow;
            savedQueryList.addAll(jenaOntModel.listIndividuals((Resource)workflowClassRes).toList());
        }
        finally {
            jenaOntModel.leaveCriticalSection();
        }
        vreq.setAttribute("workflows", savedQueryList);
        vreq.setAttribute("title", "Execute Workflow");
        return EXECUTE_WORKFLOW_JSP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processExecuteSparqlRequest(VitroRequest vreq) {
        String sparqlQueryStr = vreq.getParameter("sparqlQueryStr");
        OntModel jenaOntModel = ModelAccess.on(this.getServletContext()).getOntModel();
        jenaOntModel.enterCriticalSection(true);
        LinkedList savedQueryList = new LinkedList();
        try {
            Resource sparqlConstructClassRes = ResourceFactory.createResource((String)SPARQL_CONSTRUCT_CLASS);
            savedQueryList.addAll(jenaOntModel.listIndividuals(sparqlConstructClassRes).toList());
        }
        finally {
            jenaOntModel.leaveCriticalSection();
        }
        OntologyDao daoObj = vreq.getUnfilteredWebappDaoFactory().getOntologyDao();
        List<Ontology> ontologiesObj = daoObj.getAllOntologies();
        ArrayList<String> prefixList = new ArrayList<String>();
        if (ontologiesObj != null && ontologiesObj.size() > 0) {
            for (Ontology ont : ontologiesObj) {
                prefixList.add(ont.getPrefix() == null ? "(not yet specified)" : ont.getPrefix());
                prefixList.add(ont.getURI() == null ? "" : ont.getURI());
            }
        } else {
            prefixList.add("<strong>No Ontologies added</strong>");
            prefixList.add("<strong>Load Ontologies</strong>");
        }
        vreq.setAttribute("prefixList", prefixList);
        if (sparqlQueryStr != null) {
            String validationMessage = "";
            if (vreq.getParameterValues("sourceModelName") == null) {
                validationMessage = validationMessage + "<p>Please select one or more source models.</p>";
            }
            if (vreq.getParameter("destinationModelName") == null) {
                validationMessage = validationMessage + "<p>Please select a destination model</p>";
            }
            if (validationMessage.length() > 0) {
                vreq.setAttribute("validationMessage", validationMessage);
            } else {
                long constructedStmtCount = 0L;
                try {
                    constructedStmtCount = this.doExecuteSparql(vreq);
                }
                catch (QueryParseException qpe) {
                    String errorMsg = "<p>Unable to parse query:</p>";
                    if (qpe.getMessage() != null) {
                        errorMsg = errorMsg + "<p>" + qpe.getMessage() + "</p>";
                    }
                    vreq.setAttribute("errorMsg", errorMsg);
                }
                catch (InconsistentOntologyException ioe) {
                    String errorMsg = "<p>Inconsistent source ontology:</p>";
                    if (ioe.getMessage() != null) {
                        errorMsg = errorMsg + "<p>" + ioe.getMessage() + "</p>";
                    }
                    vreq.setAttribute("errorMsg", errorMsg);
                }
                vreq.setAttribute("constructedStmtCount", constructedStmtCount);
            }
            vreq.setAttribute("savedQueries", savedQueryList);
            vreq.setAttribute("title", "SPARQL CONSTRUCT result");
            return EXECUTE_SPARQL_JSP;
        }
        vreq.setAttribute("savedQueries", savedQueryList);
        vreq.setAttribute("title", "Execute SPARQL Construct");
        return EXECUTE_SPARQL_JSP;
    }

    private String processGenerateTBoxRequest(VitroRequest vreq) {
        String testParam = vreq.getParameter("sourceModelName");
        if (testParam != null) {
            this.doGenerateTBox(vreq);
            vreq.setAttribute("title", "Ingest Menu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Generate TBox from Assertions Data");
        return GENERATE_TBOX_JSP;
    }

    private String processPermanentURIRequest(VitroRequest vreq, ModelMaker maker) {
        String modelName = vreq.getParameter("modelName");
        String oldModel = vreq.getParameter("oldModel");
        String newModel = vreq.getParameter("newModel");
        String oldNamespace = vreq.getParameter("oldNamespace");
        String newNamespace = vreq.getParameter("newNamespace");
        String dNamespace = vreq.getParameter("defaultNamespace");
        newNamespace = newNamespace == null || newNamespace.isEmpty() ? oldNamespace : newNamespace;
        String string = newNamespace = dNamespace != null ? dNamespace : newNamespace;
        if (modelName != null) {
            Model m = maker.getModel(modelName);
            ArrayList<String> namespaceList = new ArrayList<String>();
            ResIterator resItr = m.listResourcesWithProperty((Property)null);
            if (resItr != null) {
                while (resItr.hasNext()) {
                    String namespace = resItr.nextResource().getNameSpace();
                    if (namespaceList.contains(namespace)) continue;
                    namespaceList.add(namespace);
                }
            } else {
                namespaceList.add("no resources present");
            }
            String defaultNamespace = vreq.getUnfilteredWebappDaoFactory().getDefaultNamespace();
            vreq.setAttribute("modelName", modelName);
            vreq.setAttribute("defaultNamespace", defaultNamespace);
            vreq.setAttribute("namespaceList", namespaceList);
            vreq.setAttribute("title", "Permanent URI");
            return PERMANENT_URI;
        }
        if (oldModel != null) {
            JenaIngestUtils utils = new JenaIngestUtils();
            utils.doPermanentURI(oldModel, newModel, oldNamespace, newNamespace, maker, vreq);
            vreq.setAttribute("title", "Ingest Menu");
            return INGEST_MENU_JSP;
        }
        vreq.setAttribute("title", "Ingest Menu");
        return INGEST_MENU_JSP;
    }

    private String processMergeResourceRequest(VitroRequest vreq) {
        boolean usePrimaryLabelOnly;
        String uri1 = vreq.getParameter("uri1");
        String uri2 = vreq.getParameter("uri2");
        String usePrimaryLabelOnlyStr = vreq.getParameter("usePrimaryLabelOnly");
        boolean bl = usePrimaryLabelOnly = usePrimaryLabelOnlyStr != null && !usePrimaryLabelOnlyStr.isEmpty();
        if (uri1 != null) {
            JenaIngestUtils utils = new JenaIngestUtils();
            OntModel baseOntModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
            OntModel tboxOntModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:tboxOntModel");
            JenaIngestUtils.MergeResult result = utils.doMerge(uri1, uri2, baseOntModel, tboxOntModel, usePrimaryLabelOnly);
            vreq.getSession().setAttribute("leftoverModel", (Object)result.getLeftoverModel());
            vreq.setAttribute("result", result);
            vreq.setAttribute("title", "Merge Resources");
            return MERGE_RESULT;
        }
        vreq.setAttribute("title", "Merge Resources");
        return MERGE_RESOURCES;
    }

    private String processRenameResourceRequest(VitroRequest vreq) {
        String oldNamespace = vreq.getParameter("oldNamespace");
        String newNamespace = vreq.getParameter("newNamespace");
        String errorMsg = "";
        if (oldNamespace != null) {
            if (oldNamespace.isEmpty() && !newNamespace.isEmpty()) {
                errorMsg = "Please enter the old namespace to be changed.";
            } else if (!oldNamespace.isEmpty() && newNamespace.isEmpty()) {
                errorMsg = "Please enter the new namespace.";
            } else if (oldNamespace.isEmpty() && newNamespace.isEmpty()) {
                errorMsg = "Please enter the namespaces.";
            } else if (oldNamespace.equals(newNamespace)) {
                errorMsg = "Please enter two different namespaces.";
            }
            if (!errorMsg.isEmpty()) {
                vreq.setAttribute("errorMsg", errorMsg);
                vreq.setAttribute("oldNamespace", oldNamespace);
                vreq.setAttribute("newNamespace", newNamespace);
                vreq.setAttribute("title", "Rename Resource");
                return RENAME_RESOURCE;
            }
            String result = this.doRename(oldNamespace, newNamespace, N3EditUtils.getEditorUri((HttpServletRequest)vreq));
            vreq.setAttribute("result", result);
            vreq.setAttribute("title", "Rename Resources");
            return RENAME_RESULT;
        }
        vreq.setAttribute("title", "Rename Resource");
        return RENAME_RESOURCE;
    }

    private void processMergeResultRequest(VitroRequest vreq, HttpServletResponse response) {
        Model lmodel = (Model)vreq.getSession().getAttribute("leftoverModel");
        response.setContentType("RDF/XML-ABBREV");
        try {
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
            lmodel.write((OutputStream)outStream, "RDF/XML-ABBREV");
            outStream.flush();
            outStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected ModelAccess.WhichService getModelType(VitroRequest vreq) {
        String modelType = vreq.getParameter("modelType");
        if (modelType != null) {
            if (modelType.equals(ModelAccess.WhichService.CONFIGURATION.toString())) {
                return ModelAccess.WhichService.CONFIGURATION;
            }
            return ModelAccess.WhichService.CONTENT;
        }
        if (vreq.getSession().getAttribute(WHICH_MODEL_MAKER) == ModelAccess.WhichService.CONFIGURATION) {
            return ModelAccess.WhichService.CONFIGURATION;
        }
        return ModelAccess.WhichService.CONTENT;
    }

    private void doCreateModel(String modelName, ModelMaker modelMaker) {
        modelMaker.createModel(modelName);
    }

    private void doRemoveModel(String modelName, ModelMaker modelMaker) {
        this.doDetachModel(modelName);
        log.debug((Object)("Removing " + modelName + " from webapp"));
        modelMaker.removeModel(modelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearModel(String modelName, ModelMaker modelMaker) {
        Model m = modelMaker.getModel(modelName);
        OntModel o = VitroModelFactory.createOntologyModel(m);
        o.enterCriticalSection(false);
        try {
            o.removeAll();
        }
        finally {
            o.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadRDFData(String modelName, String docLoc, String filePath, String language, ModelMaker modelMaker) {
        Model m = modelMaker.getModel(modelName);
        m.enterCriticalSection(false);
        try {
            if (docLoc != null && docLoc.length() > 0) {
                m.read(docLoc, language);
            } else if (filePath != null && filePath.length() > 0) {
                File file = new File(filePath);
                File[] files = file.isDirectory() ? file.listFiles() : new File[]{file};
                for (File currentFile : files) {
                    log.info((Object)("Reading file " + currentFile.getName()));
                    try {
                        FileInputStream fis = new FileInputStream(currentFile);
                        m.read((InputStream)fis, null, language);
                        fis.close();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
        finally {
            m.leaveCriticalSection();
        }
    }

    private void doAttachModel(String modelName, ModelMaker modelMaker) {
        if (attachedModels.containsKey(modelName)) {
            this.doDetachModel(modelName);
        }
        Model m = ModelFactory.createDefaultModel();
        m.add(modelMaker.getModel(modelName));
        ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox").addSubModel(m);
        attachedModels.put(modelName, m);
        log.info((Object)("Attached " + modelName + " (" + m.hashCode() + ") to webapp"));
    }

    private void doDetachModel(String modelName) {
        Model m = attachedModels.get(modelName);
        if (m == null) {
            return;
        }
        ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox").removeSubModel(m);
        attachedModels.remove(modelName);
        log.info((Object)("Detached " + modelName + " (" + m.hashCode() + ") from webapp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRenameBNodes(VitroRequest vreq, String namespaceEtc, boolean patternBoolean, String pattern, String[] sourceModel) {
        OntModel source = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        String property = vreq.getParameter("property");
        Boolean csv2rdf = false;
        try {
            csv2rdf = Boolean.parseBoolean(vreq.getParameter("csv2rdf"));
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (csv2rdf.booleanValue()) {
            source.addSubModel((Model)vreq.getSession().getAttribute("csv2rdfResult"));
        } else {
            for (String aSourceModel : sourceModel) {
                Model m = JenaIngestController.getModel(aSourceModel, (HttpServletRequest)vreq);
                source.addSubModel(m);
            }
        }
        Model destination = csv2rdf != false ? ModelFactory.createDefaultModel() : JenaIngestController.getModel(vreq.getParameter("destinationModelName"), (HttpServletRequest)vreq);
        JenaIngestUtils utils = new JenaIngestUtils();
        destination.enterCriticalSection(false);
        try {
            if (!patternBoolean) {
                destination.add(utils.renameBNodes((Model)source, namespaceEtc, (Model)vreq.getJenaOntModel()));
            } else {
                destination.add(utils.renameBNodesByPattern((Model)source, namespaceEtc, (Model)vreq.getJenaOntModel(), pattern, property));
            }
            if (csv2rdf.booleanValue()) {
                Model ultimateDestination = JenaIngestController.getModel(vreq.getParameter("destinationModelName"), (HttpServletRequest)vreq);
                ultimateDestination.add(destination);
            }
        }
        finally {
            destination.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSmushSingleModel(VitroRequest vreq) {
        String[] sourceModel;
        OntModel source = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        for (String aSourceModel : sourceModel = vreq.getParameterValues("sourceModelName")) {
            Model m = JenaIngestController.getModel(aSourceModel, (HttpServletRequest)vreq);
            source.addSubModel(m);
        }
        Model destination = JenaIngestController.getModel(vreq.getParameter("destinationModelName"), (HttpServletRequest)vreq);
        String propertyURIStr = vreq.getParameter("propertyURI");
        Property prop = ResourceFactory.createProperty((String)propertyURIStr);
        JenaIngestUtils utils = new JenaIngestUtils();
        destination.enterCriticalSection(false);
        try {
            destination.add(utils.smushResources((Model)source, prop));
        }
        finally {
            destination.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doExecuteSparql(VitroRequest vreq) {
        String queryStr;
        String[] sourceModel;
        OntModel jenaOntModel = ModelAccess.on(this.getServletContext()).getOntModel();
        OntModel source = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        for (String aSourceModel : sourceModel = vreq.getParameterValues("sourceModelName")) {
            Model m = JenaIngestController.getModel(aSourceModel, (HttpServletRequest)vreq);
            source.addSubModel(m);
        }
        Model destination = JenaIngestController.getModel(vreq.getParameter("destinationModelName"), (HttpServletRequest)vreq);
        String sparqlQueryStr = vreq.getParameter("sparqlQueryStr");
        String savedQueryURIStr = vreq.getParameter("savedQuery");
        if (savedQueryURIStr.length() == 0) {
            log.debug((Object)"Using entered query");
            queryStr = sparqlQueryStr;
        } else {
            Property queryStrProp = ResourceFactory.createProperty((String)SPARQL_QUERYSTR_PROP);
            jenaOntModel.enterCriticalSection(true);
            try {
                Individual ind = jenaOntModel.getIndividual(savedQueryURIStr);
                log.debug((Object)("Using query " + savedQueryURIStr));
                queryStr = ((Literal)ind.getPropertyValue(queryStrProp)).getLexicalForm();
                queryStr = StringEscapeUtils.UNESCAPE_HTML4.translate((CharSequence)queryStr);
            }
            finally {
                jenaOntModel.leaveCriticalSection();
            }
        }
        Model tempModel = ModelFactory.createDefaultModel();
        Query query = SparqlQueryUtils.create(queryStr);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)source);
        try {
            qexec.execConstruct(tempModel);
        }
        catch (QueryExecException qee) {
            qexec.execDescribe(tempModel);
        }
        destination.enterCriticalSection(false);
        try {
            if (destination instanceof OntModel) {
                ((OntModel)destination).getBaseModel().notifyEvent((Object)new EditEvent(null, true));
            } else {
                destination.notifyEvent((Object)new EditEvent(null, true));
            }
            destination.add(tempModel);
        }
        finally {
            if (destination instanceof OntModel) {
                ((OntModel)destination).getBaseModel().notifyEvent((Object)new EditEvent(null, false));
            } else {
                destination.notifyEvent((Object)new EditEvent(null, false));
            }
            destination.leaveCriticalSection();
        }
        return tempModel.size();
    }

    public void doSubtractModels(VitroRequest vreq) {
        String modela = vreq.getParameter("modela");
        String modelb = vreq.getParameter("modelb");
        String destination = vreq.getParameter("destinationModelName");
        Model ma = JenaIngestController.getModel(modela, (HttpServletRequest)vreq);
        Model mb = JenaIngestController.getModel(modelb, (HttpServletRequest)vreq);
        Model destinationModel = JenaIngestController.getModel(destination, (HttpServletRequest)vreq);
        if (!destination.equals(modela)) {
            destinationModel.add(ma.difference(mb));
        } else {
            ma.remove(mb);
        }
    }

    public void doSplitPropertyValues(VitroRequest vreq) {
        String sourceModelStr = vreq.getParameter("sourceModelName");
        String destinationModelStr = vreq.getParameter("destinationModelName");
        Model sourceModel = JenaIngestController.getModel(sourceModelStr, (HttpServletRequest)vreq);
        Model destinationModel = JenaIngestController.getModel(destinationModelStr, (HttpServletRequest)vreq);
        String propertyURI = vreq.getParameter("propertyURI");
        String splitRegex = vreq.getParameter("splitRegex");
        String newPropertyURI = vreq.getParameter("newPropertyURI");
        String trimStr = vreq.getParameter("trim");
        boolean trim = "TRUE".equalsIgnoreCase(trimStr);
        destinationModel.add(new JenaIngestUtils().splitPropertyValues(sourceModel, propertyURI, splitRegex, newPropertyURI, trim));
    }

    public void doGenerateTBox(VitroRequest vreq) {
        String[] sourceModel;
        OntModel source = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        for (String aSourceModel : sourceModel = vreq.getParameterValues("sourceModelName")) {
            Model m = JenaIngestController.getModel(aSourceModel, (HttpServletRequest)vreq);
            source.addSubModel(m);
        }
        String destinationModelStr = vreq.getParameter("destinationModelName");
        Model destination = JenaIngestController.getModel(destinationModelStr, (HttpServletRequest)vreq);
        destination.add((Model)new JenaIngestUtils().generateTBox((Model)source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessStrings(VitroRequest vreq) {
        try {
            String retractionsModelStr;
            String className = vreq.getParameter("className");
            String methodName = vreq.getParameter("methodName");
            String propertyName = vreq.getParameter("propertyName");
            String newPropertyName = vreq.getParameter("newPropertyName");
            Model destination = JenaIngestController.getModel(vreq.getParameter("destinationModelName"), (HttpServletRequest)vreq);
            String processModel = vreq.getParameter("processModel");
            Model savedAdditionsModel = null;
            Model savedRetractionsModel = null;
            String additionsModelStr = vreq.getParameter("additionsModel");
            if (additionsModelStr != null && additionsModelStr.length() > 0) {
                savedAdditionsModel = JenaIngestController.getModel(additionsModelStr, (HttpServletRequest)vreq);
            }
            if ((retractionsModelStr = vreq.getParameter("retractionsModel")) != null && retractionsModelStr.length() > 0) {
                savedRetractionsModel = JenaIngestController.getModel(retractionsModelStr, (HttpServletRequest)vreq);
            }
            Model additionsModel = ModelFactory.createDefaultModel();
            Model retractionsModel = ModelFactory.createDefaultModel();
            Class<?> stringProcessorClass = Class.forName(className);
            Object processor = stringProcessorClass.newInstance();
            Class[] methArgs = new Class[]{String.class};
            Method meth = stringProcessorClass.getMethod(methodName, methArgs);
            Property prop = ResourceFactory.createProperty((String)propertyName);
            Property newProp = ResourceFactory.createProperty((String)newPropertyName);
            destination.enterCriticalSection(true);
            try {
                StmtIterator closeIt;
                StmtIterator stmtIt = closeIt = destination.listStatements((Resource)null, prop, (RDFNode)null);
                while (stmtIt.hasNext()) {
                    Statement stmt = (Statement)stmtIt.next();
                    if (!stmt.getObject().isLiteral()) continue;
                    Literal lit = (Literal)stmt.getObject();
                    String lex = lit.getLexicalForm();
                    Object[] args = new Object[]{lex};
                    String newLex = "";
                    try {
                        newLex = (String)meth.invoke(processor, args);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    if (newLex.equals(lex)) continue;
                    retractionsModel.add(stmt);
                    if (newLex.length() <= 0) continue;
                    Literal newLit = null;
                    newLit = lit.getLanguage() != null && lit.getLanguage().length() > 0 ? additionsModel.createLiteral(newLex, lit.getLanguage()) : (lit.getDatatype() != null ? additionsModel.createTypedLiteral(newLex, lit.getDatatype()) : additionsModel.createLiteral(newLex));
                    additionsModel.add(stmt.getSubject(), newProp, (RDFNode)newLit);
                }
                if (processModel != null) {
                    destination.add(additionsModel);
                    destination.remove(retractionsModel);
                }
                if (savedAdditionsModel != null) {
                    savedAdditionsModel.add(additionsModel);
                }
                if (savedRetractionsModel != null) {
                    savedRetractionsModel.add(retractionsModel);
                }
            }
            finally {
                destination.leaveCriticalSection();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanLiterals(Model model) {
        Model retractionsModel = ModelFactory.createDefaultModel();
        Model additionsModel = ModelFactory.createDefaultModel();
        model.enterCriticalSection(false);
        try {
            try (StmtIterator closeIt = model.listStatements();){
                StmtIterator stmtIt = closeIt;
                while (stmtIt.hasNext()) {
                    Statement stmt = (Statement)stmtIt.next();
                    if (!stmt.getObject().isLiteral()) continue;
                    Literal lit = (Literal)stmt.getObject();
                    String lex = lit.getLexicalForm();
                    char[] chars = lex.toCharArray();
                    char[] cleanChars = new char[chars.length];
                    int cleanPos = 0;
                    boolean badChar = false;
                    for (char aChar : chars) {
                        if (Character.getNumericValue(aChar) > 31 && Character.isDefined(aChar)) {
                            cleanChars[cleanPos] = aChar;
                            ++cleanPos;
                            continue;
                        }
                        log.error((Object)("Bad char in " + lex));
                        log.error((Object)("Numeric value " + Character.getNumericValue(aChar)));
                        badChar = true;
                    }
                    String cleanLex = new String(cleanChars);
                    if (!badChar) continue;
                    retractionsModel.add(stmt);
                    Literal newLit = null;
                    newLit = lit.getLanguage() != null && lit.getLanguage().length() > 0 ? additionsModel.createLiteral(cleanLex, lit.getLanguage()) : (lit.getDatatype() != null ? additionsModel.createTypedLiteral(cleanLex, lit.getDatatype()) : additionsModel.createLiteral(cleanLex));
                    additionsModel.add(stmt.getSubject(), stmt.getPredicate(), (RDFNode)newLit);
                }
            }
            model.remove(retractionsModel);
            model.add(additionsModel);
            log.debug((Object)("Cleaned " + additionsModel.size() + " literals"));
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private void doExecuteWorkflow(VitroRequest vreq) {
        String workflowURI = vreq.getParameter("workflowURI");
        String workflowStepURI = vreq.getParameter("workflowStepURI");
        OntModel jenaOntModel = (OntModel)JenaIngestController.getModel("vitro:jenaOntModel", (HttpServletRequest)vreq);
        new JenaIngestWorkflowProcessor(jenaOntModel.getIndividual(workflowURI), JenaIngestController.getModelMaker((HttpServletRequest)vreq)).run(jenaOntModel.getIndividual(workflowStepURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRename(String oldNamespace, String newNamespace, String editorUri) {
        String uri = null;
        String result = null;
        Integer counter = 0;
        Boolean namespacePresent = false;
        try (RDFService rdfService = ModelAccess.on(this.getServletContext()).getRDFService();){
            Object object;
            Model baseOntModel = RDFServiceGraph.createRDFServiceModel(new RDFServiceGraph(rdfService, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2"));
            OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel();
            LinkedList<String> urisToChange = new LinkedList<String>();
            ontModel.enterCriticalSection(true);
            try {
                ExtendedIterator indIter = ontModel.listIndividuals();
                while (indIter.hasNext()) {
                    Individual ind = (Individual)indIter.next();
                    String namespace = ind.getNameSpace();
                    if (namespace == null || !oldNamespace.equals(namespace)) continue;
                    uri = ind.getURI();
                    urisToChange.add(uri);
                    namespacePresent = true;
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
            if (!namespacePresent.booleanValue()) {
                result = "no resources renamed";
                object = result;
                return object;
            }
            for (String oldURIStr : urisToChange) {
                long time1 = System.currentTimeMillis();
                Resource res = baseOntModel.getResource(oldURIStr);
                long time2 = System.currentTimeMillis();
                String newURIStr = null;
                Pattern p = Pattern.compile(oldNamespace);
                String candidateString = res.getURI();
                Matcher matcher = p.matcher(candidateString);
                newURIStr = matcher.replaceFirst(newNamespace);
                long time3 = System.currentTimeMillis();
                log.debug((Object)("time to get new uri: " + Long.toString(time3 - time2)));
                log.debug((Object)("Renaming " + oldURIStr + " to " + newURIStr));
                String whereClause = "} WHERE { \n  GRAPH <http://vitro.mannlib.cornell.edu/default/vitro-kb-2> { \n   { <" + oldURIStr + "> ?p <" + oldURIStr + "> } \n      UNION \n   { <" + oldURIStr + "> ?q ?o } \n      UNION \n   { ?s ?r <" + oldURIStr + "> } \n  } \n}";
                String removeQuery = "CONSTRUCT { \n   <" + oldURIStr + "> ?p <" + oldURIStr + "> . \n    <" + oldURIStr + "> ?q ?o . \n    ?s ?r <" + oldURIStr + "> \n" + whereClause;
                String addQuery = "CONSTRUCT { \n   <" + newURIStr + "> ?p <" + newURIStr + "> . \n    <" + newURIStr + "> ?q ?o . \n    ?s ?r <" + newURIStr + "> \n" + whereClause;
                try {
                    ChangeSet cs = rdfService.manufactureChangeSet();
                    cs.addAddition(rdfService.sparqlConstructQuery(addQuery, RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", editorUri);
                    cs.addRemoval(rdfService.sparqlConstructQuery(removeQuery, RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2", editorUri);
                    rdfService.changeSetUpdate(cs);
                }
                catch (RDFServiceException e) {
                    throw new RuntimeException(e);
                }
                long time4 = System.currentTimeMillis();
                log.debug((Object)(" time to rename : " + Long.toString(time4 - time3)));
                log.debug((Object)(" time for one resource: " + Long.toString(time4 - time1)));
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
            }
            result = counter.toString() + " resources renamed";
            object = result;
            return object;
        }
    }

    protected String showModelList(VitroRequest vreq, ModelMaker maker, ModelAccess.WhichService modelType) {
        vreq.setAttribute("modelType", modelType.toString());
        if (modelType == ModelAccess.WhichService.CONTENT) {
            vreq.setAttribute("infoLine", "Main Store models");
        } else {
            vreq.setAttribute("infoLine", "Configuration models");
        }
        vreq.setAttribute("modelNames", maker.listModels().toList());
        vreq.setAttribute("bodyAttr", "onLoad=\"init()\"");
        vreq.setAttribute("title", "Available Models");
        return LIST_MODELS_JSP;
    }

    private void processDumpRestore(VitroRequest vreq, HttpServletResponse response) throws ServletException, IOException {
        JSPPageHandler.renderPlainPage((HttpServletRequest)vreq, response, "/dumpRestore");
    }

    public static Model getModel(String name, HttpServletRequest request) {
        return JenaIngestController.getModelMaker(request).getModel(name);
    }

    protected static ModelMaker getModelMaker(HttpServletRequest req) {
        ServletContext ctx = req.getSession().getServletContext();
        if (JenaIngestController.isUsingMainStoreForIngest(req)) {
            RDFService rdfService = ModelAccess.on(ctx).getRDFService(ModelAccess.WhichService.CONTENT);
            return new BlankNodeFilteringModelMaker(rdfService, ModelAccess.on(ctx).getModelMaker(ModelAccess.WhichService.CONTENT));
        }
        RDFService rdfService = ModelAccess.on(ctx).getRDFService(ModelAccess.WhichService.CONFIGURATION);
        return new BlankNodeFilteringModelMaker(rdfService, ModelAccess.on(ctx).getModelMaker(ModelAccess.WhichService.CONFIGURATION));
    }
}

