/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao;

import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.NewURIMaker;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewURIMakerVitro
implements NewURIMaker {
    private static final Log log = LogFactory.getLog((String)NewURIMakerVitro.class.getName());
    private static final int MAX_ATTEMPTS = 20;
    WebappDaoFactory wdf;
    Set<String> madeURIs = new HashSet<String>();
    static Random random = new Random();

    public NewURIMakerVitro(WebappDaoFactory wdf) {
        this.wdf = wdf;
    }

    @Override
    public String getUnusedNewURI(String prefixURI) throws InsertException {
        IndividualImpl ind = new IndividualImpl();
        String newURI = null;
        int attempts = 0;
        boolean goodNewURI = false;
        log.debug((Object)("Before starting : Made URIs contains " + this.madeURIs.toString()));
        while (!goodNewURI && attempts < 20) {
            if (++attempts > 2 && prefixURI != null && !prefixURI.isEmpty()) {
                log.debug((Object)("Attempts: " + attempts + " and prefix not null and prefix not empty " + prefixURI));
                ind.setURI(prefixURI + random.nextInt());
            } else {
                log.debug((Object)("Attempts:" + attempts + " and setting uri to " + prefixURI));
                ind.setURI(prefixURI);
            }
            newURI = this.wdf.getIndividualDao().getUnusedURI(ind);
            log.debug((Object)("Created new uri " + newURI + " and does madeURIs contain it?" + this.madeURIs.contains(newURI)));
            if (newURI != null && !newURI.isEmpty() && !this.madeURIs.contains(newURI)) {
                log.debug((Object)"new URI is not null and new URI is empty and madeURIs does not containt new URI");
                goodNewURI = true;
                this.madeURIs.add(newURI);
            }
            log.debug((Object)("Made URIs contains " + this.madeURIs.toString()));
        }
        if (goodNewURI && newURI != null && !newURI.isEmpty()) {
            log.debug((Object)("Decided on this URI " + newURI));
            return newURI;
        }
        log.error((Object)("An error occurred and URI could not be created for prefix " + prefixURI));
        throw new InsertException("Could not get a new URI for the prefix " + prefixURI);
    }
}

