/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao;

import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import java.util.List;
import java.util.Objects;
import org.apache.jena.vocabulary.OWL;

public interface PropertyDao {
    public void addSuperproperty(Property var1, Property var2);

    public void addSuperproperty(String var1, String var2);

    public void removeSuperproperty(Property var1, Property var2);

    public void removeSuperproperty(String var1, String var2);

    public void addSubproperty(Property var1, Property var2);

    public void addSubproperty(String var1, String var2);

    public void removeSubproperty(Property var1, Property var2);

    public void removeSubproperty(String var1, String var2);

    public void addEquivalentProperty(String var1, String var2);

    public void addEquivalentProperty(Property var1, Property var2);

    public void removeEquivalentProperty(String var1, String var2);

    public void removeEquivalentProperty(Property var1, Property var2);

    public List<String> getSubPropertyURIs(String var1);

    public List<String> getAllSubPropertyURIs(String var1);

    public List<String> getSuperPropertyURIs(String var1, boolean var2);

    public List<String> getAllSuperPropertyURIs(String var1);

    public List<String> getEquivalentPropertyURIs(String var1);

    public List<VClass> getClassesWithRestrictionOnProperty(String var1);

    public static class FullPropertyKey {
        private static final String OWL_THING = OWL.Thing.getURI();
        private final String domainUri;
        private final String propertyUri;
        private final String rangeUri;
        private final int hash;
        private final String string;

        public FullPropertyKey(String uri) {
            this(OWL_THING, uri, OWL_THING);
        }

        public FullPropertyKey(Property p) {
            this(p.getDomainVClassURI(), p.getURI(), p.getRangeVClassURI());
        }

        public FullPropertyKey(String domainUri, String propertyUri, String rangeUri) {
            this.propertyUri = Objects.requireNonNull(propertyUri, "propertyUri may not be null.");
            this.domainUri = domainUri == null ? OWL_THING : domainUri;
            this.rangeUri = rangeUri == null ? OWL_THING : rangeUri;
            this.hash = this.calculateHash();
            this.string = this.calculateString();
        }

        private int calculateHash() {
            return Objects.hash(this.domainUri, this.propertyUri, this.rangeUri);
        }

        private String calculateString() {
            return "FullPropertyKey[domainUri=" + this.domainUri + ", propertyUri=" + this.propertyUri + ", rangeUri=" + this.rangeUri + "]";
        }

        public String getDomainUri() {
            return this.domainUri;
        }

        public String getPropertyUri() {
            return this.propertyUri;
        }

        public String getRangeUri() {
            return this.rangeUri;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FullPropertyKey that = (FullPropertyKey)obj;
            return Objects.equals(this.domainUri, that.domainUri) && Objects.equals(this.propertyUri, that.propertyUri) && Objects.equals(this.rangeUri, that.rangeUri);
        }

        public String toString() {
            return this.string;
        }
    }
}

