/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import com.fasterxml.jackson.databind.JsonNode;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.ObjectPropertyDaoFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.ObjectPropertyFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jga.algorithms.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualFiltering
implements Individual {
    private final Individual _innerIndividual;
    private final VitroFilters _filters;
    private static final Log log = LogFactory.getLog(IndividualFiltering.class);

    public IndividualFiltering(Individual individual, VitroFilters filters) {
        this._innerIndividual = individual;
        this._filters = filters;
    }

    @Override
    public List<DataProperty> getDataPropertyList() {
        List<DataProperty> dprops = this._innerIndividual.getDataPropertyList();
        LinkedList<DataProperty> outdProps = new LinkedList<DataProperty>();
        if (dprops == null) {
            return outdProps;
        }
        Filter.filter(dprops, this._filters.getDataPropertyFilter(), outdProps);
        ListIterator it = outdProps.listIterator();
        while (it.hasNext()) {
            DataProperty dp = (DataProperty)it.next();
            LinkedList<DataPropertyStatement> filteredStmts = new LinkedList<DataPropertyStatement>();
            Filter.filter(dp.getDataPropertyStatements(), this._filters.getDataPropertyStatementFilter(), filteredStmts);
            if (filteredStmts.size() == 0) {
                it.remove();
                continue;
            }
            dp.setDataPropertyStatements(filteredStmts);
        }
        return outdProps;
    }

    @Override
    public List<DataProperty> getPopulatedDataPropertyList() {
        ArrayList<DataProperty> outdProps = new ArrayList<DataProperty>();
        List<DataProperty> dprops = this._innerIndividual.getPopulatedDataPropertyList();
        if (dprops != null) {
            outdProps.addAll(dprops);
        }
        return outdProps;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements() {
        List<DataPropertyStatement> dstmts = this._innerIndividual.getDataPropertyStatements();
        return this.filterDataPropertyStatements(dstmts);
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements(String propertyUri) {
        List<DataPropertyStatement> dstmts = this._innerIndividual.getDataPropertyStatements(propertyUri);
        return this.filterDataPropertyStatements(dstmts);
    }

    private List<DataPropertyStatement> filterDataPropertyStatements(List<DataPropertyStatement> dStmts) {
        LinkedList<DataPropertyStatement> outDstmts = new LinkedList<DataPropertyStatement>();
        if (dStmts == null) {
            return outDstmts;
        }
        Filter.filter(dStmts, this._filters.getDataPropertyStatementFilter(), outDstmts);
        return outDstmts;
    }

    @Override
    public Map<String, DataProperty> getDataPropertyMap() {
        Map<String, DataProperty> innerMap = this._innerIndividual.getDataPropertyMap();
        if (innerMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, DataProperty> returnMap = new HashMap<String, DataProperty>();
        for (String key : innerMap.keySet()) {
            DataProperty dp = innerMap.get(key);
            if (!((Boolean)this._filters.getDataPropertyFilter().fn((Object)dp)).booleanValue()) continue;
            LinkedList<DataPropertyStatement> filteredStmts = new LinkedList<DataPropertyStatement>();
            Filter.filter(dp.getDataPropertyStatements(), this._filters.getDataPropertyStatementFilter(), filteredStmts);
            if (filteredStmts.size() <= 0) continue;
            dp.setDataPropertyStatements(filteredStmts);
            returnMap.put(key, dp);
        }
        return returnMap;
    }

    @Override
    public List<ObjectProperty> getObjectPropertyList() {
        List<ObjectProperty> oprops = this._innerIndividual.getObjectPropertyList();
        return ObjectPropertyDaoFiltering.filterAndWrap(oprops, this._filters);
    }

    @Override
    public List<ObjectProperty> getPopulatedObjectPropertyList() {
        return this._innerIndividual.getPopulatedObjectPropertyList();
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        return this.filterObjectPropertyStatements(this._innerIndividual.getObjectPropertyStatements());
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(String propertyUri) {
        return this.filterObjectPropertyStatements(this._innerIndividual.getObjectPropertyStatements(propertyUri));
    }

    private List<ObjectPropertyStatement> filterObjectPropertyStatements(List<ObjectPropertyStatement> opStmts) {
        if (opStmts == null) {
            return Collections.emptyList();
        }
        this._innerIndividual.resolveAsFauxPropertyStatements(opStmts);
        ArrayList<ObjectPropertyStatement> filtered = new ArrayList<ObjectPropertyStatement>();
        Filter.filter(opStmts, this._filters.getObjectPropertyStatementFilter(), filtered);
        return filtered;
    }

    @Override
    public Map<String, ObjectProperty> getObjectPropertyMap() {
        Map<String, ObjectProperty> innerMap = this._innerIndividual.getObjectPropertyMap();
        if (innerMap == null) {
            return null;
        }
        HashMap<String, ObjectProperty> returnMap = new HashMap<String, ObjectProperty>();
        for (String key : innerMap.keySet()) {
            ObjectProperty innerProp = innerMap.get(key);
            if (innerProp == null || !((Boolean)this._filters.getObjectPropertyFilter().fn((Object)innerProp)).booleanValue()) continue;
            returnMap.put(key, new ObjectPropertyFiltering(innerProp, this._filters));
        }
        return returnMap;
    }

    public boolean equals(Object obj) {
        return this._innerIndividual.equals(obj);
    }

    @Override
    public List<DataPropertyStatement> getExternalIds() {
        return this._innerIndividual.getExternalIds();
    }

    @Override
    public String getMainImageUri() {
        return this._innerIndividual.getMainImageUri();
    }

    @Override
    public String getImageUrl() {
        return this._innerIndividual.getImageUrl();
    }

    @Override
    public String getThumbUrl() {
        return this._innerIndividual.getThumbUrl();
    }

    @Override
    public String getLocalName() {
        return this._innerIndividual.getLocalName();
    }

    @Override
    public Timestamp getModTime() {
        return this._innerIndividual.getModTime();
    }

    @Override
    public String getName() {
        return this._innerIndividual.getName();
    }

    @Override
    public String getLabel() {
        return this._innerIndividual.getLabel();
    }

    @Override
    public String getPickListName() {
        return this.getName();
    }

    @Override
    public String getRdfsLabel() {
        return this._innerIndividual.getRdfsLabel();
    }

    @Override
    public String getNamespace() {
        return this._innerIndividual.getNamespace();
    }

    @Override
    public String getURI() {
        return this._innerIndividual.getURI();
    }

    @Override
    public VClass getVClass() {
        return this._innerIndividual.getVClass();
    }

    @Override
    public String getVClassURI() {
        return this._innerIndividual.getVClassURI();
    }

    public int hashCode() {
        return this._innerIndividual.hashCode();
    }

    @Override
    public void setDatatypePropertyList(List<DataProperty> datatypePropertyList) {
        this._innerIndividual.setDatatypePropertyList(datatypePropertyList);
    }

    @Override
    public void setPopulatedDataPropertyList(List<DataProperty> dataPropertyList) {
        this._innerIndividual.setPopulatedDataPropertyList(dataPropertyList);
    }

    @Override
    public void setObjectPropertyStatements(List<ObjectPropertyStatement> list) {
        this._innerIndividual.setObjectPropertyStatements(list);
    }

    @Override
    public void setDataPropertyStatements(List<DataPropertyStatement> list) {
        this._innerIndividual.setDataPropertyStatements(list);
    }

    @Override
    public void setExternalIds(List<DataPropertyStatement> externalIds) {
        this._innerIndividual.setExternalIds(externalIds);
    }

    @Override
    public void setMainImageUri(String mainImageUri) {
        this._innerIndividual.setMainImageUri(mainImageUri);
    }

    @Override
    public void setLocalName(String localName) {
        this._innerIndividual.setLocalName(localName);
    }

    @Override
    public void setModTime(Timestamp in) {
        this._innerIndividual.setModTime(in);
    }

    @Override
    public void setName(String in) {
        this._innerIndividual.setName(in);
    }

    @Override
    public void setRdfsLabel(String in) {
        this._innerIndividual.setRdfsLabel(in);
    }

    @Override
    public void setNamespace(String namespace) {
        this._innerIndividual.setNamespace(namespace);
    }

    @Override
    public void setPropertyList(List<ObjectProperty> propertyList) {
        this._innerIndividual.setPropertyList(propertyList);
    }

    @Override
    public void setPopulatedObjectPropertyList(List<ObjectProperty> propertyList) {
        this._innerIndividual.setPopulatedObjectPropertyList(propertyList);
    }

    @Override
    public void setURI(String URI2) {
        this._innerIndividual.setURI(URI2);
    }

    @Override
    public void setVClass(VClass class1) {
        this._innerIndividual.setVClass(class1);
    }

    @Override
    public void setVClassURI(String in) {
        this._innerIndividual.setVClassURI(in);
    }

    @Override
    public void sortForDisplay() {
        this._innerIndividual.sortForDisplay();
    }

    @Override
    public List<VClass> getVClasses() {
        return this._innerIndividual.getVClasses();
    }

    @Override
    public List<VClass> getVClasses(boolean direct) {
        return this._innerIndividual.getVClasses(direct);
    }

    @Override
    public boolean isVClass(String uri) {
        return this._innerIndividual.isVClass(uri);
    }

    @Override
    public List<String> getMostSpecificTypeURIs() {
        return this._innerIndividual.getMostSpecificTypeURIs();
    }

    @Override
    public void setDataPropertyMap(Map<String, DataProperty> propertyMap) {
        this._innerIndividual.setDataPropertyMap(propertyMap);
    }

    @Override
    public void setObjectPropertyMap(Map<String, ObjectProperty> propertyMap) {
        this._innerIndividual.setObjectPropertyMap(propertyMap);
    }

    @Override
    public void setVClasses(List<VClass> classList, boolean direct) {
        this._innerIndividual.setVClasses(classList, direct);
    }

    @Override
    public JsonNode toJSON() {
        return this._innerIndividual.toJSON();
    }

    @Override
    public boolean isAnonymous() {
        return this._innerIndividual.isAnonymous();
    }

    @Override
    public int compareTo(Individual ind2) {
        return this._innerIndividual.compareTo(ind2);
    }

    public String toString() {
        return this._innerIndividual.toString();
    }

    @Override
    public void setSearchBoost(Float boost) {
        this._innerIndividual.setSearchBoost(boost);
    }

    @Override
    public Float getSearchBoost() {
        return this._innerIndividual.getSearchBoost();
    }

    @Override
    public void setSearchSnippet(String snippet) {
        this._innerIndividual.setSearchSnippet(snippet);
    }

    @Override
    public String getSearchSnippet() {
        return this._innerIndividual.getSearchSnippet();
    }

    @Override
    public List<String> getDataValues(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements(propertyUri);
        if (stmts == null) {
            return Collections.emptyList();
        }
        ArrayList<String> dataValues = new ArrayList<String>(stmts.size());
        for (DataPropertyStatement stmt : stmts) {
            dataValues.add(stmt.getData());
        }
        return dataValues;
    }

    @Override
    public String getDataValue(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements(propertyUri);
        if (stmts == null) {
            return null;
        }
        return stmts.isEmpty() ? null : stmts.get(0).getData();
    }

    @Override
    public DataPropertyStatement getDataPropertyStatement(String propertyUri) {
        List<DataPropertyStatement> stmts = this.getDataPropertyStatements(propertyUri);
        if (stmts == null) {
            return null;
        }
        return stmts.isEmpty() ? null : stmts.get(0);
    }

    @Override
    public List<Individual> getRelatedIndividuals(String propertyUri) {
        List<ObjectPropertyStatement> stmts = this.getObjectPropertyStatements(propertyUri);
        if (stmts == null) {
            return Collections.emptyList();
        }
        ArrayList<Individual> relatedIndividuals = new ArrayList<Individual>(stmts.size());
        for (ObjectPropertyStatement stmt : stmts) {
            relatedIndividuals.add(stmt.getObject());
        }
        return relatedIndividuals;
    }

    @Override
    public Individual getRelatedIndividual(String propertyUri) {
        List<ObjectPropertyStatement> stmts = this.getObjectPropertyStatements(propertyUri);
        if (stmts == null) {
            return null;
        }
        return stmts.isEmpty() ? null : stmts.get(0).getObject();
    }

    @Override
    public boolean hasThumb() {
        return this._innerIndividual.hasThumb();
    }

    @Override
    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
        this._innerIndividual.resolveAsFauxPropertyStatements(list);
    }
}

