/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering.filters;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFiltersImpl;
import net.sf.jga.fn.UnaryFunctor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterByDisplayPermission
extends VitroFiltersImpl {
    private static final Log log = LogFactory.getLog(FilterByDisplayPermission.class);
    UserAccount userAccount = PolicyHelper.getUserAccount(null);

    public FilterByDisplayPermission() {
        this.setDataPropertyFilter(new DataPropertyFilterByPolicy());
        this.setObjectPropertyFilter(new ObjectPropertyFilterByPolicy());
        this.setDataPropertyStatementFilter(new DataPropertyStatementFilterByPolicy());
        this.setObjectPropertyStatementFilter(new ObjectPropertyStatementFilterByPolicy());
    }

    boolean checkAuthorization(AccessObject accessObject) {
        boolean decision = PolicyHelper.isAuthorizedForActions(this.userAccount, accessObject, AccessOperation.DISPLAY);
        log.debug((Object)("decision is " + decision));
        return decision;
    }

    private class ObjectPropertyStatementFilterByPolicy
    extends UnaryFunctor<ObjectPropertyStatement, Boolean> {
        private ObjectPropertyStatementFilterByPolicy() {
        }

        public Boolean fn(ObjectPropertyStatement ops) {
            String subjectUri = ops.getSubjectURI();
            ObjectProperty predicate = this.getOrCreateProperty(ops);
            String objectUri = ops.getObjectURI();
            return FilterByDisplayPermission.this.checkAuthorization(new ObjectPropertyStatementAccessObject(null, subjectUri, predicate, objectUri));
        }

        private ObjectProperty getOrCreateProperty(ObjectPropertyStatement ops) {
            if (ops.getProperty() != null) {
                return ops.getProperty();
            }
            if (ops.getPropertyURI() == null) {
                return null;
            }
            ObjectProperty op = new ObjectProperty();
            op.setURI(ops.getPropertyURI());
            op.setDomainVClassURI(AccessObject.SOME_URI);
            op.setRangeVClassURI(AccessObject.SOME_URI);
            return op;
        }
    }

    private class DataPropertyStatementFilterByPolicy
    extends UnaryFunctor<DataPropertyStatement, Boolean> {
        private DataPropertyStatementFilterByPolicy() {
        }

        public Boolean fn(DataPropertyStatement dps) {
            return FilterByDisplayPermission.this.checkAuthorization(new DataPropertyStatementAccessObject(null, dps));
        }
    }

    private class ObjectPropertyFilterByPolicy
    extends UnaryFunctor<ObjectProperty, Boolean> {
        private ObjectPropertyFilterByPolicy() {
        }

        public Boolean fn(ObjectProperty op) {
            return FilterByDisplayPermission.this.checkAuthorization(new ObjectPropertyAccessObject(op));
        }
    }

    private class DataPropertyFilterByPolicy
    extends UnaryFunctor<DataProperty, Boolean> {
        private DataPropertyFilterByPolicy() {
        }

        public Boolean fn(DataProperty dp) {
            return FilterByDisplayPermission.this.checkAuthorization(new DataPropertyAccessObject(dp));
        }
    }
}

