/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering.filters;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.FilterByDisplayPermission;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFiltersImpl;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletContext;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.ChainUnary;
import net.sf.jga.fn.property.GetProperty;
import net.sf.jga.fn.string.Match;

public class VitroFilterUtils {
    public static VitroFilters getPublicFilter(ServletContext ctx) {
        return new FilterByDisplayPermission();
    }

    protected static VitroFiltersImpl getNoOpFilter() {
        return new VitroFiltersImpl();
    }

    public static VitroFilters getTestFilter() {
        GetProperty getName = new GetProperty(Individual.class, "getName");
        Match startsWithG = new Match("^[gG].*");
        ChainUnary onlyNamesThatStartWithG = new ChainUnary((UnaryFunctor)startsWithG, (UnaryFunctor)getName);
        return VitroFilterUtils.getNoOpFilter().setIndividualFilter((UnaryFunctor<Individual, Boolean>)onlyNamesThatStartWithG);
    }

    public static UnaryFunctor<Individual, String> FirstLetterOfIndividuals() {
        return new UnaryFunctor<Individual, String>(){

            public String fn(Individual arg) {
                return arg.getName().substring(0, 1);
            }

            public String toString() {
                return "filter: FirstLetterOfIndividuals";
            }
        };
    }

    public static class EntitySortTransform
    extends UnaryFunctor<List<Individual>, List<Individual>> {
        private final Comparator<? super Individual> comparator;
        private static Comparator<? super Individual> nameComp = new Comparator<Individual>(){

            @Override
            public int compare(Individual o1, Individual o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return 1;
                }
                if (name2 == null) {
                    return -1;
                }
                Collator collator = Collator.getInstance();
                return collator.compare(name1, name2);
            }

            public String toString() {
                return "nameComp";
            }
        };
        private static Comparator<? super Individual> nameCompDesc = new Comparator<Individual>(){

            @Override
            public int compare(Individual o1, Individual o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                Collator collator = Collator.getInstance();
                return collator.compare(name1, name2);
            }

            public String toString() {
                return "nameCompDesc";
            }
        };

        public EntitySortTransform(String fieldName, boolean ascending) {
            this.comparator = ascending ? nameComp : nameCompDesc;
        }

        public List<Individual> fn(List<Individual> individuals) {
            individuals.sort(this.comparator);
            return individuals;
        }
    }
}

