/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration;

import edu.cornell.mannlib.vitro.webapp.dao.jena.VitroModelSource;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.ModelSelector;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelNames;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.ModelSource;

public class IdModelSelector
implements ModelSelector {
    private final String name;

    public IdModelSelector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name of model must not be null.");
        }
        this.name = name;
    }

    @Override
    public Model getModel(HttpServletRequest request, ServletContext context) {
        ModelMaker modelMaker = ModelAccess.getInstance().getModelMaker(this.getRdfService());
        VitroModelSource mSource = new VitroModelSource((ModelSource)modelMaker, context);
        return mSource.getModel(this.name);
    }

    private ModelAccess.WhichService getRdfService() {
        return this.isConfigurationModel() ? ModelAccess.WhichService.CONFIGURATION : ModelAccess.WhichService.CONTENT;
    }

    private boolean isConfigurationModel() {
        return this.name.equals(VitroModelSource.ModelName.DISPLAY.toString()) || this.name.equals(VitroModelSource.ModelName.DISPLAY_TBOX.toString()) || this.name.equals(VitroModelSource.ModelName.DISPLAY_DISPLAY.toString());
    }

    @Override
    public String getDefaultGraphUri() {
        if (ModelNames.namesMap.containsKey(this.name)) {
            return ModelNames.namesMap.get(this.name);
        }
        return this.name;
    }
}

