/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.vclassgroup.ProhibitedFromSearch;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.JspToGeneratorMapping;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaObjectPropetyOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultAddMissingIndividualFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.search.controller.SearchFiltering;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;

public class DefaultObjectPropertyFormGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(DefaultObjectPropertyFormGenerator.class);
    private String subjectUri = null;
    private String predicateUri = null;
    private String objectUri = null;
    private String objectPropertyTemplate = "defaultPropertyForm.ftl";
    private String acObjectPropertyTemplate = "autoCompleteObjectPropForm.ftl";
    protected boolean doAutoComplete = false;
    protected boolean tooManyRangeIndividuals = false;
    protected long maxNonACRangeIndividualCount = 300L;
    protected String customErrorMessages = null;

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        if (!EditConfigurationUtils.isObjectProperty(EditConfigurationUtils.getPredicateUri(vreq), vreq)) {
            throw new Exception("DefaultObjectPropertyFormGenerator does not handle data properties.");
        }
        this.customErrorMessages = this.getCustomErrorMessages(vreq);
        if (this.customErrorMessages != null) {
            return this.getCustomErrorEditConfiguration(vreq, session);
        }
        if (this.tooManyRangeOptions(vreq, session)) {
            this.tooManyRangeIndividuals = true;
            this.doAutoComplete = true;
        }
        if (DefaultAddMissingIndividualFormGenerator.isCreateNewIndividual(vreq, session)) {
            EditConfigurationGenerator generator = JspToGeneratorMapping.createFor("defaultAddMissingIndividualForm.jsp", DefaultAddMissingIndividualFormGenerator.class);
            return generator.getEditConfiguration(vreq, session);
        }
        return this.getDefaultObjectEditConfiguration(vreq, session);
    }

    private String getCustomErrorMessages(VitroRequest vreq) {
        WebappDaoFactory ctxDaoFact;
        String errorMessages = null;
        String rangeUri = vreq.getParameter("rangeUri");
        VClass rangeVClass = null;
        if (rangeUri != null && !rangeUri.isEmpty() && (rangeVClass = (ctxDaoFact = vreq.getLanguageNeutralWebappDaoFactory()).getVClassDao().getVClassByURI(rangeUri)) == null) {
            errorMessages = I18n.text((HttpServletRequest)vreq, "the_range_class_does_not_exist", new Object[0]);
        }
        return errorMessages;
    }

    protected List<VClass> getRangeTypes(VitroRequest vreq) {
        WebappDaoFactory ctxDaoFact = ModelAccess.on((HttpServletRequest)vreq).getWebappDaoFactory(ModelAccess.LanguageOption.LANGUAGE_AWARE, ModelAccess.PolicyOption.POLICY_NEUTRAL);
        ArrayList<VClass> types = new ArrayList<VClass>();
        Individual subject = EditConfigurationUtils.getSubjectIndividual(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        String rangeUri = EditConfigurationUtils.getRangeUri(vreq);
        if (rangeUri != null && !rangeUri.isEmpty()) {
            VClass rangeVClass = ctxDaoFact.getVClassDao().getVClassByURI(rangeUri);
            if (rangeVClass != null) {
                if (!rangeVClass.isUnion()) {
                    types.add(rangeVClass);
                } else {
                    types.addAll(rangeVClass.getUnionComponents());
                }
                return types;
            }
            this.log.error((Object)("Range VClass does not exist for " + rangeUri));
        }
        WebappDaoFactory wDaoFact = vreq.getWebappDaoFactory();
        if (subject != null) {
            List<VClass> vClasses = subject.getVClasses();
            HashMap<String, VClass> typesHash = new HashMap<String, VClass>();
            for (VClass vclass : vClasses) {
                List<VClass> rangeVclasses = wDaoFact.getVClassDao().getVClassesForProperty(vclass.getURI(), predicateUri);
                if (rangeVclasses == null) continue;
                for (VClass range : rangeVclasses) {
                    typesHash.put(range.getURI(), range);
                }
            }
            types.addAll(typesHash.values());
        } else {
            this.log.error((Object)"Subject individual was null for");
        }
        return types;
    }

    private boolean tooManyRangeOptions(VitroRequest vreq, HttpSession session) throws SearchEngineException {
        List<VClass> rangeTypes = this.getRangeTypes(vreq);
        SearchEngine searchEngine = ApplicationUtils.instance().getSearchEngine();
        ArrayList<String> types = new ArrayList<String>();
        for (VClass vclass : rangeTypes) {
            if (vclass.getURI() == null) continue;
            types.add(vclass.getURI());
        }
        if (types.size() == 0) {
            types.add("http://www.w3.org/2002/07/owl#Thing");
        }
        Set<String> currentRoles = SearchFiltering.getCurrentUserRoles(vreq);
        long count = 0L;
        for (String type : types) {
            SearchQuery query = searchEngine.createQuery();
            if ("http://www.w3.org/2002/07/owl#Thing".equals(type)) {
                query.setQuery("*:*");
            } else {
                query.setQuery("type:" + type);
            }
            query.setRows(0);
            SearchFiltering.addDefaultFilters(query, currentRoles);
            SearchResponse rsp = searchEngine.query(query);
            SearchResultDocumentList docs = rsp.getResults();
            long found = docs.getNumFound();
            if ((count += found) <= this.maxNonACRangeIndividualCount) continue;
            break;
        }
        return count > this.maxNonACRangeIndividualCount;
    }

    private EditConfigurationVTwo getDefaultObjectEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.setNewResources(new HashMap<String, String>());
        this.setUrisAndLiteralsInScope(editConfiguration);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList<String>());
        this.setSparqlQueries(editConfiguration);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri(vreq), this.getRangeTypes(vreq));
        this.prepareForUpdate(vreq, session, editConfiguration);
        this.processProhibitedFromSearch(vreq, session, editConfiguration);
        this.setTemplate(editConfiguration, vreq);
        editConfiguration.addValidator(new AntiXssValidation());
        this.setEditKey(editConfiguration, vreq);
        if (this.doAutoComplete) {
            this.addFormSpecificDataForAC(editConfiguration, vreq, session);
        } else {
            this.addFormSpecificData(editConfiguration, vreq);
        }
        return editConfiguration;
    }

    private EditConfigurationVTwo getCustomErrorEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        this.setUrisAndLiteralsInScope(editConfiguration);
        this.setSparqlQueries(editConfiguration);
        this.prepareForUpdate(vreq, session, editConfiguration);
        editConfiguration.setTemplate("customErrorMessages.ftl");
        this.setEditKey(editConfiguration, vreq);
        if (this.customErrorMessages != null) {
            HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
            formSpecificData.put("customErrorMessages", this.customErrorMessages);
            editConfiguration.setFormSpecificData(formSpecificData);
        }
        return editConfiguration;
    }

    private void setEditKey(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        String editKey = EditConfigurationUtils.getEditKey(vreq);
        editConfiguration.setEditKey(editKey);
    }

    private void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        if (this.doAutoComplete) {
            editConfiguration.setTemplate(this.acObjectPropertyTemplate);
        } else {
            editConfiguration.setTemplate(this.objectPropertyTemplate);
        }
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext(vreq);
        this.subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        this.predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setFormUrl(formUrl);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setSubjectUri(this.subjectUri);
        editConfiguration.setEntityToReturnTo(this.subjectUri);
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setPredicateUri(this.predicateUri);
        if (EditConfigurationUtils.isObjectProperty(this.predicateUri, vreq)) {
            this.log.debug((Object)("This is an object property: " + this.predicateUri));
            this.initObjectParameters(vreq);
            this.processObjectPropForm(vreq, editConfiguration);
        } else {
            this.log.debug((Object)("This is a data property: " + this.predicateUri));
        }
    }

    private void initObjectParameters(VitroRequest vreq) {
        this.objectUri = EditConfigurationUtils.getObjectUri(vreq);
    }

    private void processObjectPropForm(VitroRequest vreq, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForObject("objectVar");
        editConfiguration.setObject(this.objectUri);
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        ArrayList<String> n3ForEdit = new ArrayList<String>();
        String editString = "?subject ?predicate ";
        editString = editString + "?objectVar";
        editString = editString + " .";
        n3ForEdit.add(editString);
        return n3ForEdit;
    }

    private List<String> generateN3Optional() {
        ArrayList<String> n3Inverse = new ArrayList<String>();
        n3Inverse.add("?objectVar ?inverseProp ?subject .");
        return n3Inverse;
    }

    private String retrieveQueryForInverse() {
        String queryForInverse = "PREFIX owl:  <http://www.w3.org/2002/07/owl#> SELECT ?inverse_property     WHERE { ?inverse_property owl:inverseOf ?predicate } ";
        return queryForInverse;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap<String, List<Literal>>());
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        urisOnForm.add("objectVar");
        editConfiguration.setUrisOnform(urisOnForm);
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap<String, String>());
        HashMap<String, String> urisInScope = new HashMap<String, String>();
        urisInScope.put("inverseProp", this.retrieveQueryForInverse());
        editConfiguration.setSparqlForAdditionalUrisInScope(urisInScope);
        editConfiguration.setSparqlForExistingLiterals(this.generateSparqlForExistingLiterals());
        editConfiguration.setSparqlForExistingUris(this.generateSparqlForExistingUris());
    }

    private HashMap<String, String> generateSparqlForExistingUris() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    private HashMap<String, String> generateSparqlForExistingLiterals() {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    protected void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) throws Exception {
        this.setFields(editConfiguration, vreq, predicateUri, null);
    }

    protected void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri, List<VClass> rangeTypes) throws Exception {
        FieldVTwo field = new FieldVTwo();
        field.setName("objectVar");
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("nonempty");
        field.setValidators(validators);
        if (!this.doAutoComplete) {
            field.setOptions(new IndividualsViaObjectPropetyOptions(this.subjectUri, predicateUri, rangeTypes, this.objectUri, vreq));
        } else {
            field.setOptions(null);
        }
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        fields.put(field.getName(), field);
        editConfiguration.setFields(fields);
    }

    private void prepareForUpdate(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        OntModel model = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
        if (EditConfigurationUtils.isObjectProperty(EditConfigurationUtils.getPredicateUri(vreq), vreq)) {
            Individual objectIndividual = EditConfigurationUtils.getObjectIndividual(vreq);
            if (objectIndividual != null) {
                editConfiguration.prepareForObjPropUpdate((Model)model);
            } else {
                editConfiguration.prepareForNonUpdate((Model)model);
            }
        } else {
            throw new Error("DefaultObjectPropertyForm does not handle data properties.");
        }
    }

    private boolean isSelectFromExisting(VitroRequest vreq) {
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        if (EditConfigurationUtils.isDataProperty(predicateUri, vreq)) {
            return false;
        }
        ObjectProperty objProp = EditConfigurationUtils.getObjectPropertyForPredicate(vreq, EditConfigurationUtils.getPredicateUri(vreq));
        return objProp.getSelectFromExisting();
    }

    private void processProhibitedFromSearch(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfig) {
        if (this.isSelectFromExisting(vreq)) {
            OntModel displayOntModel = ModelAccess.on(session.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata");
            ProhibitedFromSearch pfs = new ProhibitedFromSearch("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex", displayOntModel);
            if (editConfig != null) {
                editConfig.setProhibitedFromSearch(pfs);
            }
        }
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        ArrayList<String> objectSelect = new ArrayList<String>();
        objectSelect.add(editConfiguration.getVarNameForObject());
        formSpecificData.put("objectSelect", objectSelect);
        if (this.customErrorMessages != null && !this.customErrorMessages.isEmpty()) {
            formSpecificData.put("customErrorMessages", this.customErrorMessages);
        }
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public void addFormSpecificDataForAC(EditConfigurationVTwo editConfiguration, VitroRequest vreq, HttpSession session) throws SearchEngineException {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("editMode", this.getEditMode(vreq).toString().toLowerCase());
        List<VClass> types = this.getRangeTypes(vreq);
        if (types.size() == 1 && types.get(0).getURI().equals("http://www.w3.org/2002/07/owl#Thing")) {
            types = new ArrayList<VClass>();
        }
        StringBuilder typesBuff = new StringBuilder();
        for (VClass type : types) {
            if (type.getURI() == null) continue;
            typesBuff.append(type.getURI()).append(",");
        }
        formSpecificData.put("objectTypes", typesBuff.toString());
        this.log.debug((Object)("autocomplete object types : " + formSpecificData.get("objectTypes")));
        if (EditConfigurationUtils.getObjectIndividual(vreq) != null) {
            String objectLabel = EditConfigurationUtils.getObjectIndividual(vreq).getName();
            formSpecificData.put("objectLabel", objectLabel);
        }
        Set<String> currentRoles = SearchFiltering.getCurrentUserRoles(vreq);
        formSpecificData.put("rangeIndividualsExist", this.rangeIndividualsExist(types, currentRoles));
        formSpecificData.put("sparqlForAcFilter", this.getSparqlForAcFilter(vreq));
        if (this.customErrorMessages != null && !this.customErrorMessages.isEmpty()) {
            formSpecificData.put("customErrorMessages", this.customErrorMessages);
        }
        editConfiguration.setTemplate(this.acObjectPropertyTemplate);
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    private Object rangeIndividualsExist(List<VClass> types, Set<String> currentRoles) throws SearchEngineException {
        SearchEngine searchEngine = ApplicationUtils.instance().getSearchEngine();
        boolean rangeIndividualsFound = false;
        for (VClass type : types) {
            SearchQuery query = searchEngine.createQuery();
            query.setQuery("type:" + type.getURI());
            query.setRows(0);
            SearchFiltering.addDefaultFilters(query, currentRoles);
            SearchResponse rsp = searchEngine.query(query);
            SearchResultDocumentList docs = rsp.getResults();
            if (docs.getNumFound() <= 0L) continue;
            rangeIndividualsFound = true;
            break;
        }
        return rangeIndividualsFound;
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    public String getPredicateUri() {
        return this.predicateUri;
    }

    public String getObjectUri() {
        return this.objectUri;
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        FrontEndEditingUtils.EditMode editMode = FrontEndEditingUtils.EditMode.ADD;
        if (objectUri != null && !objectUri.isEmpty()) {
            editMode = FrontEndEditingUtils.EditMode.EDIT;
        }
        return editMode;
    }

    public String getSparqlForAcFilter(VitroRequest vreq) {
        String subject = EditConfigurationUtils.getSubjectUri(vreq);
        String predicate = EditConfigurationUtils.getPredicateUri(vreq);
        String query = "SELECT ?objectVar WHERE { <" + subject + "> <" + predicate + "> ?objectVar .} ";
        return query;
    }
}

