/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.config.RevisionInfoBean;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nLogger;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;

public class TranslationProvider {
    private static final String MESSAGE_KEY_NOT_FOUND = "ERROR: Translation not found ''{0}''";
    private static final TranslationProvider INSTANCE = new TranslationProvider();
    private static final Log log = LogFactory.getLog(TranslationProvider.class);
    private static final I18nLogger i18nLogger = new I18nLogger();
    private static final String QUERY = "PREFIX : <http://vivoweb.org/ontology/vitro/ui-label/vocabulary#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nSELECT ?translation \nWHERE {\n  GRAPH <http://vitro.mannlib.cornell.edu/default/interface-i18n> {\n\t  ?uri :hasKey ?key .\n\t  ?uri rdfs:label ?translation .\n\t  OPTIONAL { \n\t\t?uri :hasTheme ?found_theme .\n\t  }\n\t  OPTIONAL { \n\t\t?uri :hasApp ?found_application .\n   }\n\t  BIND(COALESCE(?found_theme, \"none\") as ?theme ) .\n\t  FILTER(?theme = \"none\" || ?theme = ?current_theme) . \t  BIND(COALESCE(?found_application, \"none\") as ?application ) .\n\t  BIND(IF(?current_application = ?application && ?current_theme = ?theme, 3, \t\t   \tIF(?current_theme = ?theme, 2, \t\t\t\tIF(?current_application = ?application, 1, 0)) ) AS ?order ) .\n   }\n} \nORDER by DESC(?order)";
    protected RDFService rdfService;
    protected String application = "Vitro";
    private Map<TranslationKey, String> cache = new ConcurrentHashMap<TranslationKey, String>();
    private String theme = "vitro";
    private int prefixLen = "themes/".length();
    private int suffixLen = "/".length();
    private WebappDaoFactory wdf;

    public static TranslationProvider getInstance() {
        return INSTANCE;
    }

    public void initialize(ServletContext ctx) {
        RevisionInfoBean info = (RevisionInfoBean)ctx.getAttribute(RevisionInfoBean.ATTRIBUTE_NAME);
        List<RevisionInfoBean.LevelRevisionInfo> levelInfos = info.getLevelInfos();
        this.setApplication(levelInfos);
        this.rdfService = ModelAccess.on(ctx).getRDFService(ModelAccess.WhichService.CONFIGURATION);
        this.wdf = ModelAccess.on(ctx).getWebappDaoFactory();
        this.updateTheme();
    }

    private void updateTheme() {
        String themeDir = this.wdf.getApplicationDao().getApplicationBean().getThemeDir();
        int length = themeDir.length();
        this.theme = themeDir.substring(this.prefixLen, length - this.suffixLen);
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    private void setApplication(List<RevisionInfoBean.LevelRevisionInfo> levelInfos) {
        if (levelInfos.isEmpty()) {
            return;
        }
        this.application = levelInfos.get(0).getName();
    }

    public String getTranslation(List<String> preferredLocales, String key, Object[] parameters) {
        TranslationKey tk = new TranslationKey(preferredLocales, key, parameters);
        if (this.cache.containsKey(tk) && !TranslationProvider.needExportInfo()) {
            log.debug((Object)("Returned value from cache for " + key));
            return this.cache.get(tk);
        }
        String text = this.getText(preferredLocales, key);
        String formattedText = TranslationProvider.formatString(text, parameters);
        i18nLogger.log(key, parameters, text, formattedText);
        if (TranslationProvider.needExportInfo()) {
            return this.prepareExportInfo(key, parameters, text, formattedText);
        }
        this.cache.put(tk, formattedText);
        log.debug((Object)("Added to cache " + key));
        log.debug((Object)("Returned value from request for " + key));
        return formattedText;
    }

    private String prepareExportInfo(String key, Object[] parameters, String text, String message) {
        String separatedArgs = "";
        for (int i = 0; i < parameters.length; ++i) {
            separatedArgs = separatedArgs + parameters[i] + "\u25a6";
        }
        log.debug((Object)("Returned value with export info for " + key));
        return "\u25a4" + key + "\u25a6" + text + "\u25a6" + separatedArgs + message + "\u25a5";
    }

    private String getText(List<String> preferredLocales, String key) {
        QueryHolder queryHolder = new QueryHolder(QUERY).bindToPlainLiteral("current_application", this.application).bindToPlainLiteral("key", key).bindToPlainLiteral("current_theme", this.theme).bindToPlainLiteral("locale", preferredLocales.get(0));
        LanguageFilteringRDFService lfrs = new LanguageFilteringRDFService(this.rdfService, preferredLocales);
        final LinkedList list = new LinkedList();
        try {
            lfrs.sparqlSelectQuery(queryHolder.getQueryString(), new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    Literal translation = qs.getLiteral("translation");
                    if (translation != null) {
                        list.add(translation.getLexicalForm());
                    }
                }
            });
        }
        catch (RDFServiceException e) {
            log.error((Object)e, (Throwable)e);
        }
        String textString = list.isEmpty() ? this.notFound(key) : (String)list.get(0);
        return textString;
    }

    private static boolean needExportInfo() {
        return DeveloperSettings.getInstance().getBoolean(Key.I18N_ONLINE_TRANSLATION);
    }

    private static String formatString(String textString, Object ... parameters) {
        if (parameters.length == 0) {
            return textString;
        }
        return MessageFormat.format(TranslationProvider.preprocessForFormating(textString), parameters);
    }

    public static String preprocessForFormating(String inputText) {
        if (inputText != null) {
            return inputText.replace("''", "'").replace("'", "''");
        }
        return "";
    }

    private String notFound(String key) {
        return MessageFormat.format(MESSAGE_KEY_NOT_FOUND, key);
    }

    public void clearCache() {
        if (this.wdf != null) {
            this.updateTheme();
        }
        this.cache.clear();
        log.info((Object)"Translation cache cleared");
    }

    private class TranslationKey {
        private List<String> preferredLocales;
        private String key;
        private Object[] parameters;

        public TranslationKey(List<String> preferredLocales, String key, Object[] parameters) {
            this.preferredLocales = preferredLocales;
            this.key = key;
            this.parameters = parameters;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TranslationKey)) {
                return false;
            }
            TranslationKey other = (TranslationKey)obj;
            return new EqualsBuilder().append(this.preferredLocales, other.preferredLocales).append((Object)this.key, (Object)other.key).append(this.parameters, other.parameters).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.preferredLocales).append((Object)this.key).append(this.parameters).toHashCode();
        }
    }
}

