/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.OperationGroup;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AuthMigrator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;

public class AnnotationMigrator {
    private static final Log log = LogFactory.getLog(AnnotationMigrator.class);
    private static final String PREFIX = "http://vitro.mannlib.cornell.edu/ns/vitro/role#";
    private static final String OLD_ROLE_PUBLIC = "http://vitro.mannlib.cornell.edu/ns/vitro/role#public";
    private static final String OLD_ROLE_SELF = "http://vitro.mannlib.cornell.edu/ns/vitro/role#selfEditor";
    private static final String OLD_ROLE_EDITOR = "http://vitro.mannlib.cornell.edu/ns/vitro/role#editor";
    private static final String OLD_ROLE_CURATOR = "http://vitro.mannlib.cornell.edu/ns/vitro/role#curator";
    private static final String OLD_ROLE_DB_ADMIN = "http://vitro.mannlib.cornell.edu/ns/vitro/role#dbAdmin";
    private static final String OLD_ROLE_NOBODY = "http://vitro.mannlib.cornell.edu/ns/vitro/role#nobody";
    private RDFService contentRdfService;
    private RDFService configurationRdfService;
    private Map<String, Set<String>> showMap;
    private static final String fauxTypeSpecificPatterns = "GRAPH <http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata> {  ?context <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#configContextFor> ?base .\n  ?context <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#hasConfiguration> ?uri .\n  ?uri rdf:type <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#ObjectPropertyDisplayConfig> .\n} GRAPH <http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata>";

    public AnnotationMigrator(RDFService contentRdfService, RDFService configurationRdfService) {
        this.contentRdfService = contentRdfService;
        this.configurationRdfService = configurationRdfService;
        this.showMap = new HashMap<String, Set<String>>();
        this.showMap.put(OLD_ROLE_PUBLIC, AuthMigrator.ALL_ROLES);
        this.showMap.put(OLD_ROLE_SELF, new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR")));
        this.showMap.put(OLD_ROLE_EDITOR, new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR")));
        this.showMap.put(OLD_ROLE_CURATOR, new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR")));
        this.showMap.put(OLD_ROLE_DB_ADMIN, new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN")));
        this.showMap.put(OLD_ROLE_NOBODY, Collections.emptySet());
    }

    protected void migrateConfiguration() {
        log.info((Object)"Started annotation configuration conversion");
        Map<String, Map<OperationGroup, Set<String>>> opConfigs = this.getObjectPropertyAnnotations();
        log.info((Object)String.format("Found %s object property annotation configurations", opConfigs.size()));
        Map<String, Map<OperationGroup, Set<String>>> dpConfigs = this.getDataPropertyAnnotations();
        log.info((Object)String.format("Found %s data property annotation configurations", dpConfigs.size()));
        Map<String, Map<OperationGroup, Set<String>>> classConfigs = this.getClassAnnotations();
        log.info((Object)String.format("Found %s class annotation configurations", classConfigs.size()));
        Map<String, Map<OperationGroup, Set<String>>> fopConfigs = this.getFauxObjectPropertyAnnotations(opConfigs.keySet());
        log.info((Object)String.format("Found %s faux object property annotation configurations", fopConfigs.size()));
        Map<String, Map<OperationGroup, Set<String>>> fdpConfigs = this.getFauxDataPropertyAnnotations(dpConfigs.keySet());
        log.info((Object)String.format("Found %s faux data property annotation configurations", fdpConfigs.size()));
        Long[] valueCounts = AnnotationMigrator.updatePolicyDatasets(AccessObjectType.OBJECT_PROPERTY, opConfigs);
        log.info((Object)String.format("Updated object property datasets. Added %d values, removed %d values", valueCounts[0], valueCounts[1]));
        valueCounts = AnnotationMigrator.updatePolicyDatasets(AccessObjectType.DATA_PROPERTY, dpConfigs);
        log.info((Object)String.format("Updated data property datasets, added %d values, removed %d values", valueCounts[0], valueCounts[1]));
        valueCounts = AnnotationMigrator.updatePolicyDatasets(AccessObjectType.CLASS, classConfigs);
        log.info((Object)String.format("Updated class property datasets, added %d values, removed %d values", valueCounts[0], valueCounts[1]));
        valueCounts = AnnotationMigrator.updatePolicyDatasets(AccessObjectType.FAUX_OBJECT_PROPERTY, fopConfigs);
        log.info((Object)String.format("Updated faux object property datasets, added %d values, removed %d values", valueCounts[0], valueCounts[1]));
        valueCounts = AnnotationMigrator.updatePolicyDatasets(AccessObjectType.FAUX_DATA_PROPERTY, fdpConfigs);
        log.info((Object)String.format("Updated data property datasets, added %d values, removed %d values", valueCounts[0], valueCounts[1]));
        PolicyLoader.getInstance().loadPolicies();
    }

    protected Map<String, Map<OperationGroup, Set<String>>> getFauxDataPropertyAnnotations(Set<String> dataProperties) {
        String queryText = AnnotationMigrator.getAnnotationQuery(fauxTypeSpecificPatterns);
        return this.getFauxConfigurations(queryText, this.configurationRdfService, dataProperties);
    }

    protected Map<String, Map<OperationGroup, Set<String>>> getFauxObjectPropertyAnnotations(Set<String> objectProperties) {
        String queryText = AnnotationMigrator.getAnnotationQuery(fauxTypeSpecificPatterns);
        return this.getFauxConfigurations(queryText, this.configurationRdfService, objectProperties);
    }

    protected Map<String, Map<OperationGroup, Set<String>>> getClassAnnotations() {
        String queryText = AnnotationMigrator.getAnnotationQuery("  ?uri rdf:type owl:Class .\n");
        return this.getConfigurations(queryText, this.contentRdfService);
    }

    protected Map<String, Map<OperationGroup, Set<String>>> getDataPropertyAnnotations() {
        String queryText = AnnotationMigrator.getAnnotationQuery("  ?uri rdf:type owl:DatatypeProperty .\n");
        return this.getConfigurations(queryText, this.contentRdfService);
    }

    protected Map<String, Map<OperationGroup, Set<String>>> getObjectPropertyAnnotations() {
        String queryText = AnnotationMigrator.getAnnotationQuery("  ?uri rdf:type owl:ObjectProperty .\n");
        return this.getConfigurations(queryText, this.contentRdfService);
    }

    private Map<String, Map<OperationGroup, Set<String>>> getConfigurations(String queryText, RDFService service) {
        HashMap<String, Map<OperationGroup, Set<String>>> configs = new HashMap<String, Map<OperationGroup, Set<String>>>();
        try {
            ResultSet rs = RDFServiceUtils.sparqlSelectQuery(queryText, service);
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                this.collectConfiguration(configs, qs);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return configs;
    }

    private Map<String, Map<OperationGroup, Set<String>>> getFauxConfigurations(String queryText, RDFService service, Set<String> targetProperties) {
        HashMap<String, Map<OperationGroup, Set<String>>> configs = new HashMap<String, Map<OperationGroup, Set<String>>>();
        try {
            ResultSet rs = RDFServiceUtils.sparqlSelectQuery(queryText, service);
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String baseUri = qs.getResource("base").getURI();
                if (!targetProperties.contains(baseUri)) continue;
                this.collectConfiguration(configs, qs);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return configs;
    }

    private void collectConfiguration(Map<String, Map<OperationGroup, Set<String>>> configs, QuerySolution qs) {
        String uri = qs.getResource("uri").getURI();
        String displayAnnotation = qs.getResource("display").getURI();
        HashSet displayRoles = new HashSet(this.showMap.get(displayAnnotation));
        String publishAnnotation = qs.getResource("publish").getURI();
        HashSet publishRoles = new HashSet(this.showMap.get(publishAnnotation));
        publishRoles.remove("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        String updateAnnotation = qs.getResource("update").getURI();
        HashSet updateRoles = new HashSet(this.showMap.get(updateAnnotation));
        updateRoles.remove("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        HashMap config = new HashMap();
        config.put(OperationGroup.UPDATE_GROUP, updateRoles);
        config.put(OperationGroup.PUBLISH_GROUP, publishRoles);
        config.put(OperationGroup.DISPLAY_GROUP, displayRoles);
        configs.put(uri, config);
    }

    private static Long[] updatePolicyDatasets(AccessObjectType aot, Map<String, Map<OperationGroup, Set<String>>> configs) {
        StringBuilder additions = new StringBuilder();
        StringBuilder removals = new StringBuilder();
        for (String entityUri : configs.keySet()) {
            Map<OperationGroup, Set<String>> groupMap = configs.get(entityUri);
            for (OperationGroup og : groupMap.keySet()) {
                for (AccessOperation ao : OperationGroup.getOperations(og)) {
                    Set<String> rolesToAdd = groupMap.get((Object)og);
                    if (!rolesToAdd.isEmpty()) {
                        log.info((Object)String.format("Granted access to %s %s %s for roles %s", new Object[]{ao, aot, entityUri, AnnotationMigrator.rolesToString(rolesToAdd)}));
                    }
                    EntityPolicyController.getDataValueStatements(entityUri, aot, ao, rolesToAdd, additions, new String[0]);
                    HashSet<String> rolesToRemove = new HashSet<String>(AuthMigrator.ALL_ROLES);
                    rolesToRemove.removeAll(rolesToAdd);
                    if (OperationGroup.PUBLISH_GROUP.equals((Object)og) || OperationGroup.UPDATE_GROUP.equals((Object)og)) {
                        rolesToRemove.remove("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
                    }
                    if (!rolesToRemove.isEmpty()) {
                        log.info((Object)String.format("Revoked access to %s %s %s for roles %s", new Object[]{ao, aot, entityUri, AnnotationMigrator.rolesToString(rolesToRemove)}));
                    }
                    EntityPolicyController.getDataValueStatements(entityUri, aot, ao, rolesToRemove, removals, new String[0]);
                    log.debug((Object)String.format("Updated entity %s dataset for operation group %s access object type %s roles %s", new Object[]{entityUri, og, aot, rolesToAdd}));
                }
            }
        }
        PolicyLoader.getInstance().updateAccessControlModel(additions.toString(), true);
        PolicyLoader.getInstance().updateAccessControlModel(removals.toString(), false);
        return new Long[]{AnnotationMigrator.getLineCount(additions.toString()), AnnotationMigrator.getLineCount(removals.toString())};
    }

    private static Object rolesToString(Set<String> roles) {
        String result = "";
        for (String roleUri : roles) {
            String roleName = roleUri;
            if (roleName.startsWith("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#")) {
                roleName = roleName.substring("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#".length());
            }
            if (!result.isEmpty()) {
                result = result + ", ";
            }
            result = result + roleName;
        }
        return result;
    }

    private static String getAnnotationQuery(String typeSpecificPatterns) {
        return "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#> \nSELECT ?base ?uri ?update ?display ?publish\nWHERE {\n" + typeSpecificPatterns + "{OPTIONAL { ?uri vitro:hiddenFromDisplayBelowRoleLevelAnnot ?displayAssigned . }\nBIND (COALESCE(?displayAssigned, <http://vitro.mannlib.cornell.edu/ns/vitro/role#public>) AS ?display)\nOPTIONAL { ?uri vitro:prohibitedFromUpdateBelowRoleLevelAnnot ?updateAssigned . }\nBIND (COALESCE(?updateAssigned, <http://vitro.mannlib.cornell.edu/ns/vitro/role#selfEditor>) AS ?update)\nOPTIONAL { ?uri vitro:hiddenFromPublishBelowRoleLevelAnnot ?publishAssigned . }\nBIND (COALESCE(?publishAssigned, <http://vitro.mannlib.cornell.edu/ns/vitro/role#public>) AS ?publish)\nFILTER (!isBlank(?uri))\n}} \n";
    }

    private static long getLineCount(String lines) {
        Matcher matcher = Pattern.compile("\n").matcher(lines);
        long i = 0L;
        while (matcher.find()) {
            ++i;
        }
        return i;
    }
}

