/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.OperationGroup;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;

public class ArmMigrator {
    private static final Log log = LogFactory.getLog(ArmMigrator.class);
    protected static String DISPLAY = "Display";
    protected static String UPDATE = "Update";
    protected static String PUBLISH = "Publish";
    protected static final String ARM_ADMIN = "ADMIN";
    protected static final String ARM_CURATOR = "CURATOR";
    protected static final String ARM_EDITOR = "EDITOR";
    protected static final String ARM_SELF_EDITOR = "SELF_EDITOR";
    protected static final String ARM_PUBLIC = "PUBLIC";
    protected static final String ARM_CUSTOM = "CUSTOM";
    protected StringBuilder removals = new StringBuilder();
    protected StringBuilder additions = new StringBuilder();
    protected static final List<String> armOperations = Arrays.asList(DISPLAY, UPDATE, PUBLISH);
    protected static final List<AccessObjectType> entityTypes = Arrays.asList(AccessObjectType.CLASS, AccessObjectType.OBJECT_PROPERTY, AccessObjectType.DATA_PROPERTY, AccessObjectType.FAUX_OBJECT_PROPERTY, AccessObjectType.FAUX_DATA_PROPERTY);
    private RDFService contentRdfService;
    private RDFService configurationRdfService;
    private OntModel userAccountsModel;
    private String VALUE_QUERY = "SELECT ?uri \nWHERE {\n  ?permission <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#forEntity> ?uri . \n}";
    private String PERMISSION_SETS_QUERY = "prefix auth: <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#>\nSELECT ?uri \nWHERE {\n    ?uri a auth:PermissionSet . \n}";
    private static Map<String, String> roleMap;
    private static Map<String, OperationGroup> operationMap;

    public ArmMigrator(RDFService contentRdfService, RDFService configurationRdfService, OntModel userAccountsModel) {
        this.contentRdfService = contentRdfService;
        this.configurationRdfService = configurationRdfService;
        this.userAccountsModel = userAccountsModel;
        operationMap = new HashMap<String, OperationGroup>();
        operationMap.put(DISPLAY, OperationGroup.DISPLAY_GROUP);
        operationMap.put(UPDATE, OperationGroup.UPDATE_GROUP);
        operationMap.put(PUBLISH, OperationGroup.PUBLISH_GROUP);
        roleMap = new HashMap<String, String>();
        roleMap.put(ARM_ADMIN, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        roleMap.put(ARM_CURATOR, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR");
        roleMap.put(ARM_EDITOR, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR");
        roleMap.put(ARM_SELF_EDITOR, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR");
        roleMap.put(ARM_PUBLIC, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        Set<String> actualRoles = this.getPermissionSets();
        for (String role : actualRoles) {
            if (roleMap.values().contains(role)) continue;
            String roleName = ArmMigrator.getRoleName(role);
            log.info((Object)String.format("Custom role %s found.", roleName));
            roleMap.put(roleName, role);
            PolicyTemplateController.createRoleDataSets(role);
            log.info((Object)String.format("Created policy data sets for custom role %s.", roleName));
        }
    }

    public static String getArmPermissionSubject(String operation, String role) {
        return "java:edu.cornell.mannlib.vitro.webapp.auth.permissions.Entity" + operation + "Permission#" + role;
    }

    private static String getRoleName(String roleUri) {
        return roleUri.substring(roleUri.lastIndexOf(35) + 1);
    }

    public void migrateConfiguration() {
        this.cleanEntityDataSetValues();
        Map<AccessObjectType, Set<String>> entityTypeMap = this.getEntityMap();
        this.collectAdditions(entityTypeMap);
        PolicyLoader.getInstance().updateAccessControlModel(this.additions.toString(), true);
    }

    private void cleanEntityDataSetValues() {
        this.getStatementsToRemove();
        PolicyLoader.getInstance().updateAccessControlModel(this.removals.toString(), false);
    }

    protected StringBuilder getStatementsToRemove() {
        for (String role : roleMap.keySet()) {
            String newRole = roleMap.get(role);
            this.getRoleStatementsToRemove(newRole);
        }
        return this.removals;
    }

    private void getRoleStatementsToRemove(String role) {
        for (String operation : armOperations) {
            OperationGroup og = operationMap.get(operation);
            this.getRoleOpGroupStatementsToRemove(role, og);
        }
    }

    private void getRoleOpGroupStatementsToRemove(String role, OperationGroup og) {
        for (AccessOperation ao : OperationGroup.getOperations(og)) {
            this.getRoleOperationStatementsToRemove(role, ao);
        }
    }

    private void getRoleOperationStatementsToRemove(String role, AccessOperation ao) {
        for (AccessObjectType aot : entityTypes) {
            this.getRoleOperationObjectTypedStatementsToRemove(role, ao, aot);
        }
    }

    private void getRoleOperationObjectTypedStatementsToRemove(String role, AccessOperation ao, AccessObjectType aot) {
        Set<String> entityUris = PolicyLoader.getInstance().getDataSetValues(ao, aot, role);
        for (String entityUri : entityUris) {
            EntityPolicyController.getDataValueStatements(entityUri, aot, ao, Collections.singleton(role), this.removals, new String[0]);
        }
    }

    private Set<String> getFauxByBase(String baseUri) {
        HashSet<String> entities = new HashSet<String>();
        String queryText = this.getQueryText(AccessObjectType.FAUX_OBJECT_PROPERTY);
        RDFService service = this.getRdfService(AccessObjectType.FAUX_OBJECT_PROPERTY);
        try {
            ResultSet rs = RDFServiceUtils.sparqlSelectQuery(queryText, service);
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                String entity = qs.getResource("uri").getURI();
                String base = qs.getResource("base").getURI();
                if (!baseUri.equals(base)) continue;
                entities.add(entity);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return entities;
    }

    protected void collectAdditions(Map<AccessObjectType, Set<String>> entityTypeMap) {
        for (String role : roleMap.keySet()) {
            String newRole = roleMap.get(role);
            this.getRoleStatementsToAdd(entityTypeMap, role, newRole);
        }
    }

    private void getRoleStatementsToAdd(Map<AccessObjectType, Set<String>> entityTypeMap, String role, String newRole) {
        for (String operation : armOperations) {
            this.getRoleOperationStatementsToAdd(entityTypeMap, role, newRole, operation);
        }
    }

    private void getRoleOperationStatementsToAdd(Map<AccessObjectType, Set<String>> entityTypeMap, String role, String newRole, String operation) {
        String permissionUri = ArmMigrator.getArmPermissionSubject(operation, role);
        Set<String> armEntities = this.getArmEntites(permissionUri);
        OperationGroup og = operationMap.get(operation);
        HashSet<String> addFauxOP = new HashSet<String>();
        HashSet<String> addFauxDP = new HashSet<String>();
        for (AccessObjectType type : entityTypes) {
            this.getRoleOperationObjectTypedStatementsToAdd(entityTypeMap, role, newRole, armEntities, og, addFauxOP, addFauxDP, type);
        }
    }

    private void getRoleOperationObjectTypedStatementsToAdd(Map<AccessObjectType, Set<String>> entityTypeMap, String role, String newRole, Set<String> armEntities, OperationGroup og, Set<String> addFauxOP, Set<String> addFauxDP, AccessObjectType type) {
        Set<String> faux;
        Set<String> allTypeEntitities = entityTypeMap.get((Object)type);
        HashSet<String> intersectionEntities = new HashSet<String>(armEntities);
        intersectionEntities.retainAll(allTypeEntitities);
        if (AccessObjectType.OBJECT_PROPERTY.equals((Object)type)) {
            for (String entity : intersectionEntities) {
                faux = this.getFauxByBase(entity);
                addFauxOP.addAll(faux);
            }
        }
        if (AccessObjectType.DATA_PROPERTY.equals((Object)type)) {
            for (String entity : intersectionEntities) {
                faux = this.getFauxByBase(entity);
                addFauxDP.addAll(faux);
            }
            if (!ARM_PUBLIC.equals(role) || OperationGroup.DISPLAY_GROUP.equals((Object)og)) {
                intersectionEntities.add("http://www.w3.org/2000/01/rdf-schema#label");
            }
        }
        if (AccessObjectType.FAUX_OBJECT_PROPERTY.equals((Object)type)) {
            intersectionEntities.addAll(addFauxOP);
        }
        if (AccessObjectType.FAUX_DATA_PROPERTY.equals((Object)type)) {
            intersectionEntities.addAll(addFauxDP);
        }
        for (AccessOperation ao : OperationGroup.getOperations(og)) {
            for (String entityUri : intersectionEntities) {
                log.info((Object)String.format("Allow %s role to %s %s entity <%s>", new Object[]{role, ao, type, entityUri}));
                EntityPolicyController.getDataValueStatements(entityUri, type, ao, Collections.singleton(newRole), this.additions, new String[0]);
            }
        }
    }

    protected Map<AccessObjectType, Set<String>> getEntityMap() {
        HashMap<AccessObjectType, Set<String>> map = new HashMap<AccessObjectType, Set<String>>();
        for (AccessObjectType type : entityTypes) {
            this.addEntitiesForType(type, map);
        }
        return map;
    }

    private void addEntitiesForType(AccessObjectType type, Map<AccessObjectType, Set<String>> map) {
        HashSet<String> entities = new HashSet<String>();
        String queryText = this.getQueryText(type);
        RDFService service = this.getRdfService(type);
        try {
            ResultSet rs = RDFServiceUtils.sparqlSelectQuery(queryText, service);
            while (rs.hasNext()) {
                String baseUri;
                QuerySolution qs = rs.next();
                String entity = qs.getResource("uri").getURI();
                if (AccessObjectType.FAUX_DATA_PROPERTY.equals((Object)type)) {
                    baseUri = qs.getResource("base").getURI();
                    Set<String> dataPropSet = map.get((Object)AccessObjectType.DATA_PROPERTY);
                    if (!dataPropSet.contains(baseUri)) continue;
                }
                if (AccessObjectType.FAUX_OBJECT_PROPERTY.equals((Object)type)) {
                    baseUri = qs.getResource("base").getURI();
                    Set<String> objectPropSet = map.get((Object)AccessObjectType.OBJECT_PROPERTY);
                    if (!objectPropSet.contains(baseUri)) continue;
                }
                entities.add(entity);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        map.put(type, entities);
    }

    private String getQueryText(AccessObjectType type) {
        String fauxTypeSpecificPatterns = "GRAPH <http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata> {  ?context <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#configContextFor> ?base .\n  ?context <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#hasConfiguration> ?uri .\n  ?uri rdf:type <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#ObjectPropertyDisplayConfig> .\n}";
        switch (type) {
            case FAUX_OBJECT_PROPERTY: {
                return ArmMigrator.getQuery(fauxTypeSpecificPatterns);
            }
            case FAUX_DATA_PROPERTY: {
                return ArmMigrator.getQuery(fauxTypeSpecificPatterns);
            }
            case CLASS: {
                return ArmMigrator.getQuery("{?uri rdf:type owl:Class .}\n");
            }
            case DATA_PROPERTY: {
                return ArmMigrator.getQuery("{?uri rdf:type owl:DatatypeProperty .}\n");
            }
        }
        return ArmMigrator.getQuery("{?uri rdf:type owl:ObjectProperty .}\n");
    }

    private static String getQuery(String typePatterns) {
        return "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#> \nSELECT ?base ?uri \nWHERE {\n" + typePatterns + "} \n";
    }

    private RDFService getRdfService(AccessObjectType type) {
        if (AccessObjectType.FAUX_OBJECT_PROPERTY.equals((Object)type) || AccessObjectType.FAUX_DATA_PROPERTY.equals((Object)type)) {
            return this.configurationRdfService;
        }
        return this.contentRdfService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getArmEntites(String permissionUri) {
        HashSet<String> entities = new HashSet<String>();
        ParameterizedSparqlString pss = new ParameterizedSparqlString(this.VALUE_QUERY);
        pss.setIri("permission", permissionUri);
        String queryText = pss.toString();
        this.userAccountsModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((String)queryText, (Model)this.userAccountsModel);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String entity = qs.getResource("uri").getURI();
                entities.add(entity);
            }
        }
        finally {
            this.userAccountsModel.leaveCriticalSection();
        }
        return entities;
    }

    public boolean isArmConfiguation() {
        return this.containsAdminDisplayPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAdminDisplayPermission() {
        boolean result = false;
        String queryText = "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nASK WHERE {\n    <" + ArmMigrator.getArmPermissionSubject(DISPLAY, ARM_ADMIN) + "> ?p ?o .\n}";
        this.userAccountsModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((String)queryText, (Model)this.userAccountsModel);){
            result = qexec.execAsk();
        }
        finally {
            this.userAccountsModel.leaveCriticalSection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPermissionSets() {
        HashSet<String> permissionSets = new HashSet<String>();
        String queryText = this.PERMISSION_SETS_QUERY;
        this.userAccountsModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((String)queryText, (Model)this.userAccountsModel);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String entity = qs.getResource("uri").getURI();
                permissionSets.add(entity);
            }
        }
        finally {
            this.userAccountsModel.leaveCriticalSection();
        }
        return permissionSets;
    }
}

