/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AnnotationMigrator;
import edu.cornell.mannlib.vitro.webapp.migration.auth.ArmMigrator;
import edu.cornell.mannlib.vitro.webapp.migration.auth.SimplePermissionMigrator;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;

public class AuthMigrator
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(AuthMigrator.class);
    protected static final Set<String> ALL_ROLES = new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
    private static final String SET_VERSION_TEMPLATE = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix access: <https://vivoweb.org/ontology/vitro-application/auth/vocabulary/> .\n<https://vivoweb.org/ontology/vitro-application/auth/individual/Configuration> rdf:type access:Configuration ;\naccess:version ?version .";
    private static final String REMOVE_VERSION_TEMPLATE = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n<https://vivoweb.org/ontology/vitro-application/auth/individual/Configuration> <https://vivoweb.org/ontology/vitro-application/auth/vocabulary/version> ?version .";
    private static String VERSION_QUERY = "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nprefix access: <https://vivoweb.org/ontology/vitro-application/auth/vocabulary/>\nSELECT ?version \nWHERE {\n  GRAPH <http://vitro.mannlib.cornell.edu/default/access-control> {\n       ?configuration rdf:type access:Configuration .\n       ?configuration access:version ?version .\n  }\n}";
    private RDFService contentRdfService;
    private RDFService configurationRdfService;
    private ContextModelAccess modelAccess;

    public void contextInitialized(ServletContextEvent sce) {
        long begin = System.currentTimeMillis();
        this.modelAccess = ModelAccess.getInstance();
        this.initialize(this.modelAccess.getRDFService(ModelAccess.WhichService.CONTENT), this.modelAccess.getRDFService(ModelAccess.WhichService.CONFIGURATION));
        if (!this.isMigrationRequired()) {
            return;
        }
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        log.info((Object)"Started authorization configuration update");
        this.convertAuthorizationConfiguration();
        log.info((Object)"Finished authorization configuration update");
        ss.info(this, this.secondsSince(begin) + " seconds to migrate auth models");
        log.info((Object)"Reload all policies after migration");
        PolicyLoader.getInstance().loadPolicies();
    }

    protected void initialize(RDFService content, RDFService configuration) {
        this.contentRdfService = content;
        this.configurationRdfService = configuration;
    }

    protected void convertAuthorizationConfiguration() {
        OntModel userAccountsModel = this.modelAccess.getOntModelSelector().getUserAccountsModel();
        ArmMigrator armMigrator = new ArmMigrator(this.contentRdfService, this.configurationRdfService, userAccountsModel);
        if (armMigrator.isArmConfiguation()) {
            armMigrator.migrateConfiguration();
        } else {
            this.migrateAnnotationConfiguation();
        }
        this.migrateSimplePermissions();
        this.removeVersion(this.getVersion());
        this.setVersion(1L);
    }

    private void migrateSimplePermissions() {
        OntModel userAccountsModel = this.modelAccess.getOntModelSelector().getUserAccountsModel();
        SimplePermissionMigrator spm = new SimplePermissionMigrator(userAccountsModel);
        spm.migrateConfiguration();
    }

    private void migrateAnnotationConfiguation() {
        AnnotationMigrator annotationMigrator = new AnnotationMigrator(this.contentRdfService, this.configurationRdfService);
        annotationMigrator.migrateConfiguration();
    }

    private boolean isMigrationRequired() {
        return this.getVersion() == 0L;
    }

    protected long getVersion() {
        long version = 0L;
        try {
            ResultSet rs = RDFServiceUtils.sparqlSelectQuery(VERSION_QUERY, this.configurationRdfService);
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                if (!qs.contains("version") || !qs.get("version").isLiteral()) continue;
                version = qs.getLiteral("version").getLong();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return version;
    }

    protected void removeVersion(long version) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString(REMOVE_VERSION_TEMPLATE);
        pss.setLiteral("version", version);
        PolicyLoader.getInstance().updateAccessControlModel(pss.toString(), false);
    }

    protected void setVersion(long version) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString(SET_VERSION_TEMPLATE);
        pss.setLiteral("version", version);
        PolicyLoader.getInstance().updateAccessControlModel(pss.toString(), true);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private long secondsSince(long startTime) {
        return (System.currentTimeMillis() - startTime) / 1000L;
    }
}

