/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AuthMigrator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;

public class SimplePermissionMigrator {
    private static final Log log = LogFactory.getLog(SimplePermissionMigrator.class);
    private OntModel userAccountsModel;
    private String PERMISSION_SETS_QUERY = "prefix auth: <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#>\nSELECT ?uri \nWHERE {\n  ?uri a auth:PermissionSet . \n}";
    private String ROLE_PERMISSIONS_QUERY = "prefix auth: <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#>\nSELECT ?permission \nWHERE {\n  ?role a auth:PermissionSet . \n  ?role auth:hasPermission ?permission .\n  FILTER (strstarts(str(?permission), 'java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#'))}";
    private Map<String, Set<String>> roleMap;

    public SimplePermissionMigrator(OntModel userAccountsModel) {
        this.userAccountsModel = userAccountsModel;
        this.roleMap = new HashMap<String, Set<String>>();
        this.roleMap.put("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", AuthMigrator.ALL_ROLES);
        this.roleMap.put("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC")));
        this.roleMap.put("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC")));
        this.roleMap.put("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC")));
        this.roleMap.put("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC", new HashSet<String>(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC")));
    }

    public void migrateConfiguration() {
        Set<String> roles = this.getPermissionSets();
        if (!roles.containsAll(AuthMigrator.ALL_ROLES)) {
            log.error((Object)"Roles not found. Simple permission migration failed.");
            return;
        }
        this.migrateRoles(roles);
    }

    private void migrateRoles(Set<String> roles) {
        PolicyLoader policyLoader = PolicyLoader.getInstance();
        for (String role : roles) {
            Set<String> policyPermissions = policyLoader.getDataSetValues(AccessOperation.EXECUTE, AccessObjectType.NAMED_OBJECT, role);
            Set<String> userAccountsPermissions = this.getUserAccountPermissions(role);
            HashSet<String> toRevoke = new HashSet<String>(policyPermissions);
            toRevoke.removeAll(userAccountsPermissions);
            HashSet<String> toGrant = new HashSet<String>(userAccountsPermissions);
            toGrant.removeAll(policyPermissions);
            for (String entityUri : toGrant) {
                policyLoader.addEntityToPolicyDataSet(entityUri, AccessObjectType.NAMED_OBJECT, AccessOperation.EXECUTE, role);
                log.info((Object)String.format("Allow role %s to %s ", SimplePermissionMigrator.getShortName(role), SimplePermissionMigrator.getShortName(entityUri)));
            }
            for (String entityUri : toRevoke) {
                policyLoader.removeEntityFromPolicyDataSet(entityUri, AccessObjectType.NAMED_OBJECT, AccessOperation.EXECUTE, role);
                log.info((Object)String.format("Disallow role %s to %s ", SimplePermissionMigrator.getShortName(role), SimplePermissionMigrator.getShortName(entityUri)));
            }
        }
    }

    private static String getShortName(String entityUri) {
        return entityUri.substring(entityUri.lastIndexOf(35) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getPermissionSets() {
        HashSet<String> permissionSets = new HashSet<String>();
        String queryText = this.PERMISSION_SETS_QUERY;
        this.userAccountsModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((String)queryText, (Model)this.userAccountsModel);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String entity = qs.getResource("uri").getURI();
                permissionSets.add(entity);
            }
        }
        finally {
            this.userAccountsModel.leaveCriticalSection();
        }
        return permissionSets;
    }

    Set<String> getUserAccountPermissions(String role) {
        HashSet<String> permissions = new HashSet<String>();
        if (AuthMigrator.ALL_ROLES.contains(role)) {
            for (String standardRole : this.roleMap.get(role)) {
                this.populateUserAccountPermissions(standardRole, permissions);
            }
        } else {
            this.populateUserAccountPermissions(role, permissions);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateUserAccountPermissions(String role, Set<String> permissions) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString(this.ROLE_PERMISSIONS_QUERY);
        pss.setIri("role", role);
        String queryText = pss.toString();
        this.userAccountsModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((String)queryText, (Model)this.userAccountsModel);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.next();
                String entity = qs.getResource("permission").getURI();
                permissions.add(entity);
            }
        }
        finally {
            this.userAccountsModel.leaveCriticalSection();
        }
    }
}

