/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkGraphMem;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkModelCom;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkOntModelImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingOntModel;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class VitroModelFactory {
    private static final Log log = LogFactory.getLog(VitroModelFactory.class);

    public static Model createModel() {
        return VitroModelFactory.createBulkInMemoryModel();
    }

    private static BulkModelCom createBulkInMemoryModel() {
        return new BulkModelCom((Graph)new BulkGraphMem());
    }

    public static OntModel createOntologyModel() {
        return new BulkOntModelImpl(OntModelSpec.OWL_MEM, (Model)VitroModelFactory.createBulkInMemoryModel());
    }

    public static OntModel createOntologyModel(Model model) {
        Graph graph = model.getGraph();
        BulkModelCom bareModel = new BulkModelCom(graph);
        BulkOntModelImpl ontModel = new BulkOntModelImpl(OntModelSpec.OWL_MEM, (Model)bareModel);
        return new BulkUpdatingOntModel((OntModel)ontModel);
    }

    public static Model createUnion(Model baseModel, Model plusModel) {
        BulkUpdatingUnion unionGraph = new BulkUpdatingUnion(baseModel, plusModel);
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        return new BulkUpdatingModel(unionModel);
    }

    public static OntModel createUnion(OntModel baseModel, OntModel plusModel) {
        BulkUpdatingUnion unionGraph = new BulkUpdatingUnion((Model)baseModel, (Model)plusModel);
        Model unionModel = ModelFactory.createModelForGraph((Graph)unionGraph);
        OntModel unionOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)unionModel);
        return new BulkUpdatingOntModel(unionOntModel);
    }

    public static Model createModelForGraph(Graph g) {
        return new BulkUpdatingModel(ModelFactory.createModelForGraph((Graph)g));
    }

    public static class BulkUpdatingUnion
    extends Union {
        private Model baseModel;
        private Model plusModel;

        public BulkUpdatingUnion(Model baseModel, Model plusModel) {
            super(baseModel.getGraph(), plusModel.getGraph());
            this.baseModel = baseModel;
            this.plusModel = plusModel;
        }

        public String toString() {
            return "BulkUpdatingUnion[" + ToString.hashHex((Object)this) + ", L=" + ToString.graphToString(this.L) + ", R=" + ToString.graphToString(this.R) + "]";
        }

        public Model getBaseModel() {
            return this.baseModel;
        }

        public Model getPlusModel() {
            return this.plusModel;
        }
    }
}

