/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.ChangeSetImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.vocabulary.RDF;

public abstract class RDFServiceImpl
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceImpl.class);
    protected String defaultWriteGraphURI;
    protected List<ChangeListener> registeredListeners = new CopyOnWriteArrayList<ChangeListener>();
    protected List<ModelChangedListener> registeredJenaListeners = new CopyOnWriteArrayList<ModelChangedListener>();
    protected final List<String> graphURIs = new CopyOnWriteArrayList<String>();
    protected volatile boolean rebuildGraphURICache = true;
    protected volatile boolean isRebuildGraphURICacheRunning = false;
    private VitroRequest vitroRequest;

    @Override
    public void newIndividual(String individualURI, String individualTypeURI) throws RDFServiceException {
        this.newIndividual(individualURI, individualTypeURI, this.defaultWriteGraphURI);
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI, String graphURI) throws RDFServiceException {
        StringBuilder containsQuery = new StringBuilder("ASK { \n");
        if (graphURI != null) {
            containsQuery.append("  GRAPH <").append(graphURI).append("> { ");
        }
        containsQuery.append("<");
        containsQuery.append(individualURI);
        containsQuery.append("> ");
        containsQuery.append("?p ?o");
        if (graphURI != null) {
            containsQuery.append(" } \n");
        }
        containsQuery.append("\n}");
        if (this.sparqlAskQuery(containsQuery.toString())) {
            throw new RDFServiceException("individual already exists");
        }
        Triple triple = new Triple(NodeFactory.createURI((String)individualURI), RDF.type.asNode(), NodeFactory.createURI((String)individualTypeURI));
        ChangeSet cs = this.manufactureChangeSet();
        cs.addAddition(new ByteArrayInputStream(RDFServiceImpl.sparqlTriple(triple).getBytes()), RDFService.ModelSerializationFormat.N3, graphURI);
        this.changeSetUpdate(cs);
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        if (this.rebuildGraphURICache && !this.isRebuildGraphURICacheRunning) {
            this.rebuildGraphUris();
        }
        return this.graphURIs;
    }

    protected abstract void rebuildGraphUris();

    @Override
    public String getDefaultWriteGraphURI() throws RDFServiceException {
        return this.defaultWriteGraphURI;
    }

    @Override
    public synchronized void registerListener(ChangeListener changeListener) throws RDFServiceException {
        if (!this.registeredListeners.contains(changeListener)) {
            this.registeredListeners.add(changeListener);
        }
    }

    @Override
    public synchronized void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.registeredListeners.remove(changeListener);
    }

    @Override
    public synchronized void registerJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        if (!this.registeredJenaListeners.contains(changeListener)) {
            this.registeredJenaListeners.add(changeListener);
        }
    }

    @Override
    public synchronized void unregisterJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.registeredJenaListeners.remove(changeListener);
    }

    public synchronized List<ChangeListener> getRegisteredListeners() {
        return this.registeredListeners;
    }

    public synchronized List<ModelChangedListener> getRegisteredJenaModelChangedListeners() {
        return this.registeredJenaListeners;
    }

    @Override
    public ChangeSet manufactureChangeSet() {
        return new ChangeSetImpl();
    }

    protected void notifyListenersOfChanges(ChangeSet changeSet) throws IOException {
        if (this.registeredListeners.isEmpty() && this.registeredJenaListeners.isEmpty()) {
            return;
        }
        for (ModelChange modelChange : changeSet.getModelChanges()) {
            this.notifyListeners(modelChange);
        }
    }

    protected void notifyListeners(ModelChange modelChange) throws IOException {
        for (ChangeListener listener : this.registeredListeners) {
            modelChange.getSerializedModel().reset();
            listener.notifyModelChange(modelChange);
        }
        log.debug((Object)(this.registeredJenaListeners.size() + " registered Jena listeners"));
        if (this.registeredJenaListeners.isEmpty()) {
            return;
        }
        modelChange.getSerializedModel().reset();
        Model tempModel = ModelFactory.createDefaultModel();
        Iterator<ModelChangedListener> jenaIter = this.registeredJenaListeners.iterator();
        while (jenaIter.hasNext()) {
            ModelChangedListener listener = jenaIter.next();
            log.debug((Object)("\t" + listener.getClass().getSimpleName()));
            tempModel.register(listener);
        }
        if (ModelChange.Operation.ADD.equals((Object)modelChange.getOperation())) {
            tempModel.read(modelChange.getSerializedModel(), null, RDFServiceUtils.getSerializationFormatString(modelChange.getSerializationFormat()));
        } else if (ModelChange.Operation.REMOVE.equals((Object)modelChange.getOperation())) {
            tempModel.remove(RDFServiceUtils.parseModel(modelChange.getSerializedModel(), modelChange.getSerializationFormat()));
        }
        while (jenaIter.hasNext()) {
            tempModel.unregister(jenaIter.next());
        }
    }

    public void notifyListenersOfEvent(Object event) {
        for (ChangeListener changeListener : this.registeredListeners) {
            changeListener.notifyEvent(null, event);
        }
        for (ModelChangedListener modelChangedListener : this.registeredJenaListeners) {
            modelChangedListener.notifyEvent(null, event);
        }
    }

    protected boolean isPreconditionSatisfied(String query, RDFService.SPARQLQueryType queryType) throws RDFServiceException {
        Model model = ModelFactory.createDefaultModel();
        switch (queryType) {
            case DESCRIBE: {
                model.read(this.sparqlDescribeQuery(query, RDFService.ModelSerializationFormat.N3), null);
                return !model.isEmpty();
            }
            case CONSTRUCT: {
                model.read(this.sparqlConstructQuery(query, RDFService.ModelSerializationFormat.N3), null);
                return !model.isEmpty();
            }
            case SELECT: {
                return this.sparqlSelectQueryHasResults(query);
            }
            case ASK: {
                return this.sparqlAskQuery(query);
            }
        }
        throw new RDFServiceException("unrecognized SPARQL query type");
    }

    protected static String getSerializationFormatString(RDFService.ModelSerializationFormat format) {
        switch (format) {
            case RDFXML: {
                return "RDF/XML";
            }
            case N3: {
                return "TTL";
            }
            case NTRIPLE: {
                return "N-TRIPLE";
            }
        }
        log.error((Object)"unexpected format in getFormatString");
        return null;
    }

    protected boolean sparqlSelectQueryHasResults(String queryStr) throws RDFServiceException {
        ResultSetConsumer.HasResult hasResult = new ResultSetConsumer.HasResult();
        this.sparqlSelectQuery(queryStr, hasResult);
        return hasResult.hasResult();
    }

    protected static String sparqlTriple(Triple triple) {
        StringBuilder serializedTriple = new StringBuilder();
        serializedTriple.append(RDFServiceImpl.sparqlNodeUpdate(triple.getSubject(), ""));
        serializedTriple.append(" ");
        serializedTriple.append(RDFServiceImpl.sparqlNodeUpdate(triple.getPredicate(), ""));
        serializedTriple.append(" ");
        serializedTriple.append(RDFServiceImpl.sparqlNodeUpdate(triple.getObject(), ""));
        serializedTriple.append(" .");
        return serializedTriple.toString();
    }

    protected static String sparqlNodeUpdate(Node node, String varName) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel().replaceAll("\\W", "");
        }
        return RDFServiceImpl.sparqlNode(node, varName);
    }

    protected static String sparqlNode(Node node, String varName) {
        if (node == null || node.isVariable()) {
            return varName;
        }
        if (node.isBlank()) {
            return "<fake:blank>";
        }
        if (node.isURI()) {
            StringBuilder uriBuff = new StringBuilder();
            return uriBuff.append("<").append(node.getURI()).append(">").toString();
        }
        if (node.isLiteral()) {
            StringBuffer literalBuff = new StringBuffer();
            literalBuff.append("\"");
            RDFServiceImpl.pyString(literalBuff, node.getLiteralLexicalForm());
            literalBuff.append("\"");
            if (node.getLiteralLanguage() != null && node.getLiteralLanguage().length() > 0) {
                literalBuff.append("@").append(node.getLiteralLanguage());
            } else if (node.getLiteralDatatypeURI() != null) {
                literalBuff.append("^^<").append(node.getLiteralDatatypeURI()).append(">");
            }
            return literalBuff.toString();
        }
        return varName;
    }

    protected static void pyString(StringBuffer sbuff, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (c == '\n') {
                sbuff.append("\\n");
                continue;
            }
            if (c == '\t') {
                sbuff.append("\\t");
                continue;
            }
            if (c == '\r') {
                sbuff.append("\\r");
                continue;
            }
            if (c == '\f') {
                sbuff.append("\\f");
                continue;
            }
            if (c == '\b') {
                sbuff.append("\\b");
                continue;
            }
            if (c == '\u0007') {
                sbuff.append("\\a");
                continue;
            }
            sbuff.append(c);
        }
    }

    protected Model[] separateStatementsWithBlankNodes(Model gm) {
        Model blankNodeModel = ModelFactory.createDefaultModel();
        Model nonBlankNodeModel = ModelFactory.createDefaultModel();
        StmtIterator sit = gm.listStatements();
        while (sit.hasNext()) {
            Statement stmt = sit.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) {
                nonBlankNodeModel.add(stmt);
                continue;
            }
            blankNodeModel.add(stmt);
        }
        Model[] result = new Model[]{blankNodeModel, nonBlankNodeModel};
        return result;
    }

    protected Query createQuery(String queryString) throws RDFServiceException {
        List<Syntax> syntaxes = Arrays.asList(Syntax.defaultQuerySyntax, Syntax.syntaxSPARQL_11, Syntax.syntaxSPARQL_10, Syntax.syntaxSPARQL, Syntax.syntaxARQ);
        Query q = null;
        Iterator<Syntax> syntaxIt = syntaxes.iterator();
        while (q == null) {
            Syntax syntax = syntaxIt.next();
            try {
                q = QueryFactory.create((String)queryString, (Syntax)syntax);
            }
            catch (QueryParseException e) {
                if (syntaxIt.hasNext()) continue;
                throw new RDFServiceException("Failed to parse query \"" + queryString + "\"", e);
            }
        }
        return q;
    }

    public String toString() {
        return ToString.simpleName(this) + "[" + ToString.hashHex(this) + "]";
    }

    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        StringBuilder whereClause = new StringBuilder();
        if (subject != null) {
            this.appendNode(whereClause.append(' '), subject);
        } else {
            whereClause.append(" ?s");
        }
        if (predicate != null) {
            this.appendNode(whereClause.append(' '), predicate);
        } else {
            whereClause.append(" ?p");
        }
        if (object != null) {
            this.appendNode(whereClause.append(' '), object);
        } else {
            whereClause.append(" ?o");
        }
        long estimate = -1L;
        StringBuilder count = new StringBuilder();
        count.append("SELECT (COUNT(*) AS ?count) WHERE { ");
        count.append(whereClause.toString());
        count.append(" . ");
        count.append(" }");
        CountConsumer countConsumer = new CountConsumer();
        this.sparqlSelectQuery(count.toString(), countConsumer);
        return countConsumer.count;
    }

    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        StringBuilder whereClause = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        if (subject != null) {
            this.appendNode(whereClause.append(' '), subject);
        } else {
            whereClause.append(" ?s");
            orderBy.append(" ?s");
        }
        if (predicate != null) {
            this.appendNode(whereClause.append(' '), predicate);
        } else {
            whereClause.append(" ?p");
            orderBy.append(" ?p");
        }
        if (object != null) {
            this.appendNode(whereClause.append(' '), object);
        } else {
            whereClause.append(" ?o");
            orderBy.append(" ?o");
        }
        StringBuilder constructQuery = new StringBuilder();
        constructQuery.append("CONSTRUCT { ");
        constructQuery.append(whereClause.toString());
        constructQuery.append(" } WHERE { ");
        constructQuery.append(whereClause.toString()).append(" . ");
        constructQuery.append(" }");
        if (orderBy.length() > 0) {
            constructQuery.append(" ORDER BY").append(orderBy.toString());
        }
        if (limit > 0L) {
            constructQuery.append(" LIMIT ").append(limit);
        }
        if (offset > 0L) {
            constructQuery.append(" OFFSET ").append(offset);
        }
        Model triples = ModelFactory.createDefaultModel();
        this.sparqlConstructQuery(constructQuery.toString(), triples);
        return triples;
    }

    private void appendNode(StringBuilder builder, RDFNode node) {
        if (node.isLiteral()) {
            builder.append(this.literalToString(node.asLiteral()));
        } else if (node.isURIResource()) {
            builder.append('<').append(node.asResource().getURI()).append('>');
        }
    }

    private String literalToString(Literal l) {
        StringWriterI sw = new StringWriterI();
        NodeFormatterTTL fmt = new NodeFormatterTTL(null, null);
        fmt.formatLiteral((AWriter)sw, l.asNode());
        return sw.toString();
    }

    @Override
    public void setVitroRequest(VitroRequest vitroRequest) {
        this.vitroRequest = vitroRequest;
    }

    @Override
    public VitroRequest getVitroRequest() {
        return this.vitroRequest;
    }

    protected void updateGraphURIs(Set<String> newURIs) {
        HashSet<String> oldURIs = new HashSet<String>(this.graphURIs);
        if (newURIs.equals(oldURIs)) {
            return;
        }
        HashSet<String> removedURIs = new HashSet<String>(oldURIs);
        removedURIs.removeAll(newURIs);
        this.graphURIs.removeAll(removedURIs);
        HashSet<String> addedURIs = new HashSet<String>(newURIs);
        addedURIs.removeAll(oldURIs);
        this.graphURIs.addAll(addedURIs);
    }

    class CountConsumer
    extends ResultSetConsumer {
        public long count = -1L;

        CountConsumer() {
        }

        @Override
        protected void processQuerySolution(QuerySolution qs) {
            if (this.count == -1L) {
                Literal literal = qs.getLiteral("count");
                this.count = literal.getLong();
            }
        }
    }
}

