/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.IndividualAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.SimpleAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.SparqlUtils;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;

@WebServlet(name="DataAutocompleteController", urlPatterns={"/dataautocomplete"})
public class DataAutocompleteController
extends VitroAjaxController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DataAutocompleteController.class);
    private static final String PARAM_QUERY = "term";
    private static final String PARAM_PROPERTY = "property";
    private static final int DEFAULT_MAX_HIT_COUNT = 1000;
    private static final String QUERY_TEXT = "SELECT DISTINCT ?subject ?prop ?object ?dataLiteral \nWHERE {\n  ?subject ?prop ?object .\n  VALUES ?prop { ?property }\n  BIND(STR(?object) as ?dataLiteral )\n  FILTER(REGEX(?dataLiteral, ?term, \"i\"))\n}\nORDER BY ?dataLiteral\n LIMIT 1000";
    String NORESULT_MSG = "";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.USE_BASIC_AJAX_CONTROLLERS.ACTION;
    }

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse response) throws IOException, ServletException {
        try {
            String qtxt = vreq.getParameter(PARAM_QUERY);
            String property = vreq.getParameter(PARAM_PROPERTY);
            String sparqlQuery = this.getSparqlQuery(qtxt, property);
            OntModel model = this.getModel(vreq);
            Query query = SparqlUtils.createQuery(sparqlQuery);
            this.outputResults(response, query, model, vreq);
        }
        catch (SparqlUtils.AjaxControllerException ex) {
            log.error((Object)ex, (Throwable)ex);
            response.sendError(ex.getStatusCode());
        }
        catch (Throwable e) {
            log.error((Object)e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputResults(HttpServletResponse response, Query query, OntModel model, VitroRequest vreq) throws IOException {
        Dataset dataset = DatasetFactory.create((Model)model);
        ArrayList<String> outputResults = new ArrayList<String>();
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                String objectValue;
                String propertyUri;
                String subjectUri;
                RDFNode object;
                RDFNode property;
                QuerySolution qs = results.nextSolution();
                RDFNode subject = qs.get("subject");
                if (!subject.isResource() || subject.isAnon() || !(property = qs.get("prop")).isResource() || property.isAnon() || !(object = qs.get("object")).isLiteral() || !this.isAuthorized(vreq, qs, model, subjectUri = subject.asResource().getURI(), propertyUri = property.asResource().getURI(), objectValue = object.asLiteral().getLexicalForm())) continue;
                Literal dataLiteral = qs.getLiteral("dataLiteral");
                String dataValue = dataLiteral.getString();
                outputResults.add(dataValue);
            }
            ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
            for (String res : outputResults) {
                jsonArray.add(res);
            }
            try {
                response.getWriter().write(jsonArray.toString());
            }
            catch (Throwable e) {
                log.error((Object)e, e);
                this.doSearchError(response);
            }
        }
    }

    private boolean isAuthorized(VitroRequest vreq, QuerySolution qs, OntModel model, String subjectUri, String propertyUri, String objectValue) {
        DataPropertyStatementAccessObject dataPropertyStatementAccessObject = new DataPropertyStatementAccessObject(model, subjectUri, propertyUri, objectValue);
        SimpleAuthorizationRequest dataPropertyRequest = new SimpleAuthorizationRequest(dataPropertyStatementAccessObject, AccessOperation.DISPLAY);
        if ("http://www.w3.org/2000/01/rdf-schema#label".equals(propertyUri)) {
            IndividualAccessObject individualAccessObject = new IndividualAccessObject(subjectUri);
            individualAccessObject.setModel((Model)model);
            SimpleAuthorizationRequest individualRequest = new SimpleAuthorizationRequest(individualAccessObject, AccessOperation.DISPLAY);
            AuthorizationRequest requests = dataPropertyRequest.and(individualRequest);
            return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, requests);
        }
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest)dataPropertyRequest);
    }

    private OntModel getModel(VitroRequest vreq) throws SparqlUtils.AjaxControllerException {
        OntModel model = vreq.getJenaOntModel();
        if (model == null) {
            throw new SparqlUtils.AjaxControllerException(500, "Model '' not found.");
        }
        return model;
    }

    private String getSparqlQuery(String qtxt, String property) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString(QUERY_TEXT);
        pss.setIri(PARAM_PROPERTY, property);
        pss.setLiteral(PARAM_QUERY, "^" + qtxt);
        return pss.toString();
    }

    private void doSearchError(HttpServletResponse response) throws IOException {
        this.doNoSearchResults(response);
    }

    private void doNoSearchResults(HttpServletResponse response) throws IOException {
        response.getWriter().write("[]");
    }
}

