/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import org.apache.jena.rdf.model.RDFNode;

public class FilterValue {
    private String id;
    private String name = "";
    private int order;
    private long count;
    private boolean selected = false;
    private boolean isDefaultValue;
    private boolean publiclyAvailable = true;

    public boolean isPubliclyAvailable() {
        return this.publiclyAvailable;
    }

    public void setPubliclyAvailable(RDFNode rdfNode) {
        this.publiclyAvailable = rdfNode != null && rdfNode.isLiteral() ? rdfNode.asLiteral().getBoolean() : false;
    }

    public FilterValue(String id) {
        this.id = id;
    }

    public boolean isDefault() {
        return this.isDefaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String label) {
        this.name = label;
    }

    public void setName(RDFNode rdfNode) {
        if (rdfNode != null) {
            this.name = rdfNode.asLiteral().getLexicalForm();
        }
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(RDFNode rdfNode) {
        if (rdfNode != null) {
            this.order = rdfNode.asLiteral().getInt();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getCount() {
        return this.count;
    }

    public void setSelected(boolean value) {
        this.selected = value;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setDefault(boolean b) {
        this.isDefaultValue = b;
    }
}

